/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openwebbeans.deployment;

import java.io.InputStream;
import java.lang.reflect.Member;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.enterprise.inject.Produces;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.openejb.cdi.WebBeansConfigurationListener;
import org.apache.geronimo.web.info.WebAppInfo;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.WebApp;
import org.apache.xbean.finder.AbstractFinder;
import org.apache.xbean.finder.BundleAnnotationFinder;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xbean.osgi.bundle.util.BundleResourceFinder;
import org.apache.xbean.osgi.bundle.util.DiscoveryRange;
import org.apache.xbean.osgi.bundle.util.ResourceDiscoveryFilter;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="ModuleBuilder")
public class OpenWebBeansModuleBuilderExtension
implements ModuleBuilderExtension {
    private static final Logger log = LoggerFactory.getLogger(OpenWebBeansModuleBuilderExtension.class);
    private final Environment defaultEnvironment;
    private final Environment jsfPluginEnvironment;
    private final NamingBuilder namingBuilders;
    private static final String CONTEXT_LISTENER_NAME = WebBeansConfigurationListener.class.getName();

    public OpenWebBeansModuleBuilderExtension(@ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment, @ParamAttribute(name="jsfPluginEnvironment") Environment jsfPluginEnvironment, @ParamReference(name="NamingBuilders", namingType="ModuleBuilder") NamingBuilder namingBuilders) {
        this.defaultEnvironment = defaultEnvironment;
        this.jsfPluginEnvironment = jsfPluginEnvironment;
        this.namingBuilders = namingBuilders;
    }

    public void createModule(Module module, Bundle bundle, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        if (!(module instanceof WebModule)) {
            return;
        }
        EnvironmentBuilder.mergeEnvironments((Environment)module.getEnvironment(), (Environment)this.defaultEnvironment);
        if (this.hasBeanXml(module)) {
            EnvironmentBuilder.mergeEnvironments((Environment)module.getEnvironment(), (Environment)this.jsfPluginEnvironment);
        }
    }

    public void createModule(Module module, Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        if (!(module instanceof WebModule)) {
            return;
        }
        EnvironmentBuilder.mergeEnvironments((Environment)module.getEnvironment(), (Environment)this.defaultEnvironment);
        if (this.hasBeanXml(module)) {
            EnvironmentBuilder.mergeEnvironments((Environment)module.getEnvironment(), (Environment)this.jsfPluginEnvironment);
        }
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repository) throws DeploymentException {
    }

    public void initContext(EARContext earContext, Module module, Bundle bundle) throws DeploymentException {
    }

    public void addGBeans(EARContext earContext, Module module, Bundle bundle, Collection repository) throws DeploymentException {
        if (!(module instanceof WebModule)) {
            return;
        }
        WebModule webModule = (WebModule)module;
        EARContext moduleContext = module.getEarContext();
        Map sharedContext = module.getSharedContext();
        GBeanData webAppData = (GBeanData)sharedContext.get("WEB_APP_DATA");
        WebAppInfo webAppInfo = (WebAppInfo)webAppData.getAttribute("webAppInfo");
        if (webAppInfo != null && !webAppInfo.listeners.contains(CONTEXT_LISTENER_NAME)) {
            webAppInfo.listeners.add(0, CONTEXT_LISTENER_NAME);
        }
        AbstractName moduleName = moduleContext.getModuleName();
        HashMap<EARContext.Key, Object> buildingContext = new HashMap<EARContext.Key, Object>();
        buildingContext.put(NamingBuilder.GBEAN_NAME_KEY, moduleName);
        Holder holder = (Holder)NamingBuilder.INJECTION_KEY.get(sharedContext);
        buildingContext.put(NamingBuilder.INJECTION_KEY, holder);
        WebApp webApp = (WebApp)webModule.getSpecDD();
        XmlObject geronimoWebApp = (XmlObject)webModule.getVendorDD();
        AbstractFinder originalFinder = webModule.getClassFinder();
        ClassFinder classFinder = this.createOpenWebBeansClassFinder(webApp, webModule);
        webModule.setClassFinder((AbstractFinder)classFinder);
        this.namingBuilders.buildNaming((JndiConsumer)webApp, geronimoWebApp, (Module)webModule, buildingContext);
        webModule.setClassFinder(originalFinder);
    }

    private boolean hasBeansXml(Bundle bundle) {
        return bundle.getEntry("WEB-INF/beans.xml") != null || bundle.getResource("META-INF/beans.xml") != null;
    }

    private boolean hasBeanXml(Module webModule) {
        return webModule.getDeployable().getResource("WEB-INF/beans.xml") != null || webModule.getDeployable().getResource("META-INF/beans.xml") != null;
    }

    protected ClassFinder createOpenWebBeansClassFinder(WebApp webApp, WebModule webModule) throws DeploymentException {
        List<Class<?>> classes = this.getManagedClasses(webApp, webModule);
        return new ClassFinder(classes);
    }

    private List<Class<?>> getManagedClasses(WebApp webApp, WebModule webModule) throws DeploymentException {
        Bundle bundle = webModule.getEarContext().getDeploymentBundle();
        ServiceReference reference = bundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        try {
            Class[] annotation;
            PackageAdmin packageAdmin = (PackageAdmin)bundle.getBundleContext().getService(reference);
            final HashSet annotationScanRequiredJarFiles = new HashSet();
            String moduleNamePrefix = webModule.isStandAlone() ? "" : webModule.getTargetPath() + "/";
            BundleResourceFinder resourceFinder = new BundleResourceFinder(packageAdmin, bundle, "META-INF/", "beans.xml", new ResourceDiscoveryFilter(){

                public boolean directoryDiscoveryRequired(String directoryName) {
                    return false;
                }

                public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
                    return discoveryRange == DiscoveryRange.BUNDLE_CLASSPATH;
                }

                public boolean zipFileDiscoveryRequired(String zipFileName) {
                    return zipFileName.endsWith(".jar");
                }
            });
            resourceFinder.find(new BundleResourceFinder.ResourceFinderCallback(){

                public boolean foundInDirectory(Bundle arg0, String arg1, URL arg2) throws Exception {
                    return false;
                }

                public boolean foundInJar(Bundle bundle, String zipFileName, ZipEntry zipEntry, InputStream in) throws Exception {
                    String zipEntryName = zipEntry.getName();
                    if (zipEntryName.equals("META-INF/beans.xml")) {
                        annotationScanRequiredJarFiles.add(zipFileName);
                    }
                    return true;
                }
            });
            final String webInfClassesFolder = moduleNamePrefix + "WEB-INF/classes/";
            final boolean webInfClassesScanRequired = bundle.getEntry(moduleNamePrefix + "WEB-INF/beans.xml") != null;
            BundleAnnotationFinder bundleAnnotationFinder = new BundleAnnotationFinder(packageAdmin, bundle, new ResourceDiscoveryFilter(){

                public boolean directoryDiscoveryRequired(String directory) {
                    return directory.equals(webInfClassesFolder) && webInfClassesScanRequired;
                }

                public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
                    return discoveryRange.equals((Object)DiscoveryRange.BUNDLE_CLASSPATH);
                }

                public boolean zipFileDiscoveryRequired(String jarFile) {
                    return annotationScanRequiredJarFiles.contains(jarFile);
                }
            });
            ArrayList members = new ArrayList();
            for (Class annotationClass : annotation = new Class[]{Produces.class, EJB.class, PersistenceContext.class, PersistenceUnit.class, Resource.class}) {
                members.addAll(bundleAnnotationFinder.findAnnotatedMethods(annotationClass));
                members.addAll(bundleAnnotationFinder.findAnnotatedFields(annotationClass));
            }
            HashSet classes = new HashSet();
            for (Member member : members) {
                classes.add(member.getDeclaringClass());
            }
            ArrayList arrayList = new ArrayList(classes);
            return arrayList;
        }
        catch (Exception e) {
            throw new DeploymentException("Fail to scan jsr299 annotations", (Throwable)e);
        }
        finally {
            bundle.getBundleContext().ungetService(reference);
        }
    }
}

