/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import javax.naming.Context;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContextImpl;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.naming.java.RootContext;
import org.apache.geronimo.openejb.EjbDeployment;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeronimoThreadContextListener
implements ThreadContextListener {
    private static final Logger log = LoggerFactory.getLogger(GeronimoThreadContextListener.class);
    private static final GeronimoThreadContextListener instance = new GeronimoThreadContextListener();

    public static void init() {
    }

    private GeronimoThreadContextListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextEntered(ThreadContext oldContext, ThreadContext newContext) {
        Subject defaultSubject;
        EjbDeployment ejbDeployment;
        CoreDeploymentInfo deploymentInfo = newContext.getDeploymentInfo();
        if (deploymentInfo == null) {
            return;
        }
        if (deploymentInfo.get(EjbDeployment.class) == null) {
            CoreDeploymentInfo coreDeploymentInfo = deploymentInfo;
            synchronized (coreDeploymentInfo) {
                if (deploymentInfo.get(EjbDeployment.class) == null && !deploymentInfo.isDestroyed()) {
                    try {
                        deploymentInfo.wait();
                    }
                    catch (InterruptedException e) {
                        log.warn("Wait on deploymentInfo interrupted unexpectedly");
                    }
                }
            }
        }
        if ((ejbDeployment = (EjbDeployment)deploymentInfo.get(EjbDeployment.class)) == null) {
            return;
        }
        GeronimoCallContext geronimoCallContext = new GeronimoCallContext();
        TrackedConnectionAssociator trackedConnectionAssociator = ejbDeployment.getTrackedConnectionAssociator();
        if (trackedConnectionAssociator != null) {
            ConnectorInstanceContextImpl connectorContext = new ConnectorInstanceContextImpl(ejbDeployment.getUnshareableResources(), ejbDeployment.getApplicationManagedSecurityResources());
            try {
                geronimoCallContext.oldConnectorContext = trackedConnectionAssociator.enter((ConnectorInstanceContext)connectorContext);
            }
            catch (ResourceException e) {
                log.error("Error while entering TrackedConnectionAssociator");
                return;
            }
        }
        Context jndiContext = ejbDeployment.getComponentContext();
        geronimoCallContext.oldJndiContext = RootContext.getComponentContext();
        RootContext.setComponentContext((Context)jndiContext);
        geronimoCallContext.contextID = PolicyContext.getContextID();
        String moduleID = newContext.getDeploymentInfo().getModuleID();
        PolicyContext.setContextID((String)moduleID);
        if (ContextManager.getCurrentCaller() == null && (defaultSubject = ejbDeployment.getDefaultSubject()) != null) {
            ContextManager.setCallers((Subject)defaultSubject, (Subject)defaultSubject);
            geronimoCallContext.clearCallers = true;
        }
        Subject runAsSubject = ejbDeployment.getRunAs();
        geronimoCallContext.callers = ContextManager.pushNextCaller((Subject)runAsSubject);
        newContext.set(GeronimoCallContext.class, (Object)geronimoCallContext);
    }

    public void contextExited(ThreadContext exitedContext, ThreadContext reenteredContext) {
        CoreDeploymentInfo deploymentInfo = exitedContext.getDeploymentInfo();
        if (deploymentInfo == null) {
            return;
        }
        EjbDeployment ejbDeployment = (EjbDeployment)deploymentInfo.get(EjbDeployment.class);
        if (ejbDeployment == null) {
            return;
        }
        GeronimoCallContext geronimoCallContext = (GeronimoCallContext)exitedContext.get(GeronimoCallContext.class);
        if (geronimoCallContext == null) {
            return;
        }
        ContextManager.popCallers((Callers)geronimoCallContext.callers);
        if (geronimoCallContext.clearCallers) {
            ContextManager.clearCallers();
        }
        PolicyContext.setContextID((String)geronimoCallContext.contextID);
        RootContext.setComponentContext((Context)geronimoCallContext.oldJndiContext);
        TrackedConnectionAssociator trackedConnectionAssociator = ejbDeployment.getTrackedConnectionAssociator();
        if (trackedConnectionAssociator != null) {
            try {
                trackedConnectionAssociator.exit(geronimoCallContext.oldConnectorContext);
            }
            catch (ResourceException e) {
                log.error("Error while exiting TrackedConnectionAssociator");
            }
        }
    }

    static {
        ThreadContext.addThreadContextListener((ThreadContextListener)instance);
    }

    private static final class GeronimoCallContext {
        private Context oldJndiContext;
        private ConnectorInstanceContext oldConnectorContext;
        private boolean clearCallers;
        private Callers callers;
        private String contextID;

        private GeronimoCallContext() {
        }
    }
}

