/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.spi.HandleDelegate;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.resource.spi.ResourceAdapter;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.ResourceAdapterWrapper;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.openejb.GeronimoSecurityService;
import org.apache.geronimo.openejb.GeronimoThreadContextListener;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.geronimo.persistence.PersistenceUnitGBean;
import org.apache.openejb.Container;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.ClientInfo;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.LinkResolver;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.assembler.classic.ProxyFactoryInfo;
import org.apache.openejb.assembler.classic.SecurityServiceInfo;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.TransactionServiceInfo;
import org.apache.openejb.assembler.classic.UniqueDefaultLinkResolver;
import org.apache.openejb.assembler.dynamic.PassthroughFactory;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.core.ServerFederation;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.proxy.Jdk13ProxyFactory;
import org.omg.CORBA.ORB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenEjbSystemGBean
implements OpenEjbSystem {
    private static final Log log = LogFactory.getLog(OpenEjbSystemGBean.class);
    private final ConfigurationFactory configurationFactory;
    private final Assembler assembler;
    private final Set<String> registeredResouceAdapters = new TreeSet<String>();
    private final ConcurrentMap<String, ResourceAdapterWrapper> processedResourceAdapterWrappers = new ConcurrentHashMap<String, ResourceAdapterWrapper>();
    private final Collection<PersistenceUnitGBean> persistenceUnitGBeans;
    private final Kernel kernel;
    private final ClassLoader classLoader;
    private ORB orb;
    public static final GBeanInfo GBEAN_INFO;

    public OpenEjbSystemGBean(TransactionManager transactionManager) throws Exception {
        this(transactionManager, null, null, null, OpenEjbSystemGBean.class.getClassLoader());
    }

    public OpenEjbSystemGBean(TransactionManager transactionManager, Collection<ResourceAdapterWrapper> resourceAdapters, Collection<PersistenceUnitGBean> persistenceUnitGBeans, Kernel kernel, ClassLoader classLoader) throws Exception {
        this.kernel = kernel;
        this.classLoader = classLoader;
        this.persistenceUnitGBeans = persistenceUnitGBeans == null ? Collections.emptySet() : persistenceUnitGBeans;
        System.setProperty("duct tape", "");
        System.setProperty("admin.disabled", "true");
        SystemInstance systemInstance = SystemInstance.get();
        String format = systemInstance.getProperty("openejb.deploymentId.format");
        if (format == null) {
            systemInstance.setProperty("openejb.deploymentId.format", "{moduleId}/{ejbName}");
        }
        systemInstance.setProperty("openejb.jndiname.strategy.class", "org.apache.openejb.assembler.classic.JndiBuilder$TemplatedStrategy");
        systemInstance.setProperty("openejb.jndiname.format", "{deploymentId}/{interfaceClass}");
        System.setProperty("openejb.naming", "xbean");
        if (transactionManager == null) {
            throw new NullPointerException("transactionManager is null");
        }
        boolean offline = true;
        this.configurationFactory = new ConfigurationFactory(offline);
        this.assembler = new Assembler();
        ServerFederation applicationServer = new ServerFederation();
        SystemInstance.get().setComponent(ApplicationServer.class, (Object)applicationServer);
        transactionManager = OpenEjbSystemGBean.getRawService(kernel, transactionManager);
        TransactionServiceInfo transactionServiceInfo = new TransactionServiceInfo();
        PassthroughFactory.add((ServiceInfo)transactionServiceInfo, (Object)transactionManager);
        transactionServiceInfo.id = "Default Transaction Manager";
        transactionServiceInfo.serviceType = "TransactionManager";
        this.assembler.createTransactionManager(transactionServiceInfo);
        GeronimoSecurityService securityService = new GeronimoSecurityService();
        SecurityServiceInfo securityServiceInfo = new SecurityServiceInfo();
        PassthroughFactory.add((ServiceInfo)securityServiceInfo, (Object)securityService);
        securityServiceInfo.id = "Default Security Service";
        securityServiceInfo.serviceType = "SecurityService";
        this.assembler.createSecurityService(securityServiceInfo);
        ProxyFactoryInfo proxyFactoryInfo = new ProxyFactoryInfo();
        proxyFactoryInfo.id = "Default JDK 1.3 ProxyFactory";
        proxyFactoryInfo.serviceType = "ProxyFactory";
        proxyFactoryInfo.className = Jdk13ProxyFactory.class.getName();
        proxyFactoryInfo.properties = new Properties();
        this.assembler.createProxyFactory(proxyFactoryInfo);
        GeronimoThreadContextListener.init();
        this.processResourceAdapterWrappers(resourceAdapters);
    }

    private static <T> T getRawService(Kernel kernel, T proxy) {
        if (kernel == null) {
            return proxy;
        }
        AbstractName abstractName = kernel.getAbstractNameFor(proxy);
        if (abstractName == null) {
            return proxy;
        }
        try {
            Object service = kernel.getGBean(abstractName);
            return (T)service;
        }
        catch (GBeanNotFoundException gBeanNotFoundException) {
            return proxy;
        }
    }

    private void processResourceAdapterWrappers(Collection<ResourceAdapterWrapper> resourceAdapterWrappers) {
        if (resourceAdapterWrappers == null) {
            return;
        }
        if (resourceAdapterWrappers instanceof ReferenceCollection) {
            ReferenceCollection referenceCollection = (ReferenceCollection)resourceAdapterWrappers;
            referenceCollection.addReferenceCollectionListener(new ReferenceCollectionListener(){

                public void memberAdded(ReferenceCollectionEvent event) {
                    OpenEjbSystemGBean.this.addResourceAdapter((ResourceAdapterWrapper)event.getMember());
                }

                public void memberRemoved(ReferenceCollectionEvent event) {
                    OpenEjbSystemGBean.this.removeResourceAdapter((ResourceAdapterWrapper)event.getMember());
                }
            });
        }
        for (ResourceAdapterWrapper resourceAdapterWrapper : resourceAdapterWrappers) {
            this.addResourceAdapter(resourceAdapterWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResourceAdapter(ResourceAdapterWrapper resourceAdapterWrapper) {
        ResourceAdapter resourceAdapter = resourceAdapterWrapper.getResourceAdapter();
        if (resourceAdapter == null) {
            return;
        }
        if (this.registeredResouceAdapters.contains(resourceAdapterWrapper.getName())) {
            return;
        }
        this.registeredResouceAdapters.add(resourceAdapterWrapper.getName());
        Map listenerToActivationSpecMap = resourceAdapterWrapper.getMessageListenerToActivationSpecMap();
        if (listenerToActivationSpecMap == null) {
            return;
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            for (Map.Entry entry : listenerToActivationSpecMap.entrySet()) {
                String messageListenerInterface = (String)entry.getKey();
                String activationSpecClass = (String)entry.getValue();
                String containerName = this.getResourceAdapterId(resourceAdapterWrapper) + "-" + messageListenerInterface;
                if (this.processedResourceAdapterWrappers.putIfAbsent(containerName, resourceAdapterWrapper) != null) continue;
                try {
                    ContainerInfo containerInfo = (ContainerInfo)this.configurationFactory.configureService(MdbContainerInfo.class);
                    containerInfo.id = containerName;
                    containerInfo.displayName = containerName;
                    containerInfo.properties.put("MessageListenerInterface", resourceAdapter.getClass().getClassLoader().loadClass(messageListenerInterface));
                    containerInfo.properties.put("ActivationSpecClass", resourceAdapter.getClass().getClassLoader().loadClass(activationSpecClass));
                    containerInfo.properties.put("ResourceAdapter", resourceAdapter);
                    this.assembler.createContainer(containerInfo);
                }
                catch (Exception e) {
                    log.error((Object)("Unable to deploy mdb container " + containerName), (Throwable)e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private void removeResourceAdapter(ResourceAdapterWrapper resourceAdapterWrapper) {
        Map listenerToActivationSpecMap = resourceAdapterWrapper.getMessageListenerToActivationSpecMap();
        if (listenerToActivationSpecMap != null) {
            for (String messageListenerInterface : listenerToActivationSpecMap.keySet()) {
                String containerName = this.getResourceAdapterId(resourceAdapterWrapper) + "-" + messageListenerInterface;
                this.processedResourceAdapterWrappers.remove(containerName);
                this.assembler.removeContainer(containerName);
            }
            this.registeredResouceAdapters.remove(resourceAdapterWrapper.getName());
        }
    }

    private String getResourceAdapterId(ResourceAdapterWrapper resourceAdapterWrapper) {
        String name = resourceAdapterWrapper.getName();
        try {
            ObjectName objectName = new ObjectName(name);
            Hashtable<String, String> properties = objectName.getKeyPropertyList();
            String shortName = (String)properties.get("name");
            String moduleName = (String)properties.get("ResourceAdapterModule");
            if (shortName != null && moduleName != null) {
                return moduleName + "." + shortName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    @Override
    public ContainerSystem getContainerSystem() {
        return this.assembler.getContainerSystem();
    }

    @Override
    public Container createContainer(Class<? extends ContainerInfo> type, String serviceId, Properties declaredProperties, String providerId) throws OpenEJBException {
        ContainerInfo containerInfo = (ContainerInfo)this.configurationFactory.configureService(type, serviceId, declaredProperties, providerId, "Container");
        this.assembler.createContainer(containerInfo);
        Container container = this.assembler.getContainerSystem().getContainer((Object)serviceId);
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientInfo configureApplication(ClientModule clientModule) throws OpenEJBException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(clientModule.getClassLoader());
        try {
            ClientInfo clientInfo = this.configurationFactory.configureApplication(clientModule);
            return clientInfo;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppInfo configureApplication(AppModule appModule) throws OpenEJBException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(appModule.getClassLoader());
        try {
            AppInfo appInfo = this.configurationFactory.configureApplication(appModule);
            return appInfo;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EjbJarInfo configureApplication(EjbModule ejbModule) throws OpenEJBException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ejbModule.getClassLoader());
        try {
            EjbJarInfo ejbJarInfo = this.configurationFactory.configureApplication(ejbModule);
            return ejbJarInfo;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createClient(ClientInfo clientInfo, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            this.assembler.createClient(clientInfo, classLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createEjbJar(EjbJarInfo ejbJarInfo, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        Set names = this.kernel.listGBeans(new AbstractNameQuery(ResourceAdapterWrapper.class.getName()));
        for (AbstractName name : names) {
            try {
                ResourceAdapterWrapper resourceAdapterWrapper = (ResourceAdapterWrapper)this.kernel.getGBean(name);
                this.addResourceAdapter(resourceAdapterWrapper);
            }
            catch (GBeanNotFoundException ignored) {}
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        UniqueDefaultLinkResolver emfLinkResolver = new UniqueDefaultLinkResolver();
        for (PersistenceUnitGBean persistenceUnitGBean : this.persistenceUnitGBeans) {
            EntityManagerFactory factory = persistenceUnitGBean.getEntityManagerFactory();
            String persistenceUnitRoot = persistenceUnitGBean.getPersistenceUnitRoot();
            String persistenceUnitName = persistenceUnitGBean.getPersistenceUnitName();
            if ("cmp".equals(persistenceUnitName)) continue;
            emfLinkResolver.add(persistenceUnitRoot, persistenceUnitName, (Object)factory);
        }
        try {
            this.assembler.createEjbJar(ejbJarInfo, (LinkResolver)emfLinkResolver, classLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public void removeEjbJar(EjbJarInfo ejbJarInfo, ClassLoader classLoader) throws UndeployException, NoSuchApplicationException {
        this.assembler.destroyApplication(ejbJarInfo.jarPath);
    }

    @Override
    public DeploymentInfo getDeploymentInfo(String deploymentId) {
        return this.getContainerSystem().getDeploymentInfo((Object)deploymentId);
    }

    @Override
    public void setORBContext(ORB orb, HandleDelegate handleDelegate) {
        if (this.orb == null) {
            this.orb = orb;
            SystemInstance.get().setComponent(ORB.class, (Object)orb);
            SystemInstance.get().setComponent(HandleDelegate.class, (Object)handleDelegate);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(OpenEjbSystemGBean.class);
        infoBuilder.addReference("TransactionManager", TransactionManager.class);
        infoBuilder.addReference("ResourceAdapterWrappers", ResourceAdapterWrapper.class);
        infoBuilder.addReference("PersistenceUnitGBeans", PersistenceUnitGBean.class);
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.setConstructor(new String[]{"TransactionManager", "ResourceAdapterWrappers", "PersistenceUnitGBeans", "kernel", "classLoader"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

