/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.lang.reflect.Method;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBObject;
import javax.naming.Context;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.management.EJB;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.apache.openejb.BeanType;
import org.apache.openejb.Container;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.ivm.EjbObjectProxyHandler;

public class EjbDeployment
implements EJB {
    private final String objectName;
    private final String deploymentId;
    private final String ejbName;
    private final String homeInterfaceName;
    private final String remoteInterfaceName;
    private final String localHomeInterfaceName;
    private final String localInterfaceName;
    private final String serviceEndpointInterfaceName;
    private final String beanClassName;
    private final ClassLoader classLoader;
    private final boolean securityEnabled;
    private final Subject defaultSubject;
    private final Subject runAs;
    private final Context componentContext;
    private final Set unshareableResources;
    private final Set applicationManagedSecurityResources;
    private final TrackedConnectionAssociator trackedConnectionAssociator;
    private final OpenEjbSystem openEjbSystem;
    private CoreDeploymentInfo deploymentInfo;
    private Context javaCompSubContext;

    public EjbDeployment() throws LoginException {
        this(null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, null, null);
    }

    public EjbDeployment(String objectName, String deploymentId, String ejbName, String homeInterfaceName, String remoteInterfaceName, String localHomeInterfaceName, String localInterfaceName, String serviceEndpointInterfaceName, String beanClassName, ClassLoader classLoader, boolean securityEnabled, String defaultRole, String runAsRole, RunAsSource runAsSource, Context componentContext, Set unshareableResources, Set applicationManagedSecurityResources, TrackedConnectionAssociator trackedConnectionAssociator, OpenEjbSystem openEjbSystem) throws LoginException {
        this.objectName = objectName;
        this.deploymentId = deploymentId;
        this.ejbName = ejbName;
        this.homeInterfaceName = homeInterfaceName;
        this.remoteInterfaceName = remoteInterfaceName;
        this.localHomeInterfaceName = localHomeInterfaceName;
        this.localInterfaceName = localInterfaceName;
        this.serviceEndpointInterfaceName = serviceEndpointInterfaceName;
        this.beanClassName = beanClassName;
        this.classLoader = classLoader;
        this.securityEnabled = securityEnabled;
        if (runAsSource == null) {
            runAsSource = RunAsSource.NULL;
        }
        this.defaultSubject = defaultRole == null ? runAsSource.getDefaultSubject() : runAsSource.getSubjectForRole(defaultRole);
        this.runAs = runAsSource.getSubjectForRole(runAsRole);
        this.componentContext = componentContext;
        this.unshareableResources = unshareableResources;
        this.applicationManagedSecurityResources = applicationManagedSecurityResources;
        this.trackedConnectionAssociator = trackedConnectionAssociator;
        this.openEjbSystem = openEjbSystem;
    }

    public CoreDeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public String getHomeInterfaceName() {
        return this.homeInterfaceName;
    }

    public String getRemoteInterfaceName() {
        return this.remoteInterfaceName;
    }

    public String getLocalHomeInterfaceName() {
        return this.localHomeInterfaceName;
    }

    public String getLocalInterfaceName() {
        return this.localInterfaceName;
    }

    public String getServiceEndpointInterfaceName() {
        return this.serviceEndpointInterfaceName;
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public Subject getDefaultSubject() {
        return this.defaultSubject;
    }

    public Subject getRunAs() {
        return this.runAs;
    }

    public Context getComponentContext() {
        return this.javaCompSubContext;
    }

    public Set getUnshareableResources() {
        return this.unshareableResources;
    }

    public Set getApplicationManagedSecurityResources() {
        return this.applicationManagedSecurityResources;
    }

    public TrackedConnectionAssociator getTrackedConnectionAssociator() {
        return this.trackedConnectionAssociator;
    }

    public EJBHome getEJBHome() {
        return this.deploymentInfo.getEJBHome();
    }

    public EJBLocalHome getEJBLocalHome() {
        return this.deploymentInfo.getEJBLocalHome();
    }

    public Object getBusinessLocalHome() {
        return this.deploymentInfo.getBusinessLocalHome();
    }

    public Object getBusinessRemoteHome() {
        return this.deploymentInfo.getBusinessRemoteHome();
    }

    public EJBObject getEjbObject(Object primaryKey) {
        return (EJBObject)EjbObjectProxyHandler.createProxy((DeploymentInfo)this.deploymentInfo, (Object)primaryKey, (InterfaceType)InterfaceType.EJB_HOME);
    }

    public Class getHomeInterface() {
        return this.deploymentInfo.getHomeInterface();
    }

    public Class getRemoteInterface() {
        return this.deploymentInfo.getRemoteInterface();
    }

    public Class getLocalHomeInterface() {
        return this.deploymentInfo.getLocalHomeInterface();
    }

    public Class getLocalInterface() {
        return this.deploymentInfo.getLocalInterface();
    }

    public Class getBeanClass() {
        return this.deploymentInfo.getBeanClass();
    }

    public Class getBusinessLocalInterface() {
        return this.deploymentInfo.getBusinessLocalInterface();
    }

    public Class getBusinessRemoteInterface() {
        return this.deploymentInfo.getBusinessRemoteInterface();
    }

    public Class getMdbInterface() {
        return this.deploymentInfo.getMdbInterface();
    }

    public Class getServiceEndpointInterface() {
        return this.deploymentInfo.getServiceEndpointInterface();
    }

    public BeanType getComponentType() {
        return this.deploymentInfo.getComponentType();
    }

    public Container getContainer() {
        return this.deploymentInfo.getContainer();
    }

    public boolean isBeanManagedTransaction() {
        return this.deploymentInfo.isBeanManagedTransaction();
    }

    public byte getTransactionAttribute(Method method) {
        return this.deploymentInfo.getTransactionAttribute(method);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    protected void start() throws Exception {
        this.deploymentInfo = (CoreDeploymentInfo)this.openEjbSystem.getDeploymentInfo(this.deploymentId);
        if (this.deploymentInfo == null) {
            throw new IllegalStateException("Ejb does not exist " + this.deploymentId);
        }
        this.javaCompSubContext = (Context)this.deploymentInfo.getJndiEnc().lookup("java:comp");
        if (this.componentContext != null) {
            this.javaCompSubContext.bind("geronimo", (Object)this.componentContext);
        }
        this.deploymentInfo.set(EjbDeployment.class, (Object)this);
    }

    protected void stop() {
        if (this.deploymentInfo != null) {
            this.deploymentInfo.set(EjbDeployment.class, null);
            this.deploymentInfo = null;
        }
    }
}

