/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.ejb.EntityContext;
import javax.ejb.TimerService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.connector.wrapper.ResourceAdapterWrapperGBean;
import org.apache.geronimo.deployment.Deployable;
import org.apache.geronimo.deployment.DeployableJarFile;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.j2ee.deployment.AppClientModule;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.FragmentContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.jndi.JndiKey;
import org.apache.geronimo.j2ee.jndi.JndiScope;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.openejb.AppInfoGBean;
import org.apache.geronimo.openejb.EjbContainer;
import org.apache.geronimo.openejb.EjbDeployment;
import org.apache.geronimo.openejb.EjbModuleImpl;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.geronimo.openejb.deployment.EjbDeploymentBuilder;
import org.apache.geronimo.openejb.deployment.EjbModule;
import org.apache.geronimo.openejb.deployment.GeronimoAnnotationDeployer;
import org.apache.geronimo.openejb.deployment.XmlUtil;
import org.apache.geronimo.openejb.xbeans.ejbjar.OpenejbGeronimoEjbJarType;
import org.apache.geronimo.persistence.PersistenceUnitGBean;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.Vendor;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.CmpJarBuilder;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.ContainerSystemInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.FacilitiesInfo;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.assembler.classic.MessageDrivenBeanInfo;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.PersistenceContextReferenceInfo;
import org.apache.openejb.assembler.classic.StatefulBeanInfo;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ApplyOpenejbJar;
import org.apache.openejb.config.AutoConfig;
import org.apache.openejb.config.ClearEmptyMappedName;
import org.apache.openejb.config.CmpJpaConversion;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.FinderFactory;
import org.apache.openejb.config.GeneratedClientModules;
import org.apache.openejb.config.GeronimoMappedName;
import org.apache.openejb.config.InitEjbDeployments;
import org.apache.openejb.config.LegacyProcessor;
import org.apache.openejb.config.MappedNameBuilder;
import org.apache.openejb.config.OpenEjb2Conversion;
import org.apache.openejb.config.OutputGeneratedDescriptors;
import org.apache.openejb.config.ReadDescriptors;
import org.apache.openejb.config.SunConversion;
import org.apache.openejb.config.ValidateModules;
import org.apache.openejb.config.ValidationError;
import org.apache.openejb.config.ValidationFailedException;
import org.apache.openejb.config.WlsConversion;
import org.apache.openejb.config.WsDeployer;
import org.apache.openejb.jee.DataSource;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EjbLocalRef;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.MessageDestination;
import org.apache.openejb.jee.MessageDestinationRef;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceUnitRef;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.ServiceRef;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.jpa.unit.TransactionType;
import org.apache.openejb.jee.oejb2.EjbRefType;
import org.apache.openejb.jee.oejb2.GeronimoEjbJarType;
import org.apache.openejb.jee.oejb2.MessageDrivenBeanType;
import org.apache.openejb.jee.oejb2.OpenejbJarType;
import org.apache.openejb.jee.oejb2.PatternType;
import org.apache.openejb.jee.oejb2.ResourceLocatorType;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.osgi.core.BundleFinderFactory;
import org.apache.openejb.util.AnnotationFinder;
import org.apache.openejb.util.UniqueDefaultLinkResolver;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.osgi.bundle.util.BundleClassLoader;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="ModuleBuilder")
public class EjbModuleBuilder
implements ModuleBuilder,
GBeanLifecycle,
ModuleBuilderExtension {
    private static final Logger log = LoggerFactory.getLogger(EjbModuleBuilder.class);
    private static final String DEFAULT_BUNDLE_CLASSPATH = ".";
    private static final boolean EJB_SERVER_SUPPORT;
    private static final String OPENEJBJAR_NAMESPACE;
    private static final Map<String, String> NAMESPACE_UPDATES;
    private final Environment defaultEnvironment;
    private final String defaultCmpJTADataSource;
    private final String defaultCmpNonJTADataSource;
    private final NamespaceDrivenBuilderCollection serviceBuilders;
    private final NamingBuilder namingBuilder;
    private final ResourceEnvironmentSetter resourceEnvironmentSetter;
    private final Collection<ModuleBuilderExtension> moduleBuilderExtensions;
    private static final String LINE_SEP;
    private static final String DEBUGGABLE_VM_HACKERY_PROPERTY = "openejb.debuggable-vm-hackery";
    private static final String VALIDATION_SKIP_PROPERTY = "openejb.validation.skip";
    private static final String WEBSERVICES_ENABLED = "openejb.webservices.enabled";

    public EjbModuleBuilder(@ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment, @ParamAttribute(name="defaultCmpJTADataSource") String defaultCmpJTADataSource, @ParamAttribute(name="defaultCmpNonJTADataSource") String defaultCmpNonJTADataSource, @ParamReference(name="ModuleBuilderExtensions", namingType="ModuleBuilder") Collection<ModuleBuilderExtension> moduleBuilderExtensions, @ParamReference(name="ServiceBuilders", namingType="ModuleBuilder") Collection<NamespaceDrivenBuilder> serviceBuilders, @ParamReference(name="NamingBuilders", namingType="ModuleBuilder") NamingBuilder namingBuilders, @ParamReference(name="ResourceEnvironmentSetter", namingType="ModuleBuilder") ResourceEnvironmentSetter resourceEnvironmentSetter) {
        this.defaultEnvironment = defaultEnvironment;
        this.defaultCmpJTADataSource = defaultCmpJTADataSource;
        this.defaultCmpNonJTADataSource = defaultCmpNonJTADataSource;
        this.serviceBuilders = new NamespaceDrivenBuilderCollection(serviceBuilders);
        this.namingBuilder = namingBuilders;
        this.resourceEnvironmentSetter = resourceEnvironmentSetter;
        if (moduleBuilderExtensions == null) {
            moduleBuilderExtensions = Collections.emptyList();
        }
        this.moduleBuilderExtensions = moduleBuilderExtensions;
        SystemInstance.get().setComponent(FinderFactory.class, (Object)new BundleFinderFactory());
        System.setProperty("openejb.geronimo", "true");
        System.setProperty("admin.disabled", "true");
        System.setProperty("openejb.logger.external", "true");
        System.setProperty("openejb.log.factory", "org.apache.openejb.util.PaxLogStreamFactory");
        this.setDefaultProperty("openejb.deploymentId.format", "{moduleUri}/{ejbName}");
        this.setDefaultProperty("openejb.jndiname.strategy.class", "org.apache.openejb.assembler.classic.JndiBuilder$TemplatedStrategy");
        this.setDefaultProperty("openejb.jndiname.format", "{ejbName}{interfaceType.annotationName}");
        this.setDefaultProperty("openejb.jndiname.failoncollision", "false");
        System.setProperty("openejb.naming", "xbean");
    }

    public void doStart() throws Exception {
        XmlBeansUtil.registerNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doStop() {
        XmlBeansUtil.unregisterNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doFail() {
        this.doStop();
    }

    private void setDefaultProperty(String key, String value) {
        SystemInstance systemInstance = SystemInstance.get();
        String format = systemInstance.getProperty(key);
        if (format == null) {
            systemInstance.setProperty(key, value);
        }
    }

    public String getSchemaNamespace() {
        return OPENEJBJAR_NAMESPACE;
    }

    public Module createModule(Bundle bundle, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return null;
    }

    public Module createModule(File plan, JarFile moduleFile, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        if (!EJB_SERVER_SUPPORT) {
            return null;
        }
        return this.createModule(plan, moduleFile, "ejb.jar", null, null, null, naming, idBuilder, "META-INF/", false);
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, Module parentModule, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        if (!EJB_SERVER_SUPPORT) {
            return null;
        }
        return this.createModule(plan, moduleFile, targetPath, specDDUrl, environment, parentModule, naming, idBuilder, "META-INF/", false);
    }

    public void createModule(Module module, Bundle bundle, Naming naming, ModuleIDBuilder moduleIDBuilder) throws DeploymentException {
    }

    public void createModule(Module module, Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        Module ejbModule;
        if (!EJB_SERVER_SUPPORT) {
            return;
        }
        if ((module instanceof WebModule || module instanceof AppClientModule) && (ejbModule = this.createModule(plan, moduleFile, targetPath, null, environment, module, naming, idBuilder, "WEB-INF/", true)) != null) {
            module.getModules().add(ejbModule);
            module.getModuleLocations().add(targetPath);
            ejbModule.getSharedContext().putAll(module.getSharedContext());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment earEnvironment, Module parentModule, Naming naming, ModuleIDBuilder idBuilder, String ddDir, boolean subModule) throws DeploymentException {
        Iterator i$;
        EjbModule ejbModule;
        boolean standAlone;
        ArrayList<URL> libURLs;
        Map descriptors;
        URL baseUrl;
        String jarPath;
        ArrayList<File> tempFileList;
        URLClassLoader ejbModuleTempClassLoader;
        URLClassLoader detectTempClassLoader;
        block49: {
            String[] doubleCheck;
            if (moduleFile == null) {
                throw new NullPointerException("moduleFile is null");
            }
            if (targetPath == null) {
                throw new NullPointerException("targetPath is null");
            }
            if (targetPath.endsWith("/")) {
                throw new IllegalArgumentException("targetPath must not end with a '/'");
            }
            detectTempClassLoader = null;
            ejbModuleTempClassLoader = null;
            tempFileList = new ArrayList<File>();
            jarPath = moduleFile.getName();
            baseUrl = null;
            descriptors = null;
            File jarFile = new File(moduleFile.getName());
            baseUrl = jarFile.toURI().toURL();
            libURLs = new ArrayList<URL>();
            libURLs.add(baseUrl);
            boolean bl = standAlone = earEnvironment == null;
            if (parentModule instanceof WebModule) {
                Deployable deployable = parentModule.getDeployable();
                if (!(deployable instanceof DeployableJarFile)) {
                    throw new IllegalArgumentException("Expected DeployableJarFile");
                }
                JarFile war = ((DeployableJarFile)deployable).getJarFile();
                Enumeration<JarEntry> entries = war.entries();
                while (entries.hasMoreElements()) {
                    String jarEntryName = entries.nextElement().getName();
                    if (!jarEntryName.startsWith("WEB-INF/lib/") || !jarEntryName.endsWith(".jar")) continue;
                    File libJar = JarUtils.toTempFile((JarFile)war, (String)jarEntryName);
                    tempFileList.add(libJar);
                    libURLs.add(libJar.toURI().toURL());
                    libJar.deleteOnExit();
                }
                standAlone = parentModule.isStandAlone();
            }
            detectTempClassLoader = ClassLoaderUtil.createTempClassLoader((ClassLoader)ClassLoaderUtil.createClassLoader((String)jarPath, (URL[])libURLs.toArray(new URL[0]), (ClassLoader)OpenEJB.class.getClassLoader()));
            ResourceFinder finder = new ResourceFinder("", (ClassLoader)detectTempClassLoader, new URL[]{baseUrl});
            descriptors = finder.getResourcesMap(ddDir);
            for (String entry : doubleCheck = new String[]{"ejb-jar.xml", "geronimo-openejb.xml", "openejb-jar.xml", "beans.xml", "env-entries.properties", "web.xml", "APPLICATION.MF"}) {
                try {
                    URL url = finder.find(ddDir + entry);
                    if (url == null || descriptors.containsKey(entry)) continue;
                    descriptors.put(entry, url);
                }
                catch (IOException descriptorNotFound) {
                    // empty catch block
                }
            }
            if (this.isEjbModule(baseUrl, libURLs, detectTempClassLoader, descriptors)) break block49;
            String[] arr$ = null;
            this.releaseTempClassLoader(detectTempClassLoader);
            this.releaseTempClassLoader(ejbModuleTempClassLoader);
            Iterator i$2 = tempFileList.iterator();
            while (true) {
                if (!i$2.hasNext()) {
                    return arr$;
                }
                File file = (File)i$2.next();
                FileUtils.recursiveDelete((File)file);
            }
        }
        try {
            AbstractName moduleName;
            libURLs.clear();
            libURLs.add(baseUrl);
            ejbModuleTempClassLoader = ClassLoaderUtil.createTempClassLoader((ClassLoader)ClassLoaderUtil.createClassLoader((String)jarPath, (URL[])libURLs.toArray(new URL[0]), (ClassLoader)OpenEJB.class.getClassLoader()));
            org.apache.openejb.config.EjbModule ejbModule2 = new org.apache.openejb.config.EjbModule((ClassLoader)ejbModuleTempClassLoader, null, jarPath, null, null);
            ejbModule2.getAltDDs().putAll(descriptors);
            if (specDDUrl != null) {
                ejbModule2.getAltDDs().put("ejb-jar.xml", specDDUrl);
            }
            XmlObject unknownXmlObject = null;
            if (plan instanceof XmlObject) {
                unknownXmlObject = (XmlObject)plan;
            } else if (plan != null) {
                try {
                    unknownXmlObject = XmlBeansUtil.parse((URL)((File)plan).toURI().toURL(), (ClassLoader)XmlUtil.class.getClassLoader());
                }
                catch (Exception e) {
                    throw new DeploymentException((Throwable)e);
                }
            }
            if (unknownXmlObject != null) {
                XmlCursor xmlCursor = unknownXmlObject.newCursor();
                QName qname = xmlCursor.getName();
                if (qname == null) {
                    xmlCursor.toFirstChild();
                    qname = xmlCursor.getName();
                }
                while (xmlCursor.hasNextToken()) {
                    qname = xmlCursor.getName();
                    if (qname == null || qname.getLocalPart() == null) {
                        xmlCursor.toNextToken();
                        continue;
                    }
                    if (qname.getLocalPart().equals("openejb-jar")) {
                        ejbModule2.getAltDDs().put("openejb-jar.xml", xmlCursor.xmlText());
                        break;
                    }
                    if (qname.getLocalPart().equals("ejb-jar") && qname.getNamespaceURI().equals("http://geronimo.apache.org/xml/ns/j2ee/ejb/openejb-2.0")) {
                        ejbModule2.getAltDDs().put("geronimo-openejb.xml", xmlCursor.xmlText());
                        break;
                    }
                    xmlCursor.toNextToken();
                }
            }
            ReadDescriptors readDescriptors = new ReadDescriptors();
            try {
                readDescriptors.deploy(new AppModule((DeploymentModule)ejbModule2));
            }
            catch (OpenEJBException e) {
                throw new DeploymentException("Failed parsing descriptors for module: " + moduleFile.getName(), (Throwable)e);
            }
            GeronimoEjbJarType geronimoEjbJarType = (GeronimoEjbJarType)ejbModule2.getAltDDs().get("geronimo-openejb.xml");
            if (geronimoEjbJarType == null) {
                String path = standAlone ? new File(moduleFile.getName()).getName() : targetPath;
                geronimoEjbJarType = XmlUtil.createDefaultPlan(path, ejbModule2.getEjbJar());
                ejbModule2.getAltDDs().put("geronimo-openejb.xml", geronimoEjbJarType);
            }
            OpenejbGeronimoEjbJarType geronimoOpenejb = XmlUtil.convertToXmlbeans(geronimoEjbJarType);
            Environment environment = XmlUtil.buildEnvironment(geronimoEjbJarType.getEnvironment(), this.defaultEnvironment);
            if (earEnvironment != null) {
                EnvironmentBuilder.mergeEnvironments((Environment)earEnvironment, (Environment)environment);
                environment = earEnvironment;
                if (!environment.getConfigId().isResolved()) {
                    throw new IllegalStateException("EJB module ID should be fully resolved (not " + environment.getConfigId() + ")");
                }
            } else {
                idBuilder.resolve(environment, new File(moduleFile.getName()).getName(), "car");
            }
            if (parentModule == null) {
                AbstractName earName = naming.createRootName(environment.getConfigId(), "null", "J2EEApplication");
                moduleName = naming.createChildName(earName, environment.getConfigId().toString(), "EJBModule");
            } else {
                AbstractName parentName = parentModule instanceof AppClientModule ? ((AppClientModule)parentModule).getAppClientName() : parentModule.getModuleName();
                moduleName = naming.createChildName(parentName, targetPath, "EJBModule");
            }
            EjbJar ejbJar = ejbModule2.getEjbJar();
            File file = new File(moduleFile.getName());
            String packageName = file.getName();
            String name = subModule ? parentModule.getName() : (ejbJar.getModuleName() != null ? ejbJar.getModuleName().trim() : (standAlone ? FileUtils.removeExtension((String)packageName, (String)".jar") : FileUtils.removeExtension((String)targetPath, (String)".jar")));
            ejbModule2.setModuleId(name);
            if (standAlone) {
                ejbModule2.setModuleUri(URI.create(packageName));
            } else {
                ejbModule2.setModuleUri(URI.create(targetPath));
            }
            Map context = null;
            if (subModule) {
                context = parentModule.getJndiContext();
            } else if (parentModule != null) {
                context = Module.share((EnumSet)Module.APP, (Map)parentModule.getJndiContext());
            }
            EjbModule module = new EjbModule(ejbModule2, standAlone, moduleName, name, environment, moduleFile, targetPath, "", ejbJar, geronimoOpenejb, context, parentModule, subModule);
            for (ModuleBuilderExtension builder : this.moduleBuilderExtensions) {
                try {
                    builder.createModule((Module)module, plan, moduleFile, targetPath, specDDUrl, environment, null, parentModule == null ? null : parentModule.getModuleName(), naming, idBuilder);
                }
                catch (Throwable t) {
                    String builderName = builder.getClass().getSimpleName();
                    log.error(builderName + ".createModule() failed: " + t.getMessage(), t);
                }
            }
            ejbModule = module;
            this.releaseTempClassLoader(detectTempClassLoader);
            this.releaseTempClassLoader(ejbModuleTempClassLoader);
            i$ = tempFileList.iterator();
        }
        catch (DeploymentException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new DeploymentException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseTempClassLoader(detectTempClassLoader);
                this.releaseTempClassLoader(ejbModuleTempClassLoader);
                Iterator i$3 = tempFileList.iterator();
                while (true) {
                    if (!i$3.hasNext()) {
                        throw throwable;
                    }
                    File file = (File)i$3.next();
                    FileUtils.recursiveDelete((File)file);
                }
            }
        }
        while (true) {
            if (!i$.hasNext()) {
                return ejbModule;
            }
            File file = (File)i$.next();
            FileUtils.recursiveDelete((File)file);
        }
    }

    protected static void unmapReferences(EjbJar ejbJar, GeronimoEjbJarType geronimoEjbJarType) {
        TreeSet<String> corbaEjbRefs = new TreeSet<String>();
        for (EjbRefType ejbRef : geronimoEjbJarType.getEjbRef()) {
            if (ejbRef.getNsCorbaloc() == null) continue;
            corbaEjbRefs.add(ejbRef.getRefName());
        }
        for (EnterpriseBean enterpriseBean : ejbJar.getEnterpriseBeans()) {
            EjbRef ref2;
            enterpriseBean.getEnvEntry().clear();
            enterpriseBean.getEjbLocalRef().clear();
            Iterator iterator = enterpriseBean.getEjbRef().iterator();
            while (iterator.hasNext()) {
                ref2 = (EjbRef)iterator.next();
                if (!corbaEjbRefs.contains(ref2.getEjbRefName())) {
                    iterator.remove();
                    continue;
                }
                ref2.setMappedName(null);
                ref2.getInjectionTarget().clear();
            }
            for (EjbRef ref2 : enterpriseBean.getMessageDestinationRef()) {
                ref2.setMappedName(null);
                ref2.getInjectionTarget().clear();
            }
            for (EjbRef ref2 : enterpriseBean.getPersistenceContextRef()) {
                ref2.setMappedName(null);
                ref2.getInjectionTarget().clear();
            }
            for (EjbRef ref2 : enterpriseBean.getPersistenceUnitRef()) {
                ref2.setMappedName(null);
                ref2.getInjectionTarget().clear();
            }
            for (EjbRef ref2 : enterpriseBean.getResourceRef()) {
                ref2.setMappedName(null);
                ref2.getInjectionTarget().clear();
            }
            iterator = enterpriseBean.getResourceEnvRef().iterator();
            while (iterator.hasNext()) {
                ref2 = (ResourceEnvRef)iterator.next();
                if (ref2.getType().equals(EntityContext.class.getName())) {
                    iterator.remove();
                } else if (ref2.getType().equals(TimerService.class.getName())) {
                    iterator.remove();
                } else if (ref2.getType().equals(WebServiceContext.class.getName())) {
                    iterator.remove();
                } else {
                    ref2.setMappedName(null);
                }
                ref2.getInjectionTarget().clear();
            }
            for (EjbRef ref2 : enterpriseBean.getServiceRef()) {
                ref2.setMappedName(null);
                ref2.getInjectionTarget().clear();
            }
        }
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repository) throws DeploymentException {
        if (module instanceof EjbModule) {
            EARContext moduleContext;
            this.installModule(module, earContext);
            if (module.isStandAlone()) {
                moduleContext = earContext;
                earContext.addToClassPath(DEFAULT_BUNDLE_CLASSPATH);
            } else {
                moduleContext = new FragmentContext(earContext, ConfigurationModuleType.EJB);
            }
            module.setEarContext(moduleContext);
            module.setRootEarContext(earContext);
            if (((EjbModule)module).getEjbJar().getAssemblyDescriptor() != null) {
                this.namingBuilder.buildEnvironment(null, null, module.getEnvironment());
            }
            for (ModuleBuilderExtension builder : this.moduleBuilderExtensions) {
                try {
                    builder.installModule(earFile, earContext, module, configurationStores, targetConfigurationStore, repository);
                }
                catch (Throwable t) {
                    String builderName = builder.getClass().getSimpleName();
                    log.error(builderName + ".installModule() failed: " + t.getMessage(), t);
                }
            }
        } else {
            LinkedHashSet modules = module.getModules();
            for (Module subModule : modules) {
                if (!(subModule instanceof EjbModule)) continue;
                subModule.setEarContext(module.getEarContext());
                subModule.setRootEarContext(module.getRootEarContext());
                if (module instanceof AppClientModule) {
                    earContext = module.getEarContext();
                }
                this.registerModule(subModule, earContext);
            }
        }
    }

    private void installModule(Module module, EARContext earContext) throws DeploymentException {
        this.registerModule(module, earContext);
        JarFile moduleFile = module.getModuleFile();
        try {
            if (module.isStandAlone()) {
                JarUtils.unzipToDirectory((ZipFile)new JarFile(moduleFile.getName()), (File)earContext.getBaseDir());
            } else {
                earContext.addIncludeAsPackedJar(URI.create(module.getTargetPath()), moduleFile);
                LinkedHashSet EjbModuleClasspaths = module.getClassPath();
                EjbModuleClasspaths.add(module.getTargetPath());
                LinkedHashSet moduleLocations = module.isStandAlone() ? null : module.getParentModule().getModuleLocations();
                URI baseUri = URI.create(module.getTargetPath());
                earContext.getCompleteManifestClassPath(module.getDeployable(), baseUri, URI.create(DEFAULT_BUNDLE_CLASSPATH), (Collection)EjbModuleClasspaths, (Collection)moduleLocations);
                for (String classpath : EjbModuleClasspaths) {
                    earContext.addToClassPath(classpath);
                }
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to copy ejb module jar into configuration: " + moduleFile.getName(), (Throwable)e);
        }
    }

    private void registerModule(Module module, EARContext earContext) {
        EarData earData = (EarData)EarData.KEY.get(earContext.getGeneralData());
        if (earData == null) {
            earData = new EarData();
            earContext.getGeneralData().put(EarData.KEY, earData);
        }
        earData.addEjbModule((EjbModule)module);
    }

    private boolean cleanupConfigurationDir(File configurationDir) {
        LinkedList cannotBeDeletedList = new LinkedList();
        if (!FileUtils.recursiveDelete((File)configurationDir, cannotBeDeletedList)) {
            log.warn("Unable to delete " + cannotBeDeletedList.size() + " files while recursively deleting directory " + configurationDir.getAbsolutePath() + LINE_SEP + "The first file that could not be deleted was:" + LINE_SEP + "  " + (!cannotBeDeletedList.isEmpty() ? (String)cannotBeDeletedList.getFirst() : ""));
            return false;
        }
        return true;
    }

    public void initContext(EARContext earContext, Module module, Bundle bundle) throws DeploymentException {
        if (module instanceof EjbModule) {
            this.doInitContext(earContext, module, bundle);
        } else {
            LinkedHashSet modules = module.getModules();
            for (Module subModule : modules) {
                if (!(subModule instanceof EjbModule)) continue;
                if (module instanceof AppClientModule) {
                    earContext = module.getEarContext();
                }
                this.doInitContext(earContext, subModule, bundle);
            }
        }
    }

    private void doInitContext(EARContext earContext, Module module, Bundle bundle) throws DeploymentException {
        EjbModule ejbModule = (EjbModule)module;
        AppInfo appInfo = this.getAppInfo(earContext, ejbModule, bundle);
        ejbModule.setEjbJarInfo(AppInfoGBean.getEjbJarInfo((AppInfo)appInfo, (URI)ejbModule.getModuleURI()));
        EjbJar ejbJar = ejbModule.getEjbJar();
        ejbModule.setOriginalSpecDD(XmlUtil.marshal(ejbJar));
        GeronimoEjbJarType geronimoEjbJarType = (GeronimoEjbJarType)ejbModule.getEjbModule().getAltDDs().get("geronimo-openejb.xml");
        OpenejbGeronimoEjbJarType geronimoOpenejb = XmlUtil.convertToXmlbeans(geronimoEjbJarType);
        ((OpenejbGeronimoEjbJarType)ejbModule.getVendorDD()).set(geronimoOpenejb);
        if (ejbJar.getAssemblyDescriptor() != null) {
            List specMessageDestinations = ejbJar.getAssemblyDescriptor().getMessageDestination();
            MessageDestinationInfo jndiConsumer = new MessageDestinationInfo(specMessageDestinations);
            this.namingBuilder.initContext((JndiConsumer)jndiConsumer, (XmlObject)module.getVendorDD(), (Module)ejbModule);
        }
        EjbDeploymentBuilder ejbDeploymentBuilder = new EjbDeploymentBuilder(earContext, ejbModule, this.namingBuilder, this.resourceEnvironmentSetter);
        ejbModule.setEjbBuilder(ejbDeploymentBuilder);
        ejbDeploymentBuilder.initContext();
        this.serviceBuilders.build((XmlObject)ejbModule.getVendorDD(), (DeploymentContext)earContext, (DeploymentContext)ejbModule.getEarContext());
        GBeanData ejbModuleGBeanData = new GBeanData(ejbModule.getModuleName(), EjbModuleImpl.class);
        try {
            ejbModule.addGBean(ejbModuleGBeanData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add ejb module gbean", (Throwable)e);
        }
        for (ModuleBuilderExtension builder : this.moduleBuilderExtensions) {
            try {
                builder.initContext(earContext, module, bundle);
            }
            catch (Throwable t) {
                String builderName = builder.getClass().getSimpleName();
                log.error(builderName + ".initContext() failed: " + t.getMessage(), t);
            }
        }
    }

    private AppInfo getAppInfo(EARContext earContext, EjbModule ejbModule, Bundle bundle) throws DeploymentException {
        EarData earData = (EarData)EarData.KEY.get(earContext.getGeneralData());
        if (earData.getAppInfo() == null) {
            AppInfo appInfo;
            BundleClassLoader bundleLoader = new BundleClassLoader(bundle);
            AppModule appModule = new AppModule((ClassLoader)bundleLoader, earContext.getConfigID().toString(), null, ejbModule.isStandAlone());
            for (EjbModule module : earData.getEjbModules()) {
                module.setClassLoader((ClassLoader)bundleLoader);
                appModule.getEjbModules().add(module.getEjbModule());
            }
            if (!ejbModule.isStandAlone()) {
                appModule.setModuleId(ejbModule.getParentModule().getName());
            }
            try {
                appInfo = this.configureApplication(appModule, ejbModule, earContext.getConfiguration());
            }
            catch (ValidationFailedException set) {
                StringBuilder sb = new StringBuilder();
                sb.append("Jar failed validation: ").append(appModule.getModuleId());
                for (ValidationError validationError : set.getErrors()) {
                    sb.append(validationError.getPrefix()).append(" ... ").append(validationError.getComponentName()).append(":\t").append(validationError.getMessage(2));
                }
                for (ValidationError validationError : set.getFailures()) {
                    sb.append(validationError.getPrefix()).append(" ... ").append(validationError.getComponentName()).append(":\t").append(validationError.getMessage(2));
                }
                throw new DeploymentException(sb.toString());
            }
            catch (OpenEJBException e) {
                throw new DeploymentException((Throwable)e);
            }
            earData.setAppInfo(appInfo);
            CmpJarBuilder cmp2Builder = new CmpJarBuilder(appInfo, (ClassLoader)bundleLoader);
            try {
                File generatedJar = cmp2Builder.getJarFile();
                if (generatedJar != null) {
                    String generatedPath = ejbModule.getTargetPath();
                    if (generatedPath.endsWith(".jar")) {
                        generatedPath = generatedPath.substring(0, generatedPath.length() - 4);
                    }
                    generatedPath = generatedPath + "-cmp2.jar";
                    earContext.addInclude(URI.create(generatedPath), generatedJar);
                }
            }
            catch (IOException e) {
                throw new DeploymentException((Throwable)e);
            }
            if (appInfo.cmpMappingsXml != null) {
                this.addGeronimmoOpenEJBPersistenceUnit(ejbModule);
            }
            EjbModule m = ejbModule;
            while (m.getParentModule() != null) {
                m = m.getParentModule();
            }
            AbstractName appInfoName = earContext.getNaming().createChildName(m.getModuleName(), "appInfoGBean", "appInfoGBean");
            earContext.getGeneralData().put(EARContext.APPINFO_GBEAN_NAME_KEY, appInfoName);
            GBeanData appInfoData = new GBeanData(appInfoName, AppInfoGBean.class);
            appInfoData.setAttribute("appInfo", (Object)appInfo);
            appInfoData.setReferencePattern("OpenEjbSystem", new AbstractNameQuery(null, Collections.EMPTY_MAP, OpenEjbSystem.class.getName()));
            try {
                earContext.addGBean(appInfoData);
            }
            catch (GBeanAlreadyExistsException e) {
                throw new DeploymentException("Duplicate app info gbean", (Throwable)e);
            }
        }
        return earData.getAppInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppInfo configureApplication(AppModule appModule, EjbModule ejbModule, Configuration configuration) throws OpenEJBException {
        OpenEjbConfiguration openEjbConfiguration = new OpenEjbConfiguration();
        openEjbConfiguration.containerSystem = new ContainerSystemInfo();
        openEjbConfiguration.facilities = new FacilitiesInfo();
        boolean offline = true;
        ConfigurationFactory.Chain chain = new ConfigurationFactory.Chain();
        ConfigurationFactory configurationFactory = new ConfigurationFactory(offline, chain, openEjbConfiguration);
        EjbModuleBuilder.buildChain(offline, (DynamicDeployer)ejbModule.getPreAutoConfigDeployer(), SystemInstance.get().getOptions(), configurationFactory, chain);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(appModule.getClassLoader());
        try {
            this.addContainerInfos(configuration, openEjbConfiguration.containerSystem, configurationFactory);
            this.addResourceAdapterMDBInfos(configuration, openEjbConfiguration.containerSystem, configurationFactory);
            AppInfo appInfo = configurationFactory.configureApplication(appModule);
            return appInfo;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private static ConfigurationFactory.Chain buildChain(boolean offline, DynamicDeployer preAutoConfigDeployer, Options options, ConfigurationFactory configurationFactory, ConfigurationFactory.Chain chain) {
        chain.add((DynamicDeployer)new GeneratedClientModules.Add());
        chain.add((DynamicDeployer)new ReadDescriptors());
        chain.add((DynamicDeployer)new LegacyProcessor());
        chain.add((DynamicDeployer)new GeronimoAnnotationDeployer());
        chain.add((DynamicDeployer)new GeneratedClientModules.Prune());
        chain.add((DynamicDeployer)new ClearEmptyMappedName());
        if (!options.get(VALIDATION_SKIP_PROPERTY, false)) {
            chain.add((DynamicDeployer)new ValidateModules());
        } else {
            log.info("validationDisabled", (Object)VALIDATION_SKIP_PROPERTY);
        }
        chain.add((DynamicDeployer)new InitEjbDeployments());
        if (options.get(WEBSERVICES_ENABLED, true)) {
            chain.add((DynamicDeployer)new WsDeployer());
        }
        chain.add((DynamicDeployer)new CmpJpaConversion());
        Set support = SystemInstance.get().getOptions().getAll("openejb.vendor.config", (Enum[])Vendor.values());
        if (support.contains(Vendor.GERONIMO) || SystemInstance.get().hasProperty("openejb.geronimo")) {
            chain.add((DynamicDeployer)new OpenEjb2Conversion());
        }
        if (support.contains(Vendor.GLASSFISH)) {
            chain.add((DynamicDeployer)new SunConversion());
        }
        if (support.contains(Vendor.WEBLOGIC)) {
            chain.add((DynamicDeployer)new WlsConversion());
        }
        if (SystemInstance.get().hasProperty("openejb.geronimo")) {
            chain.add((DynamicDeployer)new GeronimoMappedName());
        }
        if (null != preAutoConfigDeployer) {
            chain.add(preAutoConfigDeployer);
        }
        if (offline) {
            AutoConfig autoConfig = new AutoConfig(configurationFactory);
            autoConfig.autoCreateResources(false);
            autoConfig.autoCreateContainers(true);
            chain.add((DynamicDeployer)autoConfig);
        } else {
            chain.add((DynamicDeployer)new AutoConfig(configurationFactory));
        }
        chain.add((DynamicDeployer)new ApplyOpenejbJar());
        chain.add((DynamicDeployer)new MappedNameBuilder());
        chain.add((DynamicDeployer)new OutputGeneratedDescriptors());
        return chain;
    }

    private void addContainerInfos(Configuration configuration, ContainerSystemInfo containerSystem, ConfigurationFactory configurationFactory) throws OpenEJBException {
        LinkedHashSet containerDatas = configuration.findGBeanDatas(Collections.singleton(new AbstractNameQuery(EjbContainer.class.getName())));
        for (GBeanData containerData : containerDatas) {
            String id = EjbContainer.getId((AbstractName)containerData.getAbstractName());
            Class infoClass = EjbContainer.getInfoType((String)containerData.getGBeanInfo().getClassName());
            Properties declaredProperties = new Properties();
            String providerId = null;
            ContainerInfo containerInfo = (ContainerInfo)configurationFactory.configureService(infoClass, id, declaredProperties, providerId, "Container");
            containerSystem.containers.add(containerInfo);
        }
    }

    private void addResourceAdapterMDBInfos(Configuration configuration, ContainerSystemInfo containerSystem, ConfigurationFactory configurationFactory) throws OpenEJBException {
        LinkedHashSet resourceAdapterWrappers = configuration.findGBeanDatas(Collections.singleton(new AbstractNameQuery(ResourceAdapterWrapperGBean.class.getName())));
        for (GBeanData resourceAdapterWrapperData : resourceAdapterWrappers) {
            String resourceAdapterId = this.getResourceAdapterId(resourceAdapterWrapperData.getAbstractName());
            Map messageListenerToActivationSpecMap = (Map)resourceAdapterWrapperData.getAttribute("messageListenerToActivationSpecMap");
            if (messageListenerToActivationSpecMap == null) continue;
            for (Map.Entry entry : messageListenerToActivationSpecMap.entrySet()) {
                String messageListenerInterface = (String)entry.getKey();
                String activationSpecClass = (String)entry.getValue();
                String containerName = resourceAdapterId + "-" + messageListenerInterface;
                ContainerInfo containerInfo = (ContainerInfo)configurationFactory.configureService(MdbContainerInfo.class);
                containerInfo.id = containerName;
                containerInfo.displayName = containerName;
                try {
                    containerInfo.properties.put("MessageListenerInterface", configuration.getBundle().loadClass(messageListenerInterface));
                }
                catch (ClassNotFoundException e) {
                    throw new OpenEJBException("Could not load MessageListenerInterface " + messageListenerInterface + " in bundle: " + configuration.getBundle(), (Throwable)e);
                }
                try {
                    containerInfo.properties.put("ActivationSpecClass", configuration.getBundle().loadClass(activationSpecClass));
                }
                catch (ClassNotFoundException e) {
                    throw new OpenEJBException("Could not load ActivationSpecClass " + activationSpecClass + " in bundle: " + configuration.getBundle(), (Throwable)e);
                }
                containerInfo.properties.put("TxRecovery", (Object)true);
                containerSystem.containers.add(containerInfo);
            }
        }
    }

    private void addGeronimmoOpenEJBPersistenceUnit(EjbModule ejbModule) {
        GeronimoEjbJarType geronimoEjbJarType = (GeronimoEjbJarType)ejbModule.getEjbModule().getAltDDs().get("geronimo-openejb.xml");
        PersistenceUnit persistenceUnit = null;
        block0: for (Persistence persistence : geronimoEjbJarType.getPersistence()) {
            for (PersistenceUnit unit : persistence.getPersistenceUnit()) {
                if (!"cmp".equals(unit.getName())) continue;
                persistenceUnit = unit;
                continue block0;
            }
        }
        if (persistenceUnit == null) {
            String datasourceName;
            ResourceLocatorType cmpConnectionFactory;
            String jtaDataSource = null;
            Object altDD = ejbModule.getEjbModule().getAltDDs().get("openejb-jar.xml");
            if (altDD instanceof OpenejbJarType && (cmpConnectionFactory = ((OpenejbJarType)altDD).getCmpConnectionFactory()) != null && (datasourceName = cmpConnectionFactory.getResourceLink()) != null) {
                jtaDataSource = datasourceName.trim();
            }
            persistenceUnit = new PersistenceUnit();
            persistenceUnit.setName("cmp");
            persistenceUnit.setTransactionType(TransactionType.JTA);
            if (jtaDataSource != null) {
                persistenceUnit.setJtaDataSource(jtaDataSource);
            } else {
                persistenceUnit.setJtaDataSource(this.defaultCmpJTADataSource);
            }
            persistenceUnit.setNonJtaDataSource(this.defaultCmpNonJTADataSource);
            persistenceUnit.setExcludeUnlistedClasses(Boolean.valueOf(true));
            Persistence persistence = new Persistence();
            persistence.setVersion("2.0");
            persistence.getPersistenceUnit().add(persistenceUnit);
            geronimoEjbJarType.getPersistence().add(persistence);
        }
        persistenceUnit.getMappingFile().add("META-INF/openejb-cmp-generated-orm.xml");
    }

    public void addGBeans(EARContext earContext, Module module, Bundle bundle, Collection repositories) throws DeploymentException {
        if (module instanceof EjbModule) {
            this.doAddGBeans(earContext, module, bundle, repositories);
        } else {
            LinkedHashSet modules = module.getModules();
            for (Module subModule : modules) {
                if (!(subModule instanceof EjbModule)) continue;
                this.doAddGBeans(earContext, subModule, bundle, repositories);
            }
        }
    }

    public void doAddGBeans(EARContext earContext, Module module, Bundle bundle, Collection repositories) throws DeploymentException {
        GBeanData ejbModuleGBeanData;
        EjbModule ejbModule = (EjbModule)module;
        EjbDeploymentBuilder ejbDeploymentBuilder = ejbModule.getEjbBuilder();
        try {
            ejbModule.flushGBeansToContext();
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Name conflict between ejb modules", (Throwable)e);
        }
        String moduleName = module.getName();
        if (earContext.getSubModuleNames().size() > 1 && earContext.getSubModuleNames().contains(moduleName)) {
            log.warn("Duplicated moduleName: '" + moduleName + "' is found ! deployer will rename it to: '" + moduleName + "_duplicated' , please check your modules in application to make sure they don't share the same name");
            moduleName = moduleName + "_duplicated";
            earContext.getSubModuleNames().add(moduleName);
        }
        if (!(module.getParentModule() instanceof WebModule) && !(module.getParentModule() instanceof AppClientModule)) {
            earContext.getSubModuleNames().add(moduleName);
            module.getJndiScope((JndiKey)JndiScope.module).put("module/ModuleName", moduleName);
        }
        ejbDeploymentBuilder.buildEnc();
        LinkedHashSet gBeanDatas = earContext.getConfiguration().findGBeanDatas(Collections.singleton(new AbstractNameQuery(PersistenceUnitGBean.class.getName())));
        UniqueDefaultLinkResolver linkResolver = new UniqueDefaultLinkResolver();
        for (GBeanData gBeanData : gBeanDatas) {
            String name = (String)gBeanData.getAttribute("persistenceUnitName");
            String rootUrl = (String)gBeanData.getAttribute("persistenceUnitRoot");
            if (name.equals("cmp")) continue;
            String id = name + " " + rootUrl.hashCode();
            linkResolver.add(rootUrl, name, (Object)id);
        }
        EjbJarInfo ejbJarInfo = ejbModule.getEjbJarInfo();
        for (EnterpriseBeanInfo beanInfo : ejbJarInfo.enterpriseBeans) {
            if (!(beanInfo instanceof StatefulBeanInfo)) continue;
            StatefulBeanInfo statefulBeanInfo = (StatefulBeanInfo)beanInfo;
            for (PersistenceContextReferenceInfo refInfo : statefulBeanInfo.jndiEnc.persistenceContextRefs) {
                if (!refInfo.extended) continue;
                refInfo.unitId = (String)linkResolver.resolveLink(refInfo.persistenceUnitName, ejbJarInfo.moduleUri);
            }
        }
        try {
            ejbModuleGBeanData = (GBeanData)module.getEarContext().findGBeanDatas(module.getEarContext().getConfiguration(), new AbstractNameQuery(ejbModule.getModuleName())).iterator().next();
            ejbModuleGBeanData.setReferencePattern("J2EEServer", module.getRootEarContext().getServerName());
            ejbModuleGBeanData.setAttribute("deploymentDescriptor", (Object)ejbModule.getOriginalSpecDD());
            ejbModuleGBeanData.setAttribute("isStandalone", (Object)ejbModule.isStandAlone());
            ejbModuleGBeanData.setReferencePatterns("EJBCollection", new ReferencePatterns(new AbstractNameQuery(null, Collections.singletonMap("EJBModule", ejbModule.getModuleName().getNameProperty("name")), EjbDeployment.class.getName())));
            ejbModuleGBeanData.setReferencePattern("OpenEjbSystem", new AbstractNameQuery(null, Collections.EMPTY_MAP, OpenEjbSystem.class.getName()));
            ejbModuleGBeanData.setReferencePattern("AppInfo", (AbstractName)EARContext.APPINFO_GBEAN_NAME_KEY.get(earContext.getGeneralData()));
            ejbModuleGBeanData.setAttribute("moduleURI", (Object)ejbModule.getEjbModule().getModuleUri());
            ejbModuleGBeanData.setAttribute("moduleContext", (Object)module.getJndiScope((JndiKey)JndiScope.module));
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialize EJBModule GBean " + ejbModule.getModuleName(), (Throwable)e);
        }
        ejbDeploymentBuilder.addEjbModuleDependency(ejbModuleGBeanData);
        String policyContextId = ejbModule.getEjbJarInfo().moduleUri.toString();
        ComponentPermissions componentPermissions = (ComponentPermissions)earContext.getContextIDToPermissionsMap().get(policyContextId);
        if (componentPermissions == null) {
            componentPermissions = new ComponentPermissions((PermissionCollection)new Permissions(), (PermissionCollection)new Permissions(), new HashMap());
            earContext.addSecurityContext(policyContextId, (Object)componentPermissions);
        }
        ejbDeploymentBuilder.buildComponentPermissions(componentPermissions);
        this.setMdbContainerIds(earContext, ejbModule, ejbModuleGBeanData);
        for (ModuleBuilderExtension builder : this.moduleBuilderExtensions) {
            try {
                builder.addGBeans(earContext, module, bundle, repositories);
            }
            catch (Throwable t) {
                String builderName = builder.getClass().getSimpleName();
                log.error(builderName + ".addGBeans() failed: " + t.getMessage(), t);
            }
        }
    }

    private void setMdbContainerIds(EARContext earContext, EjbModule ejbModule, GBeanData ejbModuleGBeanData) throws DeploymentException {
        Object altDD = ejbModule.getEjbModule().getAltDDs().get("openejb-jar.xml");
        if (!(altDD instanceof OpenejbJarType)) {
            return;
        }
        OpenejbJarType openejbJarType = (OpenejbJarType)altDD;
        EjbJarInfo ejbJarInfo = ejbModule.getEjbJarInfo();
        TreeMap<String, MessageDrivenBeanInfo> mdbs = new TreeMap<String, MessageDrivenBeanInfo>();
        for (EnterpriseBeanInfo enterpriseBean : ejbJarInfo.enterpriseBeans) {
            if (!(enterpriseBean instanceof MessageDrivenBeanInfo)) continue;
            mdbs.put(enterpriseBean.ejbName, (MessageDrivenBeanInfo)enterpriseBean);
        }
        for (EnterpriseBeanInfo enterpriseBean : openejbJarType.getEnterpriseBeans()) {
            AbstractName resourceAdapterAbstractName;
            MessageDrivenBeanType bean;
            MessageDrivenBeanInfo messageDrivenBeanInfo;
            if (!(enterpriseBean instanceof MessageDrivenBeanType) || (messageDrivenBeanInfo = (MessageDrivenBeanInfo)mdbs.get((bean = (MessageDrivenBeanType)enterpriseBean).getEjbName())) == null || messageDrivenBeanInfo.containerId != null) continue;
            if (bean.getResourceAdapter() == null) {
                throw new DeploymentException("No Resource Adapter defined for MDB '" + bean.getEjbName() + "'");
            }
            AbstractNameQuery resourceAdapterNameQuery = EjbModuleBuilder.getResourceAdapterNameQuery(bean.getResourceAdapter());
            try {
                resourceAdapterAbstractName = earContext.findGBean(resourceAdapterNameQuery);
            }
            catch (GBeanNotFoundException e) {
                throw new DeploymentException("Resource Adapter for MDB '" + bean.getEjbName() + "'not found: " + resourceAdapterNameQuery, (Throwable)e);
            }
            String resourceAdapterId = this.getResourceAdapterId(resourceAdapterAbstractName);
            messageDrivenBeanInfo.containerId = resourceAdapterId + "-" + messageDrivenBeanInfo.mdbInterface;
            ejbModuleGBeanData.addDependency(resourceAdapterAbstractName);
        }
        for (MessageDrivenBeanInfo mdbInfo : mdbs.values()) {
            if (mdbInfo == null || mdbInfo.containerId != null) continue;
            throw new DeploymentException("No Resource Adapter defined for MDB '" + mdbInfo.ejbName + "'");
        }
    }

    private String getResourceAdapterId(AbstractName resourceAdapterAbstractName) {
        Map properties = resourceAdapterAbstractName.getName();
        String shortName = (String)properties.get("name");
        String moduleName = (String)properties.get("ResourceAdapterModule");
        if (shortName != null && moduleName != null) {
            return moduleName + DEFAULT_BUNDLE_CLASSPATH + shortName;
        }
        return resourceAdapterAbstractName.getObjectName().toString();
    }

    private static AbstractNameQuery getResourceAdapterNameQuery(ResourceLocatorType resourceLocator) {
        if (resourceLocator.getResourceLink() != null) {
            HashMap<String, String> nameMap = new HashMap<String, String>();
            nameMap.put("name", resourceLocator.getResourceLink());
            nameMap.put("j2eeType", "JCAResourceAdapter");
            return new AbstractNameQuery(null, nameMap);
        }
        PatternType pattern = resourceLocator.getPattern();
        Artifact artifact = null;
        if (pattern.getArtifactId() != null) {
            artifact = new Artifact(pattern.getGroupId(), pattern.getArtifactId(), pattern.getVersion(), "car");
        }
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("name", pattern.getName());
        nameMap.put("j2eeType", "JCAResourceAdapter");
        if (pattern.getModule() != null) {
            nameMap.put("ResourceAdapterModule", pattern.getModule());
        }
        return new AbstractNameQuery(artifact, nameMap, (Set)null);
    }

    private boolean isEjbModule(URL baseUrl, List<URL> urls, ClassLoader classLoader, Map<String, URL> descriptors) {
        try {
            InputStream is;
            Manifest manifest;
            String mainClass;
            String path = baseUrl.getPath();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (descriptors.containsKey("application.xml") || path.endsWith(".ear")) {
                return false;
            }
            if (descriptors.containsKey("application-client.xml")) {
                return false;
            }
            if (descriptors.containsKey("ra.xml") || path.endsWith(".rar")) {
                return false;
            }
            if (descriptors.containsKey("APPLICATION.MF") || path.endsWith(".eba")) {
                return false;
            }
            if (descriptors.containsKey("ejb-jar.xml") || descriptors.containsKey("beans.xml")) {
                return true;
            }
            URL manifestUrl = descriptors.get("MANIFEST.MF");
            if (manifestUrl != null && (mainClass = (manifest = new Manifest(is = manifestUrl.openStream())).getMainAttributes().getValue(Attributes.Name.MAIN_CLASS)) != null) {
                return false;
            }
            AnnotationFinder classFinder = new AnnotationFinder(classLoader, urls);
            AnnotationFinder.Filter filter = new AnnotationFinder.Filter(){

                public boolean accept(String annotationName) {
                    if (annotationName.startsWith("javax.ejb.")) {
                        if ("javax.ejb.Stateful".equals(annotationName)) {
                            return true;
                        }
                        if ("javax.ejb.Stateless".equals(annotationName)) {
                            return true;
                        }
                        if ("javax.ejb.Singleton".equals(annotationName)) {
                            return true;
                        }
                        if ("javax.ejb.MessageDriven".equals(annotationName)) {
                            return true;
                        }
                    } else if ("javax.annotation.ManagedBean".equals(annotationName)) {
                        return true;
                    }
                    return false;
                }
            };
            return classFinder.find(filter);
        }
        catch (Exception e) {
            log.warn("Unable to determine module type for jar: " + baseUrl.toExternalForm(), (Throwable)e);
            return false;
        }
    }

    private void releaseTempClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            try {
                ClassLoaderUtil.destroyClassLoader((ClassLoader)classLoader.getParent());
                ClassLoaderUtil.destroyClassLoader((ClassLoader)classLoader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        OPENEJBJAR_NAMESPACE = XmlUtil.OPENEJBJAR_QNAME.getNamespaceURI();
        NAMESPACE_UPDATES = new HashMap<String, String>();
        NAMESPACE_UPDATES.put("http://www.openejb.org/xml/ns/openejb-jar", "http://openejb.apache.org/xml/ns/openejb-jar-2.3");
        NAMESPACE_UPDATES.put("http://www.openejb.org/xml/ns/openejb-jar-2.1", "http://openejb.apache.org/xml/ns/openejb-jar-2.3");
        NAMESPACE_UPDATES.put("http://www.openejb.org/xml/ns/openejb-jar-2.2", "http://openejb.apache.org/xml/ns/openejb-jar-2.3");
        NAMESPACE_UPDATES.put("http://www.openejb.org/xml/ns/openejb-jar-2.3", "http://openejb.apache.org/xml/ns/openejb-jar-2.3");
        NAMESPACE_UPDATES.put("http://www.openejb.org/xml/ns/pkgen", "http://openejb.apache.org/xml/ns/pkgen-2.1");
        NAMESPACE_UPDATES.put("http://www.openejb.org/xml/ns/pkgen-2.0", "http://openejb.apache.org/xml/ns/pkgen-2.1");
        String ejbServerSupported = System.getProperty("org.apache.geronimo.ejb.server.support");
        if (ejbServerSupported == null) {
            ejbServerSupported = System.getProperty("org.apache.geronimo.ejb.support");
        }
        EJB_SERVER_SUPPORT = ejbServerSupported == null ? true : Boolean.valueOf(ejbServerSupported);
        LINE_SEP = System.getProperty("line.separator");
    }

    public static class MessageDestinationInfo
    implements JndiConsumer {
        private final IllegalStateException notAllowedException = new IllegalStateException("this instance is only used for adminObjectRefBuilder to get MessageDestination defined.");
        private final List<MessageDestination> specMessageDestinations;

        public MessageDestinationInfo(List<MessageDestination> specMessageDestinations) {
            this.specMessageDestinations = specMessageDestinations == null ? new ArrayList() : specMessageDestinations;
        }

        public Collection<DataSource> getDataSource() {
            throw this.notAllowedException;
        }

        public Map<String, DataSource> getDataSourceMap() {
            throw this.notAllowedException;
        }

        public Collection<EjbLocalRef> getEjbLocalRef() {
            throw this.notAllowedException;
        }

        public Map<String, EjbLocalRef> getEjbLocalRefMap() {
            throw this.notAllowedException;
        }

        public Collection<EjbRef> getEjbRef() {
            throw this.notAllowedException;
        }

        public Map<String, EjbRef> getEjbRefMap() {
            throw this.notAllowedException;
        }

        public Collection<EnvEntry> getEnvEntry() {
            throw this.notAllowedException;
        }

        public Map<String, EnvEntry> getEnvEntryMap() {
            throw this.notAllowedException;
        }

        public String getJndiConsumerName() {
            throw this.notAllowedException;
        }

        public Collection<MessageDestinationRef> getMessageDestinationRef() {
            throw this.notAllowedException;
        }

        public Map<String, MessageDestinationRef> getMessageDestinationRefMap() {
            throw this.notAllowedException;
        }

        public Collection<PersistenceContextRef> getPersistenceContextRef() {
            throw this.notAllowedException;
        }

        public Map<String, PersistenceContextRef> getPersistenceContextRefMap() {
            throw this.notAllowedException;
        }

        public Collection<PersistenceUnitRef> getPersistenceUnitRef() {
            throw this.notAllowedException;
        }

        public Map<String, PersistenceUnitRef> getPersistenceUnitRefMap() {
            throw this.notAllowedException;
        }

        public Collection<ResourceEnvRef> getResourceEnvRef() {
            throw this.notAllowedException;
        }

        public Map<String, ResourceEnvRef> getResourceEnvRefMap() {
            throw this.notAllowedException;
        }

        public Collection<ResourceRef> getResourceRef() {
            throw this.notAllowedException;
        }

        public Map<String, ResourceRef> getResourceRefMap() {
            throw this.notAllowedException;
        }

        public Collection<ServiceRef> getServiceRef() {
            throw this.notAllowedException;
        }

        public Map<String, ServiceRef> getServiceRefMap() {
            throw this.notAllowedException;
        }

        public List<MessageDestination> getMessageDestination() {
            return this.specMessageDestinations;
        }
    }

    public static class EarData {
        public static final EARContext.Key<EarData> KEY = new EARContext.Key<EarData>(){

            public EarData get(Map<EARContext.Key, Object> context) {
                return (EarData)context.get(this);
            }
        };
        private final Map<String, EjbModule> ejbModules = new TreeMap<String, EjbModule>();
        private AppInfo appInfo;

        public void addEjbModule(EjbModule ejbModule) {
            this.ejbModules.put(ejbModule.getEjbModule().getModuleUri().toString(), ejbModule);
        }

        public EjbModule getEjbModule(String moduleURI) throws DeploymentException {
            EjbModule ejbModule = this.ejbModules.get(moduleURI);
            if (ejbModule == null) {
                throw new DeploymentException("Ejb  module " + moduleURI + " was not found in configured module list " + this.ejbModules.keySet());
            }
            return ejbModule;
        }

        public Collection<EjbModule> getEjbModules() {
            return this.ejbModules.values();
        }

        public void setAppInfo(AppInfo appInfo) {
            this.appInfo = appInfo;
        }

        public AppInfo getAppInfo() throws DeploymentException {
            return this.appInfo;
        }
    }
}

