/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.deployment;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ClassLoadingRule;
import org.apache.geronimo.kernel.repository.ClassLoadingRules;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.openejb.xbeans.ejbjar.OpenejbEjbJarDocument;
import org.apache.geronimo.openejb.xbeans.ejbjar.OpenejbGeronimoEjbJarType;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.oejb2.ArtifactType;
import org.apache.openejb.jee.oejb2.DependencyType;
import org.apache.openejb.jee.oejb2.EnvironmentType;
import org.apache.openejb.jee.oejb2.GeronimoEjbJarType;
import org.apache.openejb.jee.oejb2.ImportType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;

public final class XmlUtil {
    public static final QName OPENEJBJAR_QNAME = OpenejbEjbJarDocument.type.getDocumentElementName();
    private static final QName CMP_VERSION = new QName("http://java.sun.com/xml/ns/j2ee", "cmp-version");

    private XmlUtil() {
    }

    public static <T> String marshal(T object) throws DeploymentException {
        try {
            Class<?> type = object.getClass();
            if (object instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)object;
                type = element.getValue().getClass();
            }
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{type});
            Marshaller marshaller = ctx.createMarshaller();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshal(object, (OutputStream)baos);
            String xml = new String(baos.toByteArray());
            return xml;
        }
        catch (JAXBException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static OpenejbGeronimoEjbJarType convertToXmlbeans(GeronimoEjbJarType geronimoEjbJarType) throws DeploymentException {
        JAXBElement root = new JAXBElement(new QName("http://geronimo.apache.org/xml/ns/j2ee/ejb/openejb-2.0", "ejb-jar"), GeronimoEjbJarType.class, (Object)geronimoEjbJarType);
        String xml = XmlUtil.marshal(root);
        try {
            XmlObject xmlObject = XmlBeansUtil.parse((String)xml);
            OpenejbGeronimoEjbJarType geronimoOpenejb = (OpenejbGeronimoEjbJarType)SchemaConversionUtils.fixGeronimoSchema((XmlObject)xmlObject, (QName)OPENEJBJAR_QNAME, (SchemaType)OpenejbGeronimoEjbJarType.type);
            return geronimoOpenejb;
        }
        catch (Throwable e) {
            String filePath;
            block6: {
                filePath = "<error: could not be written>";
                FileOutputStream out = null;
                try {
                    File tempFile = File.createTempFile("openejb-jar-", ".xml");
                    tempFile.deleteOnExit();
                    out = new FileOutputStream(tempFile);
                    out.write(xml.getBytes());
                    filePath = tempFile.getAbsolutePath();
                }
                catch (Exception notImportant) {
                    IOUtils.close(out);
                    break block6;
                    catch (Throwable throwable) {
                        IOUtils.close(out);
                        throw throwable;
                    }
                }
                IOUtils.close((Closeable)out);
            }
            throw new DeploymentException("Error parsing geronimo-openejb.xml with xmlbeans.  For debug purposes, XML content written to: " + filePath, e);
        }
    }

    public static Environment buildEnvironment(EnvironmentType environmentType, Environment defaultEnvironment) {
        Environment environment = new Environment();
        if (environmentType != null) {
            List filter;
            if (environmentType.getModuleId() != null) {
                environment.setConfigId(XmlUtil.toArtifact(environmentType.getModuleId(), null));
            }
            if (environmentType.getDependencies() != null) {
                for (DependencyType dependencyType : environmentType.getDependencies().getDependency()) {
                    Dependency dependency = XmlUtil.toDependency(dependencyType);
                    environment.addDependency(dependency);
                }
            }
            environment.setBundleActivator(environmentType.getBundleActivator());
            environment.addToBundleClassPath((Collection)environmentType.getBundleClassPath());
            environment.addRequireBundles((Collection)environmentType.getRequireBundle());
            environment.addExportPackages((Collection)environmentType.getExportPackage());
            environment.addImportPackages((Collection)environmentType.getImportPackage());
            environment.addDynamicImportPackages((Collection)environmentType.getDynamicImportPackage());
            environment.setSuppressDefaultEnvironment(environmentType.isSuppressDefaultEnvironment());
            ClassLoadingRules classLoadingRules = environment.getClassLoadingRules();
            classLoadingRules.setInverseClassLoading(environmentType.isInverseClassloading());
            if (environmentType.getHiddenClasses() != null) {
                ClassLoadingRule hiddenRule = classLoadingRules.getHiddenRule();
                filter = environmentType.getHiddenClasses().getFilter();
                hiddenRule.setClassPrefixes(new HashSet(filter));
            }
            if (environmentType.getNonOverridableClasses() != null) {
                ClassLoadingRule nonOverrideableRule = classLoadingRules.getNonOverrideableRule();
                filter = environmentType.getNonOverridableClasses().getFilter();
                nonOverrideableRule.setClassPrefixes(new HashSet(filter));
            }
        }
        if (!environment.isSuppressDefaultEnvironment()) {
            EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)defaultEnvironment);
        }
        return environment;
    }

    private static Dependency toDependency(DependencyType dependencyType) {
        Artifact artifact = XmlUtil.toArtifact((ArtifactType)dependencyType, null);
        if (ImportType.CLASSES.equals((Object)dependencyType.getImport())) {
            return new Dependency(artifact, org.apache.geronimo.kernel.repository.ImportType.CLASSES);
        }
        if (ImportType.SERVICES.equals((Object)dependencyType.getImport())) {
            return new Dependency(artifact, org.apache.geronimo.kernel.repository.ImportType.SERVICES);
        }
        if (dependencyType.getImport() == null) {
            return new Dependency(artifact, org.apache.geronimo.kernel.repository.ImportType.ALL);
        }
        throw new IllegalArgumentException("Unknown import type: " + dependencyType.getImport());
    }

    private static Artifact toArtifact(ArtifactType artifactType, String defaultType) {
        String groupId = artifactType.getGroupId();
        String type = artifactType.getType();
        if (type == null) {
            type = defaultType;
        }
        String artifactId = artifactType.getArtifactId();
        String version = artifactType.getVersion();
        return new Artifact(groupId, artifactId, version, type);
    }

    public static GeronimoEjbJarType createDefaultPlan(String name, EjbJar ejbJar) {
        String id = ejbJar.getId();
        if (id == null) {
            id = name;
            if (id.endsWith(".jar")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
        }
        ArtifactType artifactType = new ArtifactType();
        artifactType.setArtifactId(id);
        EnvironmentType environmentType = new EnvironmentType();
        environmentType.setModuleId(artifactType);
        GeronimoEjbJarType geronimoEjbJarType = new GeronimoEjbJarType();
        geronimoEjbJarType.setEnvironment(environmentType);
        return geronimoEjbJarType;
    }
}

