/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.enc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.naming.reference.ClassLoaderAwareReference;
import org.apache.geronimo.naming.reference.KernelAwareReference;
import org.apache.xbean.naming.context.ImmutableContext;

public final class EnterpriseNamingContext {
    public static Context createEnterpriseNamingContext(Map componentContext, UserTransaction userTransaction, Kernel kernel, ClassLoader classLoader) throws NamingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (componentContext != null) {
            map.putAll(componentContext);
        }
        boolean containsEnv = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (name.startsWith("env/")) {
                containsEnv = true;
            }
            if (value instanceof KernelAwareReference) {
                ((KernelAwareReference)value).setKernel(kernel);
            }
            if (!(value instanceof ClassLoaderAwareReference)) continue;
            ((ClassLoaderAwareReference)value).setClassLoader(classLoader);
        }
        if (!containsEnv) {
            ImmutableContext env = new ImmutableContext("java:comp/env", Collections.EMPTY_MAP, false);
            map.put("env", env);
        }
        if (userTransaction != null) {
            map.put("UserTransaction", userTransaction);
        }
        return EnterpriseNamingContext.createEnterpriseNamingContext(map);
    }

    public static Context createEnterpriseNamingContext(Map context) throws NamingException {
        return new ImmutableContext(context);
    }
}

