/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.annotation.ReferenceType;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.annotation.ResourceAnnotationHelper;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.reference.ClassReference;
import org.apache.geronimo.naming.reference.JndiReference;
import org.apache.geronimo.naming.reference.KernelReference;
import org.apache.geronimo.xbeans.geronimo.naming.GerEnvEntryDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerEnvEntryType;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.Text;
import org.apache.xbean.finder.AbstractFinder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="ModuleBuilder")
public class EnvironmentEntryBuilder
extends AbstractNamingBuilder
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentEntryBuilder.class);
    private static final Map<String, String> NAMESPACE_UPDATES = new HashMap<String, String>();
    private static final QName GER_ENV_ENTRY_QNAME;
    private static final QNameSet GER_ENV_ENTRY_QNAME_SET;
    private final QNameSet envEntryQNameSet;

    public EnvironmentEntryBuilder(@ParamAttribute(name="eeNamespaces") String[] eeNamespaces) {
        this.envEntryQNameSet = EnvironmentEntryBuilder.buildQNameSet(eeNamespaces, "env-entry");
    }

    public void doStart() throws Exception {
        XmlBeansUtil.registerNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doStop() {
        XmlBeansUtil.unregisterNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doFail() {
        this.doStop();
    }

    public void buildNaming(JndiConsumer specDD, XmlObject plan, Module module, Map<EARContext.Key, Object> sharedContext) throws DeploymentException {
        if (module != null && module.getClassFinder() != null) {
            try {
                ResourceAnnotationHelper.processAnnotations((JndiConsumer)specDD, (AbstractFinder)module.getClassFinder(), (ResourceAnnotationHelper.ResourceProcessor)EnvEntryRefProcessor.INSTANCE);
            }
            catch (Exception e) {
                log.warn("Unable to process @Resource annotations for module" + module.getName(), (Throwable)e);
            }
        }
        Bundle bundle = module.getEarContext().getDeploymentBundle();
        XmlObject[] gerEnvEntryUntyped = plan == null ? NO_REFS : plan.selectChildren(GER_ENV_ENTRY_QNAME_SET);
        Map<String, String> envEntryMap = this.mapEnvEntries(gerEnvEntryUntyped);
        for (Map.Entry entry : specDD.getEnvEntryMap().entrySet()) {
            Object value;
            EnvEntry envEntry;
            String name;
            block33: {
                name = (String)entry.getKey();
                envEntry = (EnvEntry)entry.getValue();
                if (this.lookupJndiContextMap(module, name) != null) {
                    this.addInjections(this.normalize(name), ReferenceType.ENV_ENTRY, envEntry.getInjectionTarget(), (Holder)NamingBuilder.INJECTION_KEY.get(sharedContext));
                    continue;
                }
                String type = EnvironmentEntryBuilder.getStringValue(envEntry.getEnvEntryType());
                value = null;
                String strValueOverride = envEntryMap.remove(name);
                String strValue = null;
                if (strValueOverride == null) {
                    strValue = envEntry.getEnvEntryValue();
                    String lookupName = EnvironmentEntryBuilder.getStringValue(envEntry.getLookupName());
                    if (strValue != null && lookupName != null) {
                        throw new DeploymentException("You must specify an environment entry value or lookup name but not both. Component: " + module.toString() + ", name: " + name + ", env-entry-value: " + strValue + ", lookup-name: " + lookupName + "");
                    }
                    if (lookupName != null) {
                        if (lookupName.equals(EnvironmentEntryBuilder.getJndiName(name))) {
                            throw new DeploymentException("env-entry lookup name refers to itself");
                        }
                        value = new JndiReference(lookupName);
                    }
                } else {
                    strValue = strValueOverride;
                }
                type = this.inferAndCheckType(module, bundle, envEntry.getInjectionTarget(), name, type);
                if (value == null) {
                    if (strValue == null) {
                        if ("org.apache.geronimo.kernel.Kernel".equals(type)) {
                            value = new KernelReference();
                        }
                    } else {
                        Class typeClass;
                        try {
                            typeClass = bundle.loadClass(type);
                        }
                        catch (ClassNotFoundException e) {
                            throw new DeploymentException("Could not env-entry type class " + type, (Throwable)e);
                        }
                        try {
                            if (String.class.equals((Object)typeClass)) {
                                value = strValue;
                                break block33;
                            }
                            if (Character.class.equals((Object)typeClass)) {
                                if (strValue.length() == 1) {
                                    value = Character.valueOf(strValue.charAt(0));
                                } else {
                                    log.warn("invalid character value: {} for name {}", (Object)strValue, (Object)name);
                                    value = Character.valueOf(' ');
                                }
                                break block33;
                            }
                            if (Boolean.class.equals((Object)typeClass)) {
                                value = Boolean.valueOf(strValue);
                                break block33;
                            }
                            if (Byte.class.equals((Object)typeClass)) {
                                value = Byte.valueOf(strValue);
                                break block33;
                            }
                            if (Short.class.equals((Object)typeClass)) {
                                value = Short.valueOf(strValue);
                                break block33;
                            }
                            if (Integer.class.equals((Object)typeClass)) {
                                value = Integer.valueOf(strValue);
                                break block33;
                            }
                            if (Long.class.equals((Object)typeClass)) {
                                value = Long.valueOf(strValue);
                                break block33;
                            }
                            if (Float.class.equals((Object)typeClass)) {
                                value = Float.valueOf(strValue);
                                break block33;
                            }
                            if (Double.class.equals((Object)typeClass)) {
                                value = Double.valueOf(strValue);
                                break block33;
                            }
                            if (Class.class.equals((Object)typeClass)) {
                                value = new ClassReference(strValue);
                                break block33;
                            }
                            if (typeClass.isEnum()) {
                                value = Enum.valueOf(typeClass.asSubclass(Enum.class), strValue);
                                break block33;
                            }
                            throw new DeploymentException("Unrecognized env-entry type: " + type);
                        }
                        catch (NumberFormatException e) {
                            throw new DeploymentException("Invalid env-entry value for name: " + name, (Throwable)e);
                        }
                    }
                }
            }
            if (value != null) {
                this.put(name, value, ReferenceType.ENV_ENTRY, module.getJndiContext(), envEntry.getInjectionTarget(), sharedContext);
                continue;
            }
            if (!this.isSharableJndiNamespace(name)) continue;
            this.addInjections(this.normalize(name), ReferenceType.ENV_ENTRY, envEntry.getInjectionTarget(), (Holder)NamingBuilder.INJECTION_KEY.get(sharedContext));
        }
        if (!envEntryMap.isEmpty()) {
            throw new DeploymentException("Unknown env-entry elements in geronimo plan: " + envEntryMap);
        }
    }

    private Map<String, String> mapEnvEntries(XmlObject[] refs) {
        HashMap<String, String> envEntryMap = new HashMap<String, String>();
        if (refs != null) {
            for (XmlObject ref1 : refs) {
                GerEnvEntryType ref = (GerEnvEntryType)ref1.copy().changeType(GerEnvEntryType.type);
                envEntryMap.put(EnvironmentEntryBuilder.getJndiName(ref.getEnvEntryName().trim()), ref.getEnvEntryValue());
            }
        }
        return envEntryMap;
    }

    public QNameSet getSpecQNameSet() {
        return this.envEntryQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return QNameSet.EMPTY;
    }

    static {
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/naming", "http://geronimo.apache.org/xml/ns/naming-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/naming-1.1", "http://geronimo.apache.org/xml/ns/naming-1.2");
        GER_ENV_ENTRY_QNAME = GerEnvEntryDocument.type.getDocumentElementName();
        GER_ENV_ENTRY_QNAME_SET = QNameSet.singleton((QName)GER_ENV_ENTRY_QNAME);
    }

    public static class EnvEntryRefProcessor
    extends ResourceAnnotationHelper.ResourceProcessor {
        public static final EnvEntryRefProcessor INSTANCE = new EnvEntryRefProcessor();
        private static final Set<String> knownEnvironmentEntries = new HashSet<String>(Arrays.asList("boolean", "java.lang.Boolean", "char", "java.lang.Character", "byte", "java.lang.Byte", "short", "java.lang.Short", "int", "java.lang.Integer", "long", "java.lang.Long", "float", "java.lang.Float", "double", "java.lang.Double", "java.lang.String", "java.lang.Class"));

        private EnvEntryRefProcessor() {
        }

        public boolean processResource(JndiConsumer annotatedApp, Resource annotation, Class cls, Method method, Field field) {
            String resourceName = EnvEntryRefProcessor.getResourceName((Resource)annotation, (Method)method, (Field)field);
            Class resourceType = EnvEntryRefProcessor.getResourceTypeClass((Resource)annotation, (Method)method, (Field)field);
            if (knownEnvironmentEntries.contains(resourceType.getName()) || resourceType.isEnum()) {
                Set targets;
                log.debug("addResource(): <env-entry> found");
                EnvEntry envEntry = (EnvEntry)annotatedApp.getEnvEntryMap().get(EnvEntryRefProcessor.getJndiName((String)resourceName));
                if (envEntry == null) {
                    try {
                        String lookup;
                        String descriptionAnnotation;
                        String mappdedNameAnnotation;
                        log.debug("addResource(): Does not exist in DD: " + resourceName);
                        envEntry = new EnvEntry();
                        envEntry.setEnvEntryName(resourceName);
                        if (!resourceType.equals(Object.class)) {
                            envEntry.setEnvEntryType(AbstractNamingBuilder.deprimitivize(resourceType).getCanonicalName());
                        }
                        if (!(mappdedNameAnnotation = annotation.mappedName()).equals("")) {
                            envEntry.setMappedName(mappdedNameAnnotation);
                        }
                        if (!(descriptionAnnotation = annotation.description()).equals("")) {
                            envEntry.setDescriptions(new Text[]{new Text(null, descriptionAnnotation)});
                        }
                        if (!(lookup = annotation.lookup()).equals("")) {
                            envEntry.setLookupName(lookup);
                        }
                        annotatedApp.getEnvEntry().add(envEntry);
                    }
                    catch (Exception anyException) {
                        log.debug("ResourceAnnotationHelper: Exception caught while processing <env-entry>");
                    }
                }
                if (!(method == null && field == null || EnvEntryRefProcessor.hasTarget((Method)method, (Field)field, (Set)(targets = envEntry.getInjectionTarget())))) {
                    envEntry.getInjectionTarget().add(EnvEntryRefProcessor.configureInjectionTarget((Method)method, (Field)field));
                }
                return true;
            }
            return false;
        }
    }
}

