/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.annotation.Injection;
import org.apache.geronimo.j2ee.annotation.ReferenceType;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.jndi.JndiKey;
import org.apache.geronimo.j2ee.jndi.JndiScope;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.xbeans.geronimo.naming.GerAbstractNamingEntryDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerAbstractNamingEntryType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNamingBuilder
implements NamingBuilder {
    private final Logger log = LoggerFactory.getLogger(AbstractNamingBuilder.class);
    protected static final QName BASE_NAMING_QNAME = GerAbstractNamingEntryType.type.getDocumentElementName();
    protected static final String J2EE_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    protected static final String JEE_NAMESPACE = "http://java.sun.com/xml/ns/javaee";
    protected static final NamespaceElementConverter J2EE_CONVERTER = new NamespaceElementConverter("http://java.sun.com/xml/ns/j2ee");
    protected static final NamespaceElementConverter JEE_CONVERTER = new NamespaceElementConverter("http://java.sun.com/xml/ns/javaee");
    protected static final NamespaceElementConverter NAMING_CONVERTER = new NamespaceElementConverter(GerAbstractNamingEntryDocument.type.getDocumentElementName().getNamespaceURI());
    private final Environment defaultEnvironment;
    private static final Map<Class<?>, Class<?>> primitives = new HashMap();

    protected AbstractNamingBuilder() {
        this.defaultEnvironment = null;
    }

    protected AbstractNamingBuilder(Environment defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    public Environment getEnvironment() {
        return this.defaultEnvironment;
    }

    public void buildEnvironment(JndiConsumer specDD, XmlObject plan, Environment environment) throws DeploymentException {
        EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
    }

    protected boolean willMergeEnvironment(JndiConsumer specDD, XmlObject plan) throws DeploymentException {
        return false;
    }

    protected boolean matchesDefaultEnvironment(Environment environment) {
        for (Dependency defaultDependency : this.defaultEnvironment.getDependencies()) {
            boolean matches = false;
            for (Dependency actualDependency : environment.getDependencies()) {
                if (!this.matches(defaultDependency, actualDependency)) continue;
                matches = true;
                break;
            }
            if (matches) continue;
            return false;
        }
        return true;
    }

    private boolean matches(Dependency defaultDependency, Dependency actualDependency) {
        if (defaultDependency.getArtifact().matches(actualDependency.getArtifact()) || actualDependency.getArtifact().matches(defaultDependency.getArtifact())) {
            return defaultDependency.getImportType() == actualDependency.getImportType() || actualDependency.getImportType() == ImportType.ALL;
        }
        return false;
    }

    public void initContext(JndiConsumer specDD, XmlObject plan, Module module) throws DeploymentException {
    }

    public int getPriority() {
        return 50;
    }

    protected void put(String key, Object value, ReferenceType type, Map<JndiKey, Map<String, Object>> contexts, Set<InjectionTarget> injectionTargets, Map<EARContext.Key, Object> sharedContext) {
        JndiKey jndiKey = this.keyFor(key = this.normalize(key));
        Map<String, Object> scope = contexts.get(jndiKey);
        if (scope == null) {
            scope = new HashMap<String, Object>();
            contexts.put(jndiKey, scope);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("binding at name " + key + " in scope " + jndiKey + " value " + value);
        }
        scope.put(key, value);
        this.addInjections(key, type, injectionTargets, (Holder)NamingBuilder.INJECTION_KEY.get(sharedContext));
    }

    protected Object lookupJndiContextMap(Module module, String key) {
        JndiKey jndiKey = this.keyFor(key = this.normalize(key));
        Map scope = module.getJndiScope(jndiKey);
        if (scope == null) {
            return null;
        }
        return scope.get(key);
    }

    protected String normalize(String name) {
        if (name.startsWith("java:")) {
            return name.substring("java:".length());
        }
        throw new IllegalArgumentException("All jndi names should start with java: not " + name);
    }

    protected JndiKey keyFor(String name) {
        int pos = name.indexOf("/");
        if (pos == -1) {
            throw new IllegalArgumentException("no possible key in " + name);
        }
        String type = name.substring(0, pos);
        return JndiScope.valueOf((String)type);
    }

    protected boolean isSharableJndiNamespace(String name) {
        return (name = this.normalize(name)).startsWith("app/") || name.startsWith("module/") || name.startsWith("global/");
    }

    protected static String getJndiName(String name) {
        if (name.indexOf(58) == -1) {
            return "java:comp/env/" + name.trim();
        }
        return name.trim();
    }

    protected AbstractName getGBeanName(Map<EARContext.Key, Object> sharedContext) {
        return (AbstractName)GBEAN_NAME_KEY.get(sharedContext);
    }

    protected static QNameSet buildQNameSet(String[] eeNamespaces, String localPart) {
        HashSet<QName> qnames = new HashSet<QName>(eeNamespaces.length);
        for (int i = 0; i < eeNamespaces.length; ++i) {
            String namespace = eeNamespaces[i];
            qnames.add(new QName(namespace, localPart));
        }
        return QNameSet.forSets(null, (Set)Collections.EMPTY_SET, (Set)Collections.EMPTY_SET, qnames);
    }

    protected static XmlObject[] convert(XmlObject[] xmlObjects, NamespaceElementConverter converter, SchemaType type) throws DeploymentException {
        XmlObject[] converted = new XmlObject[xmlObjects.length];
        for (int i = 0; i < xmlObjects.length; ++i) {
            XmlObject xmlObject = xmlObjects[i].copy();
            if (xmlObject.schemaType() != type) {
                converter.convertElement(xmlObject);
                converted[i] = xmlObject.changeType(type);
            } else {
                converted[i] = xmlObject;
            }
            try {
                XmlBeansUtil.validateDD((XmlObject)converted[i]);
                continue;
            }
            catch (XmlException e) {
                throw new DeploymentException("Could not validate xmlObject of type " + type, (Throwable)e);
            }
        }
        return converted;
    }

    protected static <T extends XmlObject> List<T> convert(XmlObject[] xmlObjects, NamespaceElementConverter converter, Class<T> c, SchemaType type) throws DeploymentException {
        ArrayList<XmlObject> result = new ArrayList<XmlObject>(xmlObjects.length);
        for (XmlObject xmlObject : xmlObjects) {
            xmlObject = AbstractNamingBuilder.convert(xmlObject, converter, type);
            result.add(xmlObject);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static XmlObject convert(XmlObject xmlObject, NamespaceElementConverter converter, SchemaType type) throws DeploymentException {
        HashMap ns = new HashMap();
        XmlCursor cursor = xmlObject.newCursor();
        try {
            cursor.getAllNamespaces(ns);
        }
        finally {
            cursor.dispose();
        }
        xmlObject = xmlObject.copy();
        cursor = xmlObject.newCursor();
        cursor.toNextToken();
        try {
            Iterator i$ = ns.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i$.next();
                cursor.insertNamespace((String)entry.getKey(), (String)entry.getValue());
            }
        }
        finally {
            cursor.dispose();
        }
        if (xmlObject.schemaType() != type) {
            converter.convertElement(xmlObject);
            xmlObject = xmlObject.changeType(type);
        }
        try {
            XmlBeansUtil.validateDD((XmlObject)xmlObject);
        }
        catch (XmlException e) {
            throw new DeploymentException("Could not validate xmlObject of type " + type, (Throwable)e);
        }
        return xmlObject;
    }

    protected static String getStringValue(String s) {
        return s == null ? null : s.trim();
    }

    public static AbstractNameQuery buildAbstractNameQuery(GerPatternType pattern, String type, String moduleType, Set interfaceTypes) {
        return ENCConfigBuilder.buildAbstractNameQueryFromPattern(pattern, null, type, moduleType, interfaceTypes);
    }

    public static AbstractNameQuery buildAbstractNameQuery(Artifact configId, String module, String name, String type, String moduleType) {
        return ENCConfigBuilder.buildAbstractNameQuery(configId, module, AbstractNamingBuilder.normalizeJndiName(name), type, moduleType);
    }

    private static String normalizeJndiName(String name) {
        if (name.startsWith("java:")) {
            return name.substring(name.indexOf("/env/") + 5);
        }
        return name.trim();
    }

    public static Class assureInterface(String interfaceName, String superInterfaceName, String interfaceType, Bundle bundle) throws DeploymentException {
        Class superInterface;
        Class clazz;
        if (interfaceName == null || interfaceName.equals("")) {
            throw new DeploymentException("interface name cannot be blank");
        }
        try {
            clazz = bundle.loadClass(interfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(interfaceType + " interface class not found: " + interfaceName, (Throwable)e);
        }
        if (!clazz.isInterface()) {
            throw new DeploymentException(interfaceType + " interface is not an interface: " + interfaceName);
        }
        try {
            superInterface = bundle.loadClass(superInterfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Class " + superInterfaceName + " could not be loaded", (Throwable)e);
        }
        if (!superInterface.isAssignableFrom(clazz)) {
            throw new DeploymentException(interfaceType + " interface does not extend " + superInterfaceName + ": " + interfaceName);
        }
        return clazz;
    }

    protected void addInjections(String jndiName, ReferenceType type, Set<InjectionTarget> injectionTargets, Holder holder) {
        for (InjectionTarget injectionTarget : injectionTargets) {
            String targetName = injectionTarget.getInjectionTargetName().trim();
            String targetClassName = injectionTarget.getInjectionTargetClass().trim();
            holder.addInjection(targetClassName, new Injection(targetClassName, targetName, jndiName, type));
        }
    }

    protected static Artifact[] getConfigId(Configuration localConfiguration, Configuration earConfiguration) {
        if (localConfiguration == earConfiguration) {
            return new Artifact[]{earConfiguration.getId()};
        }
        return new Artifact[]{earConfiguration.getId(), localConfiguration.getId()};
    }

    public QName getBaseQName() {
        return BASE_NAMING_QNAME;
    }

    protected String inferAndCheckType(Module module, Bundle bundle, Set<InjectionTarget> injectionTargets, String name, String typeName) throws DeploymentException {
        Class<?> type = null;
        if (typeName != null) {
            try {
                type = bundle.loadClass(typeName);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load type class for env entry named: " + name, (Throwable)e);
            }
        }
        for (InjectionTarget injectionTarget : injectionTargets) {
            String className = AbstractNamingBuilder.getStringValue(injectionTarget.getInjectionTargetClass());
            try {
                Class<?> fieldType;
                Class clazz = bundle.loadClass(className);
                String fieldName = AbstractNamingBuilder.getStringValue(injectionTarget.getInjectionTargetName());
                type = fieldType = this.getField(clazz, fieldName);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load injection target class for env entry named: " + name + " in class: " + className, (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                throw new DeploymentException("could not access field for env entry named: " + name + " in class: " + className + "of type: " + type, (Throwable)e);
            }
        }
        if (type == null) {
            throw new DeploymentException("No way to determine type of env-entry " + name + " in component " + module.toString());
        }
        return type.getName();
    }

    private static Class<?> chooseType(String name, Class<?> originalType, Class<?> alternativeType) throws DeploymentException {
        alternativeType = AbstractNamingBuilder.deprimitivize(alternativeType);
        if ((originalType = AbstractNamingBuilder.deprimitivize(originalType)) == null) {
            return alternativeType;
        }
        if (!alternativeType.equals(originalType)) {
            if (alternativeType.isAssignableFrom(originalType)) {
                return originalType;
            }
            if (originalType.isAssignableFrom(alternativeType)) {
                return alternativeType;
            }
            throw new DeploymentException("Mismatched types in named: " + name + " type: " + originalType);
        }
        return originalType;
    }

    public static Class<?> deprimitivize(Class<?> fieldType) {
        fieldType = fieldType.isPrimitive() ? primitives.get(fieldType) : fieldType;
        return fieldType;
    }

    private Class<?> getField(Class<?> clazz, String fieldName) throws NoSuchFieldException, DeploymentException {
        Class<?> type = null;
        do {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                Resource resource = field.getAnnotation(Resource.class);
                type = resource != null && resource.type() != Object.class ? AbstractNamingBuilder.chooseType(fieldName, field.getType(), resource.type()) : field.getType();
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
            for (Method method : clazz.getDeclaredMethods()) {
                String setName;
                String methodName;
                if (method.getReturnType() != Void.TYPE || method.getParameterTypes().length != 1 || !(methodName = method.getName()).startsWith("set") || !fieldName.equals(setName = Introspector.decapitalize(methodName.substring(3)))) continue;
                Resource resource = method.getAnnotation(Resource.class);
                type = resource != null && resource.type() != Object.class ? AbstractNamingBuilder.chooseType(fieldName, method.getParameterTypes()[0], resource.type()) : method.getParameterTypes()[0];
            }
            if (type == null) continue;
            return AbstractNamingBuilder.deprimitivize(type);
        } while ((clazz = clazz.getSuperclass()) != null);
        throw new NoSuchFieldException(fieldName);
    }

    static {
        primitives.put(Boolean.TYPE, Boolean.class);
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Short.TYPE, Short.class);
    }
}

