/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.annotation.ResourceAnnotationHelper;
import org.apache.geronimo.j2ee.deployment.annotation.WebServiceRefAnnotationHelper;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.deployment.ServiceRefBuilder;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.ServiceRef;
import org.apache.openejb.jee.Text;
import org.apache.xbean.finder.AbstractFinder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchingServiceRefBuilder
extends AbstractNamingBuilder {
    private static final Logger log = LoggerFactory.getLogger(SwitchingServiceRefBuilder.class);
    private static final QName GER_SERVICE_REF_QNAME = GerServiceRefDocument.type.getDocumentElementName();
    private static final QNameSet GER_SERVICE_REF_QNAME_SET = QNameSet.singleton((QName)GER_SERVICE_REF_QNAME);
    private final QNameSet serviceRefQNameSet;
    private final Collection jaxrpcBuilders;
    private final Collection jaxwsBuilders;
    public static final GBeanInfo GBEAN_INFO;

    public SwitchingServiceRefBuilder(String[] eeNamespaces, Collection jaxrpcBuilders, Collection jaxwsBuilders) {
        super(null);
        this.jaxrpcBuilders = jaxrpcBuilders;
        this.jaxwsBuilders = jaxwsBuilders;
        this.serviceRefQNameSet = SwitchingServiceRefBuilder.buildQNameSet(eeNamespaces, "service-ref");
    }

    @Override
    public void buildEnvironment(JndiConsumer specDD, XmlObject plan, Environment environment) throws DeploymentException {
        if (this.jaxrpcBuilders != null && !this.jaxrpcBuilders.isEmpty()) {
            this.mergeEnvironment(environment, this.getJAXRCPBuilder());
        }
        if (this.jaxwsBuilders != null && !this.jaxwsBuilders.isEmpty()) {
            this.mergeEnvironment(environment, this.getJAXWSBuilder());
        }
    }

    public void buildNaming(JndiConsumer specDD, XmlObject plan, Module module, Map<EARContext.Key, Object> sharedContext) throws DeploymentException {
        if (module != null && module.getClassFinder() != null) {
            this.processAnnotations(specDD, module);
        }
        Collection serviceRefs = specDD.getServiceRef();
        XmlObject[] gerServiceRefsUntyped = plan == null ? NO_REFS : plan.selectChildren(GER_SERVICE_REF_QNAME_SET);
        Map<String, GerServiceRefType> serviceRefMap = this.mapServiceRefs(gerServiceRefsUntyped);
        if (serviceRefs.size() > 0) {
            Bundle bundle = module.getEarContext().getDeploymentBundle();
            Class jaxrpcClass = this.loadClass("javax.xml.rpc.Service", bundle);
            Class jaxwsClass = this.loadClass("javax.xml.ws.Service", bundle);
            for (ServiceRef serviceRef : serviceRefs) {
                String name = SwitchingServiceRefBuilder.getStringValue(serviceRef.getServiceRefName());
                GerServiceRefType gerServiceRefType = serviceRefMap.get(name);
                serviceRefMap.remove(name);
                String serviceInterfaceName = serviceRef.getServiceInterface();
                Class serviceInterfaceClass = this.loadClass(serviceInterfaceName, bundle);
                if (jaxrpcClass.isAssignableFrom(serviceInterfaceClass)) {
                    ServiceRefBuilder jaxrpcBuilder = this.getJAXRCPBuilder();
                    jaxrpcBuilder.buildNaming(serviceRef, gerServiceRefType, module, sharedContext);
                    continue;
                }
                if (jaxwsClass.isAssignableFrom(serviceInterfaceClass)) {
                    ServiceRefBuilder jaxwsBuilder = this.getJAXWSBuilder();
                    jaxwsBuilder.buildNaming(serviceRef, gerServiceRefType, module, sharedContext);
                    continue;
                }
                throw new DeploymentException(serviceInterfaceName + " does not extend " + jaxrpcClass.getName() + " or " + jaxwsClass.getName());
            }
        }
        if (serviceRefMap.size() > 0) {
            log.warn("Failed to build reference to service reference " + serviceRefMap.keySet() + " defined in plan file, reason - corresponding entry in deployment descriptor missing.");
        }
    }

    private ServiceRefBuilder getJAXWSBuilder() throws DeploymentException {
        ServiceRefBuilder jaxwsBuilder = null;
        if (this.jaxwsBuilders == null || this.jaxwsBuilders.isEmpty()) {
            throw new DeploymentException("No JAX-WS ServiceRefBuilders registered");
        }
        jaxwsBuilder = (ServiceRefBuilder)this.jaxwsBuilders.iterator().next();
        return jaxwsBuilder;
    }

    private ServiceRefBuilder getJAXRCPBuilder() throws DeploymentException {
        ServiceRefBuilder jaxrpcBuilder = null;
        if (this.jaxrpcBuilders == null || this.jaxrpcBuilders.isEmpty()) {
            throw new DeploymentException("No JAX-RPC ServiceRefBuilders registered");
        }
        jaxrpcBuilder = (ServiceRefBuilder)this.jaxrpcBuilders.iterator().next();
        return jaxrpcBuilder;
    }

    private void mergeEnvironment(Environment environment, ServiceRefBuilder builder) {
        Environment env = builder.getEnvironment();
        if (env != null) {
            EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)env);
        }
    }

    private Class loadClass(String name, Bundle bundle) throws DeploymentException {
        try {
            return bundle.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load service class " + name, (Throwable)e);
        }
    }

    private Map<String, GerServiceRefType> mapServiceRefs(XmlObject[] refs) {
        if (refs != null && refs.length > 0) {
            HashMap<String, GerServiceRefType> refMap = new HashMap<String, GerServiceRefType>();
            for (int i = 0; i < refs.length; ++i) {
                GerServiceRefType ref = (GerServiceRefType)refs[i].copy().changeType(GerServiceRefType.type);
                String serviceRefName = ref.getServiceRefName().trim();
                refMap.put(serviceRefName, ref);
            }
            return refMap;
        }
        return Collections.emptyMap();
    }

    private void processAnnotations(JndiConsumer specDD, Module module) throws DeploymentException {
        try {
            WebServiceRefAnnotationHelper.processAnnotations((JndiConsumer)specDD, (AbstractFinder)module.getClassFinder());
            ResourceAnnotationHelper.processAnnotations((JndiConsumer)specDD, (AbstractFinder)module.getClassFinder(), (ResourceAnnotationHelper.ResourceProcessor)ServiceRefProcessor.INSTANCE);
        }
        catch (Exception e) {
            log.warn("Unable to process @Resource annotations for module" + module.getName(), (Throwable)e);
        }
    }

    public QNameSet getSpecQNameSet() {
        return this.serviceRefQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return GER_SERVICE_REF_QNAME_SET;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(SwitchingServiceRefBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("eeNamespaces", String[].class, true, true);
        infoBuilder.addReference("JAXRPCBuilder", ServiceRefBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("JAXWSBuilder", ServiceRefBuilder.class, "ModuleBuilder");
        infoBuilder.setConstructor(new String[]{"eeNamespaces", "JAXRPCBuilder", "JAXWSBuilder"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    public static class ServiceRefProcessor
    extends ResourceAnnotationHelper.ResourceProcessor {
        public static final ServiceRefProcessor INSTANCE = new ServiceRefProcessor();

        private ServiceRefProcessor() {
        }

        public boolean processResource(JndiConsumer jndiConsumer, Resource annotation, Class cls, Method method, Field field) {
            log.debug("processResource( [annotatedApp] " + jndiConsumer.toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "," + '\n' + "[method] " + (method != null ? method.getName() : null) + "," + '\n' + "[field] " + (field != null ? field.getName() : null) + " ): Entry");
            String resourceName = ServiceRefProcessor.getResourceName((Resource)annotation, (Method)method, (Field)field);
            String resourceType = ServiceRefProcessor.getResourceType((Resource)annotation, (Method)method, (Field)field);
            log.debug("processResource(): resourceName: " + resourceName);
            log.debug("processResource(): resourceType: " + resourceType);
            if (resourceType.equals("javax.xml.rpc.Service") || resourceType.equals("javax.xml.ws.Service") || resourceType.equals("javax.jws.WebService")) {
                log.debug("processResource(): <service-ref> found");
                boolean exists = false;
                Collection serviceRefs = jndiConsumer.getServiceRef();
                for (ServiceRef serviceRef : serviceRefs) {
                    Set targets;
                    if (!serviceRef.getServiceRefName().trim().equals(resourceName)) continue;
                    if (!(method == null && field == null || ServiceRefProcessor.hasTarget((Method)method, (Field)field, (Set)(targets = serviceRef.getInjectionTarget())))) {
                        serviceRef.getInjectionTarget().add(ServiceRefProcessor.configureInjectionTarget((Method)method, (Field)field));
                    }
                    exists = true;
                    break;
                }
                if (!exists) {
                    try {
                        log.debug("processResource(): Does not exist in DD: " + resourceName);
                        ServiceRef serviceRef = new ServiceRef();
                        serviceRef.setServiceRefName(resourceName);
                        serviceRef.setServiceInterface(resourceType);
                        String descriptionAnnotation = annotation.description();
                        if (!descriptionAnnotation.equals("")) {
                            serviceRef.setDescriptions(new Text[]{new Text(null, descriptionAnnotation)});
                        }
                        if (serviceRef.getServiceRefType() == null) {
                            serviceRef.setServiceRefType(resourceType);
                        }
                        if (method != null || field != null) {
                            serviceRef.getInjectionTarget().add(ServiceRefProcessor.configureInjectionTarget((Method)method, (Field)field));
                        }
                        if (serviceRef.getMappedName() == null && annotation.mappedName().trim().length() > 0) {
                            serviceRef.setMappedName(annotation.mappedName().trim());
                        }
                        jndiConsumer.getServiceRef().add(serviceRef);
                    }
                    catch (Exception anyException) {
                        log.debug("SwitchServiceRefBuilder: Exception caught while processing <service-ref>");
                    }
                }
                return true;
            }
            return false;
        }
    }
}

