/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.naming.reference.GBeanReference;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;

public class GBeanRefBuilder
implements NamingBuilder {
    private static final QName GBEAN_REF_QNAME = GerGbeanRefDocument.type.getDocumentElementName();
    private static final QNameSet GBEAN_REF_QNAME_SET = QNameSet.singleton((QName)GBEAN_REF_QNAME);
    public static final GBeanInfo GBEAN_INFO;

    public void buildEnvironment(XmlObject specDD, XmlObject plan, Environment environment) {
    }

    public void initContext(XmlObject specDD, XmlObject plan, Configuration localConfiguration, Configuration remoteConfiguration, Module module) throws DeploymentException {
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Configuration localConfiguration, Configuration remoteConfiguration, Module module, Map componentContext) throws DeploymentException {
        if (plan == null) {
            return;
        }
        XmlObject[] gbeanRefsUntyped = plan == null ? NO_REFS : plan.selectChildren(GBEAN_REF_QNAME_SET);
        for (int i = 0; i < gbeanRefsUntyped.length; ++i) {
            Class gBeanType;
            GBeanData gBeanData;
            XmlObject gbeanRefUntyped = gbeanRefsUntyped[i];
            GerGbeanRefType gbeanRef = (GerGbeanRefType)gbeanRefUntyped.copy().changeType(GerGbeanRefType.type);
            if (gbeanRef == null) {
                throw new DeploymentException("Could not read gbeanRef " + gbeanRefUntyped + " as the correct xml type");
            }
            GerPatternType[] gbeanLocatorArray = gbeanRef.getPatternArray();
            String[] interfaceTypesArray = gbeanRef.getRefTypeArray();
            HashSet<String> interfaceTypes = new HashSet<String>(Arrays.asList(interfaceTypesArray));
            HashSet<AbstractNameQuery> queries = new HashSet<AbstractNameQuery>();
            for (int j = 0; j < gbeanLocatorArray.length; ++j) {
                GerPatternType patternType = gbeanLocatorArray[j];
                AbstractNameQuery abstractNameQuery = ENCConfigBuilder.buildAbstractNameQuery(patternType, null, null, interfaceTypes);
                queries.add(abstractNameQuery);
            }
            try {
                gBeanData = localConfiguration.findGBeanData(queries);
            }
            catch (GBeanNotFoundException e) {
                throw new DeploymentException("Could not resolve reference at deploy time for queries " + queries, (Throwable)e);
            }
            if (interfaceTypes.isEmpty()) {
                interfaceTypes.add(gBeanData.getGBeanInfo().getClassName());
            }
            ClassLoader cl = module.getEarContext().getClassLoader();
            try {
                gBeanType = ClassLoading.loadClass((String)gBeanData.getGBeanInfo().getClassName(), (ClassLoader)cl);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Cannot load GBean class", (Throwable)e);
            }
            String refName = gbeanRef.getRefName();
            ((Map)componentContext.get("JNDI_COMPONENT_CONTEXT")).put("env/" + refName, new GBeanReference(localConfiguration.getId(), queries, gBeanType));
        }
    }

    public QNameSet getSpecQNameSet() {
        return QNameSet.EMPTY;
    }

    public QNameSet getPlanQNameSet() {
        return GBEAN_REF_QNAME_SET;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)GBeanRefBuilder.class, (String)"ModuleBuilder");
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

