/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import [Ljava.lang.String;;
import java.util.Map;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.reference.KernelReference;
import org.apache.geronimo.xbeans.j2ee.EnvEntryType;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;

public class EnvironmentEntryBuilder
extends AbstractNamingBuilder {
    private final QNameSet envEntryQNameSet;
    public static final GBeanInfo GBEAN_INFO;

    public EnvironmentEntryBuilder(String[] eeNamespaces) {
        this.envEntryQNameSet = EnvironmentEntryBuilder.buildQNameSet(eeNamespaces, "env-entry");
    }

    public void buildEnvironment(XmlObject specDD, XmlObject plan, Environment environment) {
    }

    public void initContext(XmlObject specDD, XmlObject plan, Configuration localConfiguration, Configuration remoteConfiguration, Module module) throws DeploymentException {
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Configuration localConfiguration, Configuration remoteConfiguration, Module module, Map componentContext) throws DeploymentException {
        XmlObject[] envEntriesUntyped = EnvironmentEntryBuilder.convert(specDD.selectChildren(this.envEntryQNameSet), J2EE_CONVERTER, EnvEntryType.type);
        for (int i = 0; i < envEntriesUntyped.length; ++i) {
            EnvEntryType envEntry = (EnvEntryType)envEntriesUntyped[i];
            String name = envEntry.getEnvEntryName().getStringValue().trim();
            String type = envEntry.getEnvEntryType().getStringValue().trim();
            String text = envEntry.getEnvEntryValue().getStringValue().trim();
            try {
                Object value;
                if (text == null) {
                    value = "org.apache.geronimo.kernel.Kernel".equals(type) ? new KernelReference() : null;
                } else if ("java.lang.String".equals(type)) {
                    value = text;
                } else if ("java.lang.Character".equals(type)) {
                    value = new Character(text.charAt(0));
                } else if ("java.lang.Boolean".equals(type)) {
                    value = Boolean.valueOf(text);
                } else if ("java.lang.Byte".equals(type)) {
                    value = Byte.valueOf(text);
                } else if ("java.lang.Short".equals(type)) {
                    value = Short.valueOf(text);
                } else if ("java.lang.Integer".equals(type)) {
                    value = Integer.valueOf(text);
                } else if ("java.lang.Long".equals(type)) {
                    value = Long.valueOf(text);
                } else if ("java.lang.Float".equals(type)) {
                    value = Float.valueOf(text);
                } else if ("java.lang.Double".equals(type)) {
                    value = Double.valueOf(text);
                } else {
                    throw new DeploymentException("unrecognized type: " + type);
                }
                this.getJndiContextMap(componentContext).put("env/" + name, value);
                continue;
            }
            catch (NumberFormatException e) {
                throw new DeploymentException("Invalid env-entry value for name: " + name, (Throwable)e);
            }
        }
    }

    public QNameSet getSpecQNameSet() {
        return this.envEntryQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return QNameSet.EMPTY;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)EnvironmentEntryBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("eeNamespaces", String;.class, true, true);
        infoBuilder.setConstructor(new String[]{"eeNamespaces"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

