/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.myfaces.config.resource;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.myfaces.config.element.FacesConfig;
import org.osgi.framework.Bundle;

public class ConfigurationResource
implements Serializable {
    private String configurationResourcePath;
    private String jarFilePath;
    private transient FacesConfig facesConfig;

    public ConfigurationResource(String jarFilePath, String configurationResourcePath) {
        this.jarFilePath = jarFilePath;
        this.configurationResourcePath = configurationResourcePath.startsWith("/") ? configurationResourcePath : "/" + configurationResourcePath;
    }

    public String getConfigurationResourcePath() {
        return this.configurationResourcePath;
    }

    public String getJarFilePath() {
        return this.jarFilePath;
    }

    public void setJarFilePath(String jarFilePath) {
        this.jarFilePath = jarFilePath;
    }

    public void setConfigurationResourcePath(String configurationResourcePath) {
        this.configurationResourcePath = configurationResourcePath;
    }

    public URL getConfigurationResourceURL(Bundle bundle) throws MalformedURLException {
        if (this.jarFilePath == null) {
            return bundle.getEntry(this.configurationResourcePath);
        }
        return new URL("jar:" + bundle.getEntry(this.jarFilePath) + "!" + this.configurationResourcePath);
    }

    public void setFacesConfig(FacesConfig facesConfig) {
        this.facesConfig = facesConfig;
    }

    public FacesConfig getFacesConfig() {
        return this.facesConfig;
    }

    public String toString() {
        return "ConfigurationResource [configurationResourcePath=" + this.configurationResourcePath + ", jarFilePath=" + this.jarFilePath + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configurationResourcePath == null ? 0 : this.configurationResourcePath.hashCode());
        result = 31 * result + (this.jarFilePath == null ? 0 : this.jarFilePath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationResource other = (ConfigurationResource)obj;
        if (this.configurationResourcePath == null ? other.configurationResourcePath != null : !this.configurationResourcePath.equals(other.configurationResourcePath)) {
            return false;
        }
        return !(this.jarFilePath == null ? other.jarFilePath != null : !this.jarFilePath.equals(other.jarFilePath));
    }
}

