/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.resource.mail;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.OsgiService;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.management.JavaMailResource;
import org.apache.geronimo.naming.ResourceSource;
import org.apache.geronimo.resource.mail.ProtocolGBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="JavaMailResource")
@OsgiService
public class MailGBean
implements GBeanLifecycle,
JavaMailResource,
ResourceSource {
    private static final Logger log = LoggerFactory.getLogger(MailGBean.class);
    private final String objectName;
    private final Collection<ProtocolGBean> protocols;
    private Boolean useDefault;
    private Properties properties;
    private Authenticator authenticator;
    private String storeProtocol;
    private String transportProtocol;
    private String host;
    private String user;
    private Boolean debug;
    private String jndiName;
    private BundleContext bundleContext;
    private Context context = null;

    public MailGBean(@ParamSpecial(type=SpecialAttributeType.objectName) String objectName, @ParamReference(name="Protocols", namingType="GBean") Collection<ProtocolGBean> protocols, @ParamAttribute(name="useDefault") Boolean useDefault, @ParamAttribute(name="properties") Properties properties, @ParamReference(name="Authenticator", namingType="GBean") Authenticator authenticator, @ParamAttribute(name="storeProtocol") String storeProtocol, @ParamAttribute(name="transportProtocol") String transportProtocol, @ParamAttribute(name="host") String host, @ParamAttribute(name="user") String user, @ParamAttribute(name="debug") Boolean debug, @ParamAttribute(name="jndiName") String jndiName, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext) {
        this.objectName = objectName;
        this.protocols = protocols;
        this.setUseDefault(useDefault);
        this.properties = properties == null ? new Properties() : properties;
        this.setAuthenticator(authenticator);
        this.setStoreProtocol(storeProtocol);
        this.setTransportProtocol(transportProtocol);
        this.setHost(host);
        this.setUser(user);
        this.setDebug(debug);
        this.setJndiName(jndiName);
        this.bundleContext = bundleContext;
    }

    public Collection getProtocols() {
        return this.protocols;
    }

    public Boolean getUseDefault() {
        return this.useDefault;
    }

    public void setUseDefault(Boolean useDefault) {
        this.useDefault = useDefault;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public String getStoreProtocol() {
        return this.storeProtocol;
    }

    public void setStoreProtocol(String storeProtocol) {
        this.storeProtocol = storeProtocol;
    }

    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public void setTransportProtocol(String transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public Object $getResource() {
        Properties props = new Properties(this.properties);
        if (this.protocols != null) {
            for (ProtocolGBean protocol : this.protocols) {
                protocol.addOverrides(props);
            }
        }
        props.putAll((Map<?, ?>)this.properties);
        if (this.storeProtocol != null) {
            props.put("mail.store.protocol", this.storeProtocol);
        }
        if (this.transportProtocol != null) {
            props.put("mail.transport.protocol", this.transportProtocol);
        }
        if (this.host != null) {
            props.put("mail.host", this.host);
        }
        if (this.user != null) {
            props.put("mail.user", this.user);
        }
        if (this.debug != null) {
            props.put("mail.debug", this.debug.toString());
        }
        if (Boolean.TRUE.equals(this.useDefault)) {
            if (this.authenticator == null) {
                return Session.getDefaultInstance((Properties)props);
            }
            return Session.getDefaultInstance((Properties)props, (Authenticator)this.authenticator);
        }
        if (this.authenticator == null) {
            return Session.getInstance((Properties)props);
        }
        return Session.getInstance((Properties)props, (Authenticator)this.authenticator);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doStart() throws Exception {
        log.debug("Started " + this.objectName + " - will return " + (Boolean.TRUE.equals(this.useDefault) ? "default" : "new") + " JavaMail Session " + (this.authenticator == null ? "without" : "with") + " authenticator");
        String jndiName = this.getJndiName();
        if (jndiName == null) return;
        if (jndiName.length() <= 0) return;
        Object value = this.$getResource();
        int index = jndiName.indexOf(":");
        if (index <= 0) {
            log.error("Wrong " + jndiName);
            throw new NamingException("Wrong " + jndiName + "for mail/MailSession");
        }
        String scheme = jndiName.substring(0, index);
        ServiceReference[] sr = this.bundleContext.getServiceReferences(ObjectFactory.class.getName(), "(osgi.jndi.url.scheme=" + scheme + ")");
        if (sr == null) {
            log.error("mail/MailSession JNDI namespace doesn't exist.");
            throw new NamingException("mail/MailSession JNDI namespace doesn't exist.");
        }
        ObjectFactory objectFactory = (ObjectFactory)this.bundleContext.getService(sr[0]);
        this.context = (Context)objectFactory.getObjectInstance(null, null, null, null);
        Name parsedName = this.context.getNameParser("").parse(jndiName);
        int i = 1;
        while (true) {
            if (i >= parsedName.size()) {
                this.context.bind(jndiName, value);
                log.info("JavaMail session bound to " + jndiName);
                return;
            }
            Name contextName = parsedName.getPrefix(i);
            if (!MailGBean.bindingExists(this.context, contextName)) {
                this.context.createSubcontext(contextName);
            }
            ++i;
        }
    }

    public void doStop() throws Exception {
        log.debug("Stopped " + this.objectName);
        this.stop();
    }

    public void doFail() {
        log.warn("Failed " + this.objectName);
        this.stop();
    }

    private void stop() {
        String jndiName = this.getJndiName();
        if (jndiName != null && jndiName.length() > 0) {
            try {
                if (this.context != null) {
                    this.context.unbind(jndiName);
                    log.info("JavaMail session unbound from " + jndiName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean bindingExists(Context context, Name contextName) {
        try {
            return context.lookup(contextName) != null;
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return false;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }
}

