/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;

public class ProtocolGBean
implements GBeanLifecycle {
    public static final String GBEAN_OBJECTNAME = "objectName";
    public static final String GBEAN_PROTOCOL = "protocol";
    public static final String GBEAN_PROPERTIES = "properties";
    public static final String GBEAN_HOST = "host";
    public static final String GBEAN_USER = "user";
    public static final String GBEAN_ADD_OVERRIDES = "addOverrides";
    public static final String GBEAN_PORT = "port";
    public static final String GBEAN_CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String GBEAN_TIMEOUT = "timeout";
    public static final String GBEAN_FROM = "from";
    public static final String GBEAN_AUTH = "auth";
    public static final String GBEAN_REALM = "saslRealm";
    public static final String GBEAN_QUITWAIT = "quitWait";
    public static final String GBEAN_FACTORY_CLASS = "socketFactoryClass";
    public static final String GBEAN_FACTORY_FALLBACK = "socketFactoryFallback";
    public static final String GBEAN_FACTORY_PORT = "socketFactoryPort";
    public static final String GBEAN_LOCALHOST = "localhost";
    public static final String GBEAN_LOCALADDRESS = "localaddress";
    public static final String GBEAN_LOCALPORT = "localport";
    private final Log log = LogFactory.getLog(ProtocolGBean.class);
    private final String objectName;
    private Properties properties;
    private final String protocol;
    private String host;
    private String user;
    public static final GBeanInfo GBEAN_INFO;

    public ProtocolGBean() {
        this.objectName = null;
        this.protocol = null;
        this.properties = null;
    }

    public ProtocolGBean(String objectName, String protocol, Properties properties, String host, String user) {
        assert (protocol != null);
        this.objectName = objectName;
        this.protocol = protocol;
        this.properties = properties == null ? new Properties() : properties;
        this.host = host;
        this.user = user;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void addOverrides(Properties props) {
        Enumeration<?> keys = this.properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            props.put(key, this.properties.getProperty(key));
        }
        if (this.host != null) {
            props.put("mail." + this.protocol + ".host", this.host);
        }
        if (this.user != null) {
            props.put("mail." + this.protocol + ".user", this.user);
        }
    }

    public void doStart() throws Exception {
        this.log.debug((Object)("Started " + this.objectName));
    }

    public void doStop() throws Exception {
        this.log.debug((Object)("Stopped " + this.objectName));
    }

    public void doFail() {
        this.log.warn((Object)("Failed " + this.objectName));
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ProtocolGBean.class);
        infoFactory.addAttribute(GBEAN_OBJECTNAME, String.class, false);
        infoFactory.addAttribute(GBEAN_PROTOCOL, String.class, true);
        infoFactory.addAttribute(GBEAN_PROPERTIES, Properties.class, true);
        infoFactory.addAttribute(GBEAN_HOST, String.class, true);
        infoFactory.addAttribute(GBEAN_USER, String.class, true);
        infoFactory.addOperation(GBEAN_ADD_OVERRIDES, new Class[]{Properties.class});
        infoFactory.setConstructor(new String[]{GBEAN_OBJECTNAME, GBEAN_PROTOCOL, GBEAN_PROPERTIES, GBEAN_HOST, GBEAN_USER});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

