/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ImportType
implements Serializable {
    private static final long serialVersionUID = 9084371394522950958L;
    private static final Map typesByName = new HashMap();
    public static final ImportType ALL = new ImportType("ALL");
    public static final ImportType CLASSES = new ImportType("CLASSES");
    public static final ImportType SERVICES = new ImportType("SERVICES");
    private final String name;

    public static Object getByName(String name) {
        ImportType type = (ImportType)typesByName.get(name);
        if (type == null) {
            throw new IllegalStateException("Unknown import type: " + name);
        }
        return type;
    }

    private ImportType(String name) {
        this.name = name;
        typesByName.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    protected Object readResolve() {
        String name = this.name;
        return ImportType.getByName(name);
    }
}

