/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.ObjectInputStreamExt;
import org.apache.geronimo.kernel.config.GBeanState;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.repository.Environment;

public class SerializedGBeanState
implements GBeanState,
Serializable {
    private static final long serialVersionUID = 6015138334529564307L;
    private final List gbeans = new ArrayList();
    private byte[] gbeanState;

    public SerializedGBeanState(Collection gbeans) {
        if (gbeans != null) {
            this.gbeans.addAll(gbeans);
        }
    }

    public List getGBeans(ClassLoader classLoader) throws InvalidConfigException {
        if (this.gbeanState == null) {
            return Collections.unmodifiableList(this.gbeans);
        }
        this.gbeans.addAll(SerializedGBeanState.loadGBeans(this.gbeanState, classLoader));
        return Collections.unmodifiableList(this.gbeans);
    }

    public void addGBean(GBeanData gbeanData) {
        if (this.gbeanState != null) {
            throw new IllegalStateException("GBeans have been serialized, so no more GBeans can be added");
        }
        this.gbeans.add(gbeanData);
    }

    public GBeanData addGBean(String name, GBeanInfo gbeanInfo, Naming naming, Environment environment) {
        if (this.gbeanState != null) {
            throw new IllegalStateException("GBeans have been serialized, so no more GBeans can be added");
        }
        String j2eeType = gbeanInfo.getJ2eeType();
        if (j2eeType == null) {
            j2eeType = "GBean";
        }
        AbstractName abstractName = naming.createRootName(environment.getConfigId(), name, j2eeType);
        GBeanData gBeanData = new GBeanData(abstractName, gbeanInfo);
        this.addGBean(gBeanData);
        return gBeanData;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.gbeanState == null) {
            this.gbeanState = SerializedGBeanState.storeGBeans(this.gbeans);
            this.gbeans.clear();
        }
        stream.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List loadGBeans(byte[] gbeanState, ClassLoader classLoader) throws InvalidConfigException {
        ArrayList<GBeanData> gbeans = new ArrayList<GBeanData>();
        if (gbeanState != null && gbeanState.length > 0) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                ObjectInputStreamExt ois = new ObjectInputStreamExt(new ByteArrayInputStream(gbeanState), classLoader);
                try {
                    try {
                        while (true) {
                            GBeanData gbeanData = new GBeanData();
                            gbeanData.readExternal(ois);
                            gbeans.add(gbeanData);
                        }
                    }
                    catch (EOFException e) {
                        ois.close();
                    }
                }
                catch (Throwable throwable) {
                    ois.close();
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new InvalidConfigException("Unable to deserialize GBeanState", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        return gbeans;
    }

    private static byte[] storeGBeans(List gbeans) throws IOException {
        ObjectOutputStream oos;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            oos = new ObjectOutputStream(baos);
        }
        catch (IOException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Unable to initialize ObjectOutputStream"))).initCause(e));
        }
        Iterator iterator = gbeans.iterator();
        while (iterator.hasNext()) {
            GBeanData gbeanData = (GBeanData)iterator.next();
            try {
                gbeanData.writeExternal(oos);
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unable to serialize GBeanData for " + gbeanData.getAbstractName()).initCause(e);
            }
        }
        try {
            oos.flush();
        }
        catch (IOException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Unable to flush ObjectOutputStream"))).initCause(e));
        }
        return baos.toByteArray();
    }
}

