/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.repository.Artifact;

public class AbstractNameQuery
implements Serializable {
    private static final long serialVersionUID = 7444620122607155678L;
    private final Artifact artifact;
    private final Map name;
    private final Set interfaceTypes;
    private final URI uri;

    public AbstractNameQuery(AbstractName abstractName) {
        this(abstractName, null);
    }

    public AbstractNameQuery(AbstractName abstractName, Set interfaceTypes) {
        this.artifact = abstractName.getArtifact();
        this.name = abstractName.getName();
        this.interfaceTypes = interfaceTypes == null ? Collections.EMPTY_SET : interfaceTypes;
        this.uri = AbstractNameQuery.createURI(this.artifact, this.name, this.interfaceTypes);
    }

    public AbstractNameQuery(Artifact artifact, Map name) {
        this.artifact = artifact;
        this.name = name;
        this.interfaceTypes = Collections.EMPTY_SET;
        this.uri = AbstractNameQuery.createURI(artifact, name, this.interfaceTypes);
    }

    public AbstractNameQuery(Artifact artifact, Map name, String interfaceType) {
        this.artifact = artifact;
        this.name = name;
        this.interfaceTypes = interfaceType != null ? Collections.singleton(interfaceType) : Collections.EMPTY_SET;
        this.uri = AbstractNameQuery.createURI(artifact, name, this.interfaceTypes);
    }

    public AbstractNameQuery(String interfaceType) {
        this.artifact = null;
        this.name = Collections.EMPTY_MAP;
        this.interfaceTypes = Collections.singleton(interfaceType);
        this.uri = AbstractNameQuery.createURI(this.artifact, this.name, this.interfaceTypes);
    }

    public AbstractNameQuery(Artifact artifact, Map name, Set interfaceTypes) {
        this.artifact = artifact;
        this.name = name;
        if (interfaceTypes == null) {
            interfaceTypes = Collections.EMPTY_SET;
        }
        this.interfaceTypes = interfaceTypes;
        this.uri = AbstractNameQuery.createURI(artifact, name, this.interfaceTypes);
    }

    public AbstractNameQuery(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        String artifactString = uri.getPath();
        if (artifactString != null && artifactString.length() > 0) {
            String type;
            String version;
            String artifactId;
            List artifactParts = AbstractNameQuery.split(artifactString, '/');
            if (artifactParts.size() != 4) {
                throw new IllegalArgumentException("uri path must be in the form [groupId]/[artifactId]/[version]/[type] : " + artifactString);
            }
            String groupId = (String)artifactParts.get(0);
            if (groupId.length() == 0) {
                groupId = null;
            }
            if ((artifactId = (String)artifactParts.get(1)).length() == 0) {
                artifactId = null;
            }
            if ((version = (String)artifactParts.get(2)).length() == 0) {
                version = null;
            }
            if ((type = (String)artifactParts.get(3)).length() == 0) {
                type = null;
            }
            this.artifact = new Artifact(groupId, artifactId, version, type);
        } else {
            this.artifact = null;
        }
        this.name = new TreeMap();
        String nameString = uri.getQuery();
        List nameParts = AbstractNameQuery.split(nameString, ',');
        Iterator iterator = nameParts.iterator();
        while (iterator.hasNext()) {
            String namePart = (String)iterator.next();
            List keyValue = AbstractNameQuery.split(namePart, '=');
            if (keyValue.size() != 2) {
                throw new IllegalArgumentException("uri query string must be in the form [vendorId]/artifactId/[version]/[type] : " + nameString);
            }
            String key = (String)keyValue.get(0);
            String value = (String)keyValue.get(1);
            if (this.name.containsKey(key)) {
                throw new IllegalArgumentException("uri query string contains the key '" + key + "' twice : " + nameString);
            }
            this.name.put(key, value);
        }
        String interfaceString = uri.getFragment();
        List interfaces = AbstractNameQuery.split(interfaceString, ',');
        this.interfaceTypes = new HashSet(interfaces);
        this.uri = AbstractNameQuery.createURI(this.artifact, this.name, this.interfaceTypes);
    }

    private static List split(String source, char delim) {
        ArrayList<String> parts = new ArrayList<String>();
        if (source != null && source.length() > 0) {
            int index = source.indexOf(delim);
            while (index >= 0) {
                String part = source.substring(0, index);
                source = source.substring(index + 1);
                parts.add(part);
                index = source.indexOf(delim);
            }
            parts.add(source);
        }
        return parts;
    }

    private static URI createURI(Artifact artifact, Map name, Set interfaceTypes) {
        StringBuffer queryString = new StringBuffer();
        TreeMap treeMap = new TreeMap(name);
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            queryString.append(key).append('=').append(value);
            if (!iterator.hasNext()) continue;
            queryString.append(',');
        }
        StringBuffer fragmentString = new StringBuffer();
        TreeSet treeSet = new TreeSet(interfaceTypes);
        Iterator iterator2 = treeSet.iterator();
        while (iterator2.hasNext()) {
            String interfaceType = (String)iterator2.next();
            fragmentString.append(interfaceType);
            if (!iterator2.hasNext()) continue;
            fragmentString.append(',');
        }
        try {
            return new URI(null, null, artifact == null ? null : artifact.toString(), queryString.toString(), fragmentString.toString());
        }
        catch (URISyntaxException e) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(e);
            throw illegalArgumentException;
        }
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Map getName() {
        return this.name;
    }

    public Set getInterfaceTypes() {
        return this.interfaceTypes;
    }

    public String toString() {
        return this.uri.toString();
    }

    public URI toURI() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNameQuery that = (AbstractNameQuery)o;
        if (this.artifact != null ? !this.artifact.equals(that.artifact) : that.artifact != null) {
            return false;
        }
        if (this.interfaceTypes != null ? !((Object)this.interfaceTypes).equals(that.interfaceTypes) : that.interfaceTypes != null) {
            return false;
        }
        return !(this.name == null ? that.name != null : !((Object)this.name).equals(that.name));
    }

    public int hashCode() {
        int result = this.artifact != null ? this.artifact.hashCode() : 0;
        result = 29 * result + (this.name != null ? ((Object)this.name).hashCode() : 0);
        result = 29 * result + (this.interfaceTypes != null ? ((Object)this.interfaceTypes).hashCode() : 0);
        return result;
    }

    public boolean matches(AbstractName info, Set targetInterfaceTypes) {
        if (!info.getName().entrySet().containsAll(this.name.entrySet())) {
            return false;
        }
        if (!targetInterfaceTypes.containsAll(this.interfaceTypes)) {
            return false;
        }
        if (this.artifact == null) {
            return true;
        }
        Artifact otherArtifact = info.getArtifact();
        return this.artifact.matches(otherArtifact);
    }

    public boolean matches(AbstractNameQuery info) {
        if (!info.getName().entrySet().containsAll(this.name.entrySet())) {
            return false;
        }
        if (!info.getInterfaceTypes().containsAll(this.interfaceTypes)) {
            return false;
        }
        if (this.artifact == null) {
            return true;
        }
        Artifact otherArtifact = info.getArtifact();
        return this.artifact.matches(otherArtifact);
    }
}

