/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8.handler;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.jacc.WebRoleRefPermission;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaspi.UserIdentity;
import org.eclipse.jetty.server.UserIdentity;

public class GeronimoJettyUserIdentity
implements org.eclipse.jetty.server.UserIdentity {
    private final UserIdentity userIdentity;

    public GeronimoJettyUserIdentity(UserIdentity userIdentity) {
        this.userIdentity = userIdentity;
    }

    public Subject getSubject() {
        return this.userIdentity.getSubject();
    }

    public Principal getUserPrincipal() {
        return this.userIdentity.getUserPrincipal();
    }

    public boolean isUserInRole(String role, UserIdentity.Scope scope) {
        String servletName = scope.getName();
        if (servletName == null || servletName.equals("jsp")) {
            servletName = "";
        }
        try {
            AccessControlContext acc = ContextManager.getCurrentContext();
            acc.checkPermission((Permission)new WebRoleRefPermission(servletName, role));
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public String toString() {
        return "GeronimoJettyUserIdentity[Subject: " + this.getSubject() + ", Principal: " + this.getUserPrincipal() + "]";
    }

    public AccessControlContext getAccessControlContext() {
        return this.userIdentity.getAccessControlContext();
    }
}

