/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8.handler;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.jetty8.JettyContainer;
import org.apache.geronimo.jetty8.handler.GeronimoJettyUserIdentity;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jacc.PolicyContextHandlerHttpServletRequest;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;

public class JaccSecurityHandler
extends SecurityHandler {
    private final String policyContextID;
    private final AccessControlContext defaultAcc;

    public JaccSecurityHandler(String policyContextID, Authenticator authenticator, LoginService loginService, IdentityService identityService, AccessControlContext defaultAcc) {
        this.setAuthenticator(authenticator);
        this.policyContextID = policyContextID;
        this.defaultAcc = defaultAcc;
        loginService.setIdentityService(identityService);
        this.setLoginService(loginService);
        this.setIdentityService(identityService);
    }

    public void doStop(JettyContainer jettyContainer) throws Exception {
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String old_policy_id = PolicyContext.getContextID();
        Callers oldCallers = ContextManager.getCallers();
        HttpServletRequest oldRequest = PolicyContextHandlerHttpServletRequest.pushContextData((HttpServletRequest)request);
        try {
            PolicyContext.setContextID((String)this.policyContextID);
            super.handle(target, baseRequest, request, response);
        }
        finally {
            PolicyContext.setContextID((String)old_policy_id);
            ContextManager.popCallers((Callers)oldCallers);
            PolicyContextHandlerHttpServletRequest.popContextData((HttpServletRequest)oldRequest);
        }
    }

    protected Object prepareConstraintInfo(String pathInContext, Request request) {
        return null;
    }

    protected boolean checkUserDataPermissions(String pathInContext, Request request, Response response, Object constraintInfo) throws IOException {
        boolean notIntegral = request.isSecure() || !request.getConnection().isIntegral(request);
        try {
            WebUserDataPermission wudp = notIntegral ? new WebUserDataPermission((HttpServletRequest)request) : new WebUserDataPermission(JaccSecurityHandler.encodeColons((HttpServletRequest)request), new String[]{request.getMethod()}, "INTEGRAL");
            this.defaultAcc.checkPermission((Permission)wudp);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    private static String encodeColons(HttpServletRequest request) {
        String result = request.getServletPath() + (request.getPathInfo() == null ? "" : request.getPathInfo());
        if (result.indexOf(":") > -1) {
            result = result.replaceAll(":", "%3A");
        }
        return result;
    }

    protected boolean isAuthMandatory(Request base_request, Response base_response, Object constraintInfo) {
        return !this.checkWebResourcePermission(base_request, this.defaultAcc);
    }

    protected boolean checkWebResourcePermissions(String pathInContext, Request request, Response response, Object constraintInfo, UserIdentity userIdentity) throws IOException {
        if (!(userIdentity instanceof GeronimoJettyUserIdentity)) {
            return false;
        }
        AccessControlContext acc = ((GeronimoJettyUserIdentity)userIdentity).getAccessControlContext();
        return this.checkWebResourcePermission(request, acc);
    }

    private boolean checkWebResourcePermission(Request request, AccessControlContext acc) {
        WebResourcePermission webResourcePermission = new WebResourcePermission((HttpServletRequest)request);
        try {
            acc.checkPermission((Permission)webResourcePermission);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }
}

