/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8;

import java.util.Collection;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.jetty8.FilterHolderWrapper;
import org.apache.geronimo.jetty8.JettyServletRegistration;
import org.apache.geronimo.jetty8.ServletNameSource;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHandler;

@GBean(j2eeType="URLWebFilterMapping")
public class JettyFilterMapping
extends FilterMapping {
    private final String[] urlPatterns;
    private final boolean requestDispatch;
    private final boolean forwardDispatch;
    private final boolean includeDispatch;
    private final boolean errorDispatch;
    private final FilterHolderWrapper jettyFilterHolder;
    private final Collection<ServletNameSource> jettyServletHolders;
    private final JettyFilterMapping previous;
    private final JettyServletRegistration jettyServletRegistration;

    public JettyFilterMapping(@ParamAttribute(name="urlPatterns") String[] urlPatterns, @ParamAttribute(name="requestDispatch") boolean requestDispatch, @ParamAttribute(name="forwardDispatch") boolean forwardDispatch, @ParamAttribute(name="includeDispatch") boolean includeDispatch, @ParamAttribute(name="errorDispatch") boolean errorDispatch, @ParamReference(name="Filter", namingType="WebFilter") FilterHolderWrapper jettyFilterHolder, @ParamReference(name="Servlets", namingType="Servlet") Collection<ServletNameSource> jettyServletHolders, @ParamReference(name="Previous", namingType="URLWebFilterMapping") JettyFilterMapping previous, @ParamReference(name="JettyServletRegistration", namingType="WebModule") JettyServletRegistration jettyServletRegistration) {
        this.urlPatterns = urlPatterns;
        this.requestDispatch = requestDispatch;
        this.forwardDispatch = forwardDispatch;
        this.includeDispatch = includeDispatch;
        this.errorDispatch = errorDispatch;
        this.jettyFilterHolder = jettyFilterHolder;
        this.jettyServletHolders = jettyServletHolders;
        this.previous = previous;
        this.jettyServletRegistration = jettyServletRegistration;
        if (jettyServletRegistration != null) {
            assert (jettyServletHolders != null ^ urlPatterns != null);
            String filterName = jettyFilterHolder.getFilterName();
            EnumSet<DispatcherType> dispatches = EnumSet.noneOf(DispatcherType.class);
            if (requestDispatch) {
                dispatches.add(DispatcherType.REQUEST);
            }
            if (forwardDispatch) {
                dispatches.add(DispatcherType.FORWARD);
            }
            if (includeDispatch) {
                dispatches.add(DispatcherType.INCLUDE);
            }
            if (errorDispatch) {
                dispatches.add(DispatcherType.ERROR);
            }
            this.setFilterName(filterName);
            this.setDispatcherTypes(dispatches);
            this.setPathSpecs(urlPatterns);
            if (jettyServletHolders != null) {
                this.resetServlets();
                if (jettyServletHolders instanceof ReferenceCollection) {
                    ((ReferenceCollection)jettyServletHolders).addReferenceCollectionListener(new ReferenceCollectionListener(){

                        public void memberAdded(ReferenceCollectionEvent event) {
                            JettyFilterMapping.this.resetServlets();
                            JettyFilterMapping.this.resetJettyFilterMappings();
                        }

                        public void memberRemoved(ReferenceCollectionEvent event) {
                            JettyFilterMapping.this.resetServlets();
                            JettyFilterMapping.this.resetJettyFilterMappings();
                        }
                    });
                }
            }
            jettyServletRegistration.getServletHandler().addFilterMapping((FilterMapping)this);
        }
    }

    private void resetJettyFilterMappings() {
        ServletHandler servletHandler = this.jettyServletRegistration.getServletHandler();
        FilterMapping[] filterMappings = servletHandler.getFilterMappings();
        FilterMapping[] copy = (FilterMapping[])filterMappings.clone();
        servletHandler.setFilterMappings(copy);
    }

    private void resetServlets() {
        String[] servletNames = new String[this.jettyServletHolders.size()];
        int i = 0;
        for (ServletNameSource jettyServletHolder : this.jettyServletHolders) {
            servletNames[i++] = jettyServletHolder.getServletName();
        }
        this.setServletNames(servletNames);
    }

    public String[] getUrlPatterns() {
        return this.urlPatterns;
    }

    public boolean isRequestDispatch() {
        return this.requestDispatch;
    }

    public boolean isForwardDispatch() {
        return this.forwardDispatch;
    }

    public boolean isIncludeDispatch() {
        return this.includeDispatch;
    }

    public boolean isErrorDispatch() {
        return this.errorDispatch;
    }

    public FilterHolderWrapper getFilter() {
        return this.jettyFilterHolder;
    }

    public Collection<ServletNameSource> getServlets() {
        return this.jettyServletHolders;
    }

    public JettyFilterMapping getPrevious() {
        return this.previous;
    }

    public JettyServletRegistration getJettyServletRegistration() {
        return this.jettyServletRegistration;
    }
}

