/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7.security.auth;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.security.realm.providers.PasswordCallbackHandler;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;

public class JAASLoginService
implements LoginService {
    private final String realmName;
    private final ConfigurationFactory configurationFactory;
    private IdentityService identityService;

    public JAASLoginService(ConfigurationFactory configurationFactory, String realmName) {
        this.configurationFactory = configurationFactory;
        this.realmName = realmName;
    }

    public void logout(UserIdentity userIdentity) {
    }

    public String getName() {
        return this.realmName;
    }

    public UserIdentity login(String username, Object credentials) {
        char[] password = credentials instanceof String ? ((String)credentials).toCharArray() : (char[])credentials;
        PasswordCallbackHandler callbackHandler = new PasswordCallbackHandler(username, password);
        try {
            LoginContext loginContext = ContextManager.login((String)this.configurationFactory.getConfigurationName(), (CallbackHandler)callbackHandler, (Configuration)this.configurationFactory.getConfiguration());
            Subject establishedSubject = loginContext.getSubject();
            Principal userPrincipal = ContextManager.getCurrentPrincipal((Subject)establishedSubject);
            return this.identityService.newUserIdentity(establishedSubject, userPrincipal, null);
        }
        catch (LoginException e) {
            return null;
        }
    }

    public boolean validate(UserIdentity user) {
        return true;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }
}

