/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7.connector;

import javax.net.ssl.KeyManagerFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.jetty7.JettyContainer;
import org.apache.geronimo.jetty7.JettySecureConnector;
import org.apache.geronimo.jetty7.connector.GeronimoSocketSSLListener;
import org.apache.geronimo.jetty7.connector.JettyConnector;
import org.apache.geronimo.management.geronimo.KeystoreManager;
import org.apache.geronimo.system.threads.ThreadPool;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.bio.SocketConnector;

public class HTTPSSocketConnector
extends JettyConnector
implements JettySecureConnector {
    private final GeronimoSocketSSLListener https;
    private String algorithm;
    public static final GBeanInfo GBEAN_INFO;

    public HTTPSSocketConnector(JettyContainer container, ThreadPool threadPool, KeystoreManager keystoreManager) {
        super(container, (AbstractConnector)new GeronimoSocketSSLListener(keystoreManager), threadPool, "HTTPSSocketConnector");
        this.https = (GeronimoSocketSSLListener)this.listener;
    }

    public int getDefaultPort() {
        return 443;
    }

    public String getProtocol() {
        return "HTTPS";
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        if ("default".equalsIgnoreCase(algorithm)) {
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        this.https.setSslKeyManagerFactoryAlgorithm(algorithm);
    }

    public String getSecureProtocol() {
        return this.https.getProtocol();
    }

    public void setSecureProtocol(String protocol) {
        this.https.setProtocol(protocol);
    }

    public void setClientAuthRequired(boolean needClientAuth) {
        this.https.setNeedClientAuth(needClientAuth);
    }

    public boolean isClientAuthRequired() {
        return this.https.getNeedClientAuth();
    }

    public void setClientAuthRequested(boolean wantClientAuth) {
        this.https.setWantClientAuth(wantClientAuth);
    }

    public boolean isClientAuthRequested() {
        return this.https.getWantClientAuth();
    }

    public void setKeyStore(String keyStore) {
        this.https.setKeyStore(keyStore);
    }

    public String getKeyStore() {
        return this.https.getKeyStore();
    }

    public void setTrustStore(String trustStore) {
        this.https.setTrustStore(trustStore);
    }

    public String getTrustStore() {
        return this.https.getTrustStore();
    }

    public void setKeyAlias(String keyAlias) {
        this.https.setKeyAlias(keyAlias);
    }

    public String getKeyAlias() {
        return this.https.getKeyAlias();
    }

    public void setRedirectPort(int port) {
        SocketConnector socketListener = (SocketConnector)this.listener;
        socketListener.setConfidentialPort(port);
        socketListener.setIntegralPort(port);
        socketListener.setIntegralScheme("https");
        socketListener.setConfidentialScheme("https");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    public String getKeystoreFileName() {
        return null;
    }

    public void setKeystoreFileName(String name) {
    }

    public void setKeystorePassword(String password) {
    }

    public String getKeystoreType() {
        return null;
    }

    public void setKeystoreType(String type) {
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Jetty Connector HTTPS", HTTPSSocketConnector.class, (GBeanInfo)JettyConnector.GBEAN_INFO);
        infoFactory.addAttribute("algorithm", String.class, true, true);
        infoFactory.addAttribute("secureProtocol", String.class, true, true);
        infoFactory.addAttribute("keyStore", String.class, true, true);
        infoFactory.addAttribute("keyAlias", String.class, true, true);
        infoFactory.addAttribute("trustStore", String.class, true, true);
        infoFactory.addAttribute("clientAuthRequired", Boolean.TYPE, true, true);
        infoFactory.addAttribute("clientAuthRequested", Boolean.TYPE, true, true);
        infoFactory.addReference("KeystoreManager", KeystoreManager.class, "GBean");
        infoFactory.addInterface(JettySecureConnector.class);
        infoFactory.setConstructor(new String[]{"JettyContainer", "ThreadPool", "KeystoreManager"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

