/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7.connector;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import javax.management.j2ee.statistics.Stats;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jetty7.JettyContainer;
import org.apache.geronimo.jetty7.JettyWebConnector;
import org.apache.geronimo.jetty7.connector.JettyThreadPool;
import org.apache.geronimo.management.LazyStatisticsProvider;
import org.apache.geronimo.management.geronimo.stats.JettyWebConnectorStatsImpl;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.thread.ThreadPool;

public abstract class JettyConnector
implements GBeanLifecycle,
JettyWebConnector,
LazyStatisticsProvider {
    public static final String CONNECTOR_CONTAINER_REFERENCE = "JettyContainer";
    private final JettyContainer container;
    protected final AbstractConnector listener;
    private JettyWebConnectorStatsImpl stats;
    private String connectHost;
    public static final GBeanInfo GBEAN_INFO;

    public JettyConnector() {
        this.container = null;
        this.listener = null;
    }

    public JettyConnector(JettyContainer container, org.apache.geronimo.system.threads.ThreadPool threadPool) {
        this.container = container;
        this.listener = null;
    }

    public JettyConnector(JettyContainer container, AbstractConnector listener, org.apache.geronimo.system.threads.ThreadPool threadPool, String name) {
        this.container = container;
        this.listener = listener;
        if (threadPool != null) {
            JettyThreadPool jettyThreadPool = new JettyThreadPool(threadPool, name);
            listener.setThreadPool((ThreadPool)jettyThreadPool);
        }
        this.stats = new JettyWebConnectorStatsImpl();
    }

    public String getHost() {
        return this.listener.getHost();
    }

    public void setHost(String host) throws UnknownHostException {
        this.listener.setHost(host);
    }

    public int getPort() {
        return this.listener.getPort();
    }

    public void setPort(int port) {
        this.listener.setPort(port);
    }

    public int getHeaderBufferSizeBytes() {
        return this.listener.getHeaderBufferSize();
    }

    public void setHeaderBufferSizeBytes(int size) {
        this.listener.setHeaderBufferSize(size);
    }

    public abstract int getDefaultPort();

    public String getDefaultScheme() {
        return null;
    }

    public String getConnectUrl() {
        if (this.connectHost == null) {
            String host = this.getHost();
            if (host == null || host.equals("0.0.0.0")) {
                InetAddress address = null;
                try {
                    address = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    host = "unknown-host";
                }
                if (address != null && ((host = address.getHostName()) == null || host.equals(""))) {
                    host = address.getHostAddress();
                }
            }
            this.connectHost = host;
        }
        return this.getProtocol().toLowerCase() + "://" + this.connectHost + (this.getPort() == this.getDefaultPort() ? "" : ":" + this.getPort());
    }

    public int getMaxIdleTimeMs() {
        return this.listener.getMaxIdleTime();
    }

    public void setMaxIdleTimeMs(int idleTime) {
        this.listener.setMaxIdleTime(idleTime);
    }

    public int getBufferSizeBytes() {
        return this.listener.getRequestBufferSize();
    }

    public void setBufferSizeBytes(int bytes) {
        this.listener.setRequestBufferSize(bytes);
    }

    public int getAcceptQueueSize() {
        return this.listener.getAcceptQueueSize();
    }

    public void setAcceptQueueSize(int size) {
        this.listener.setAcceptQueueSize(size);
    }

    public int getLingerMillis() {
        return this.listener.getSoLingerTime();
    }

    public void setLingerMillis(int millis) {
        this.listener.setSoLingerTime(millis);
    }

    public boolean isTcpNoDelay() {
        return true;
    }

    public void setTcpNoDelay(boolean enable) {
        throw new UnsupportedOperationException(this.listener == null ? "No Listener" : this.listener.getClass().getName());
    }

    public void setMaxThreads(int maxThreads) {
        this.listener.setAcceptors(maxThreads);
    }

    public int getMaxThreads() {
        return this.listener.getAcceptors();
    }

    public int getRedirectPort() {
        return this.listener.getConfidentialPort();
    }

    public InetSocketAddress getListenAddress() {
        try {
            return new InetSocketAddress(InetAddress.getByName(this.listener.getHost()), this.listener.getPort());
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("InetSocketAddress cannot be determined for host=" + this.listener.getHost(), e);
        }
    }

    public void setRedirectPort(int port) {
        throw new UnsupportedOperationException("No redirect port on " + this.getClass().getName());
    }

    public abstract String getProtocol();

    public void doStart() throws Exception {
        this.container.addListener((Connector)this.listener);
        this.listener.start();
    }

    public void doStop() {
        while (true) {
            try {
                this.listener.stop();
                this.container.removeListener((Connector)this.listener);
                return;
            }
            catch (Exception e) {
                continue;
            }
            break;
        }
    }

    public void doFail() {
        while (true) {
            try {
                this.listener.stop();
                this.container.removeListener((Connector)this.listener);
                return;
            }
            catch (Exception e) {
                continue;
            }
            break;
        }
    }

    public boolean isStatsOn() {
        return this.listener.getStatsOn();
    }

    public void setStatsOn(boolean on) {
        this.listener.setStatsOn(on);
        if (on) {
            this.stats.setStartTime();
        }
    }

    public Stats getStats() {
        if (this.isStatsOn()) {
            this.stats.setLastSampleTime();
            this.stats.getOpenConnectionCountImpl().setCurrent((long)this.listener.getConnectionsOpen());
            this.stats.getOpenConnectionCountImpl().setHighWaterMark((long)this.listener.getConnectionsOpenMax());
            this.stats.getOpenConnectionCountImpl().setLowWaterMark(0L);
            this.stats.getRequestCountImpl().setCount((long)this.listener.getRequests());
            this.stats.getConnectionsDurationImpl().setCount((long)this.listener.getConnections());
            this.stats.getConnectionsDurationImpl().setMaxTime(this.listener.getConnectionsDurationMax());
            this.stats.getConnectionsDurationImpl().setMinTime(0L);
            this.stats.getConnectionsDurationImpl().setTotalTime(this.listener.getConnectionsDurationTotal());
            this.stats.getConnectionsRequestImpl().setCurrent(Double.doubleToLongBits(this.listener.getConnectionsRequestsMean()));
            this.stats.getConnectionsRequestImpl().setHighWaterMark((long)this.listener.getConnectionsRequestsMax());
            this.stats.getConnectionsRequestImpl().setLowWaterMark(0L);
        }
        return this.stats;
    }

    public void resetStats() {
        this.listener.statsReset();
        this.stats.setStartTime();
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return true;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Jetty HTTP Connector", JettyConnector.class);
        infoFactory.addReference(CONNECTOR_CONTAINER_REFERENCE, JettyContainer.class, "GBean");
        infoFactory.addReference("ThreadPool", org.apache.geronimo.system.threads.ThreadPool.class, "GBean");
        infoFactory.addOperation("setStatsOn", new Class[]{Boolean.TYPE}, "void");
        infoFactory.addInterface(JettyWebConnector.class, new String[]{"host", "port", "minThreads", "maxThreads", "bufferSizeBytes", "headerBufferSizeBytes", "acceptQueueSize", "lingerMillis", "redirectPort", "maxIdleTimeMs"}, new String[]{"host", "port", "minThreads", "maxThreads", "bufferSizeBytes", "headerBufferSizeBytes", "acceptQueueSize", "lingerMillis", "protocol", "redirectPort"});
        infoFactory.setConstructor(new String[]{CONNECTOR_CONTAINER_REFERENCE, "ThreadPool"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

