/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7;

import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.jetty7.GeronimoServletHolder;
import org.apache.geronimo.jetty7.JettyServletRegistration;
import org.apache.geronimo.jetty7.ServletNameSource;
import org.apache.geronimo.webservices.POJOWebServiceServlet;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.WebServiceContainerFactory;
import org.apache.geronimo.webservices.WebServiceContainerInvoker;
import org.eclipse.jetty.servlet.ServletHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GBean(j2eeType="ServletWebServiceTemplate")
public class POJOWebServiceHolderWrapper
implements ServletNameSource,
GBeanLifecycle {
    private final ServletHolder servletHolder;
    private final WebServiceContainer webServiceContainer;
    private final Set<String> servletMappings;
    private final JettyServletRegistration context;
    private final String pojoClassName;

    public POJOWebServiceHolderWrapper(@ParamAttribute(name="pojoClassName") String pojoClassName, @ParamAttribute(name="servletName") String servletName, @ParamAttribute(name="initParams") Map<String, String> initParams, @ParamAttribute(name="loadOnStartup") Integer loadOnStartup, @ParamAttribute(name="servletMappings") Set<String> servletMappings, @ParamAttribute(name="runAsRole") String runAsRole, @ParamReference(name="WebServiceContainerFactory") WebServiceContainerFactory webServiceContainerFactory, @ParamReference(name="JettyServletRegistration", namingType="WebModule") JettyServletRegistration context) throws Exception {
        this.servletHolder = new GeronimoServletHolder(context == null ? null : context.getIntegrationContext(), context);
        this.pojoClassName = pojoClassName;
        this.context = context;
        this.webServiceContainer = webServiceContainerFactory == null ? null : webServiceContainerFactory.getWebServiceContainer();
        this.servletMappings = servletMappings;
        if (context != null) {
            this.servletHolder.setName(servletName);
            this.servletHolder.setClassName(POJOWebServiceServlet.class.getName());
            this.servletHolder.setRunAsRole(runAsRole);
            this.servletHolder.setInitParameters(initParams);
            if (loadOnStartup != null) {
                this.servletHolder.setInitOrder(loadOnStartup.intValue());
            }
        }
    }

    @Override
    public String getServletName() {
        return this.servletHolder.getName();
    }

    public void doStart() throws Exception {
        if (this.context != null) {
            Class<?> pojoClass = this.context.getWebClassLoader().loadClass(this.pojoClassName);
            ServletContext servletContext = this.context.getServletHandler().getServletContext();
            String webServicecontainerID = this.getServletName() + WebServiceContainerInvoker.WEBSERVICE_CONTAINER + this.webServiceContainer.hashCode();
            this.servletHolder.setInitParameter(WebServiceContainerInvoker.WEBSERVICE_CONTAINER, webServicecontainerID);
            servletContext.setAttribute(webServicecontainerID, (Object)this.webServiceContainer);
            String pojoClassID = this.getServletName() + POJOWebServiceServlet.POJO_CLASS + pojoClass.hashCode();
            this.servletHolder.setInitParameter(POJOWebServiceServlet.POJO_CLASS, pojoClassID);
            servletContext.setAttribute(pojoClassID, pojoClass);
            this.context.registerServletHolder(this.servletHolder, this.getServletName(), this.servletMappings, null);
            this.servletHolder.start();
        }
    }

    public void doStop() throws Exception {
        this.servletHolder.stop();
    }

    public void doFail() {
        try {
            this.servletHolder.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

