/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6.handler;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.jetty6.JAASJettyPrincipal;
import org.apache.geronimo.jetty6.JAASJettyRealm;
import org.apache.geronimo.jetty6.JettyContainer;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jacc.PolicyContextHandlerHttpServletRequest;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.FormAuthenticator;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;

public class JettySecurityHandler
extends SecurityHandler {
    private String policyContextID;
    private JAASJettyPrincipal defaultPrincipal;
    private String formLoginPath;
    private JAASJettyRealm realm;

    public JettySecurityHandler(Authenticator authenticator, JAASJettyRealm userRealm, String policyContextID, Subject defaultSubject) {
        this.setAuthenticator(authenticator);
        this.policyContextID = policyContextID;
        if (authenticator instanceof FormAuthenticator) {
            String formLoginPath = ((FormAuthenticator)authenticator).getLoginPage();
            if (formLoginPath.indexOf(63) > 0) {
                formLoginPath = formLoginPath.substring(0, formLoginPath.indexOf(63));
            }
            this.formLoginPath = formLoginPath;
        } else {
            this.formLoginPath = null;
        }
        if (defaultSubject == null) {
            defaultSubject = ContextManager.EMPTY;
        }
        this.defaultPrincipal = this.generateDefaultPrincipal(defaultSubject);
        this.setUserRealm(userRealm);
        this.realm = userRealm;
        assert (this.realm != null);
    }

    public boolean hasConstraints() {
        return true;
    }

    public void doStop(JettyContainer jettyContainer) throws Exception {
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        String old_policy_id = PolicyContext.getContextID();
        Callers oldCallers = ContextManager.getCallers();
        PolicyContext.setContextID((String)this.policyContextID);
        HttpServletRequest oldRequest = PolicyContextHandlerHttpServletRequest.pushContextData((HttpServletRequest)request);
        try {
            super.handle(target, request, response, dispatch);
        }
        finally {
            PolicyContext.setContextID((String)old_policy_id);
            ContextManager.popCallers((Callers)oldCallers);
            PolicyContextHandlerHttpServletRequest.popContextData((HttpServletRequest)oldRequest);
        }
    }

    public boolean checkSecurityConstraints(String pathInContext, Request request, Response response) throws IOException {
        block16: {
            if (this.formLoginPath != null) {
                String pathToBeTested;
                String string = pathToBeTested = pathInContext.indexOf(63) > 0 ? pathInContext.substring(0, pathInContext.indexOf(63)) : pathInContext;
                if (pathToBeTested.equals(this.formLoginPath)) {
                    return true;
                }
            }
            try {
                boolean notIntegral = request.isSecure() || !request.getConnection().isIntegral(request);
                Authenticator authenticator = this.getAuthenticator();
                boolean isAuthenticated = false;
                if (authenticator instanceof FormAuthenticator && pathInContext.endsWith("/j_security_check")) {
                    authenticator.authenticate((UserRealm)this.realm, pathInContext, request, response);
                    return false;
                }
                if (request != null) {
                    Principal user = authenticator.authenticate((UserRealm)this.realm, pathInContext, request, null);
                    if (user == null || user == SecurityHandler.__NOBODY) {
                        ContextManager.setCallers((Subject)this.defaultPrincipal.getSubject(), (Subject)this.defaultPrincipal.getSubject());
                        request.setUserPrincipal((Principal)new SecurityHandler.NotChecked((SecurityHandler)this));
                    } else if (user != null) {
                        isAuthenticated = true;
                    }
                }
                AccessControlContext acc = ContextManager.getCurrentContext();
                WebUserDataPermission wudp = notIntegral ? new WebUserDataPermission((HttpServletRequest)request) : new WebUserDataPermission(JettySecurityHandler.encodeColons((HttpServletRequest)request), new String[]{request.getMethod()}, "INTEGRAL");
                acc.checkPermission((Permission)wudp);
                WebResourcePermission webResourcePermission = new WebResourcePermission((HttpServletRequest)request);
                if (isAuthenticated) {
                    acc.checkPermission((Permission)webResourcePermission);
                    break block16;
                }
                try {
                    acc.checkPermission((Permission)webResourcePermission);
                }
                catch (AccessControlException e) {
                    Principal user = authenticator.authenticate((UserRealm)this.realm, pathInContext, request, response);
                    if (user == SecurityHandler.__NOBODY) {
                        return true;
                    }
                    if (user == null) {
                        throw e;
                    }
                }
            }
            catch (HttpException he) {
                response.sendError(he.getStatus(), he.getReason());
                return false;
            }
            catch (AccessControlException ace) {
                if (!response.isCommitted()) {
                    response.sendError(403);
                }
                return false;
            }
        }
        return true;
    }

    private static String encodeColons(HttpServletRequest request) {
        String result = request.getServletPath() + (request.getPathInfo() == null ? "" : request.getPathInfo());
        if (result.indexOf(":") > -1) {
            result = result.replaceAll(":", "%3A");
        }
        return result;
    }

    protected JAASJettyPrincipal generateDefaultPrincipal(Subject defaultSubject) throws GeronimoSecurityException {
        if (defaultSubject == null) {
            throw new GeronimoSecurityException("Unable to generate default principal");
        }
        JAASJettyPrincipal result = new JAASJettyPrincipal("default");
        result.setSubject(defaultSubject);
        return result;
    }
}

