/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6.cluster.wadi.builder;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.geronimo.clustering.wadi.BasicWADISessionManager;
import org.apache.geronimo.clustering.wadi.WADISessionManagerConfigInfo;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.jetty6.JettyWebAppContext;
import org.apache.geronimo.jetty6.cluster.ClusteredSessionHandlerFactory;
import org.apache.geronimo.jetty6.cluster.wadi.WADIClusteredPreHandlerFactory;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.geronimo.GerClusteringWadiDocument;
import org.apache.geronimo.xbeans.geronimo.GerClusteringWadiType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerClusteringDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GBean(name="WADIJettyClusteringBuilder", j2eeType="ModuleBuilder")
public class WADIJettyClusteringBuilder
implements NamespaceDrivenBuilder {
    private static final QName BASE_CLUSTERING_QNAME = GerClusteringDocument.type.getDocumentElementName();
    private static final QName CLUSTERING_WADI_QNAME = GerClusteringWadiDocument.type.getDocumentElementName();
    private static final QNameSet CLUSTERING_WADI_QNAME_SET = QNameSet.singleton((QName)CLUSTERING_WADI_QNAME);
    private final int defaultSweepInterval;
    private final int defaultNumPartitions;
    private final AbstractNameQuery defaultBackingStrategyFactoryName;
    private final AbstractNameQuery defaultClusterName;
    private final Environment defaultEnvironment;
    public static final String GBEAN_ATTR_DFT_SWEEP_INTERVAL = "defaultSweepInterval";
    public static final String GBEAN_ATTR_DFT_NUM_PARTITIONS = "defaultNumPartitions";
    public static final String GBEAN_ATTR_DFT_BACKING_STRATEGY_FACTORY_NAME = "defaultBackingStrategyFactoryName";
    public static final String GBEAN_ATTR_DFT_CLUSTER_NAME = "defaultClusterName";
    public static final String GBEAN_ATTR_DFT_ENVIRONMENT = "defaultEnvironment";

    public WADIJettyClusteringBuilder(@ParamAttribute(name="defaultSweepInterval") int defaultSweepInterval, @ParamAttribute(name="defaultNumPartitions") int defaultNumPartitions, @ParamAttribute(name="defaultBackingStrategyFactoryName") AbstractNameQuery defaultBackingStrategyFactoryName, @ParamAttribute(name="defaultClusterName") AbstractNameQuery defaultClusterName, @ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment) {
        if (defaultSweepInterval < 1) {
            throw new IllegalArgumentException("defaultSweepInterval is lower than 1");
        }
        if (defaultNumPartitions < 1) {
            throw new IllegalArgumentException("defaultNumPartitions is lower than 1");
        }
        if (null == defaultBackingStrategyFactoryName) {
            throw new IllegalArgumentException("defaultBackingStrategyFactoryName is required");
        }
        if (null == defaultClusterName) {
            throw new IllegalArgumentException("defaultClusterName is required");
        }
        if (null == defaultEnvironment) {
            throw new IllegalArgumentException("defaultEnvironment is required");
        }
        this.defaultSweepInterval = defaultSweepInterval;
        this.defaultNumPartitions = defaultNumPartitions;
        this.defaultBackingStrategyFactoryName = defaultBackingStrategyFactoryName;
        this.defaultClusterName = defaultClusterName;
        this.defaultEnvironment = defaultEnvironment;
    }

    public void buildEnvironment(XmlObject container, Environment environment) throws DeploymentException {
        if (this.getWadiClusterConfig(container) != null) {
            EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
        }
    }

    public void build(XmlObject container, DeploymentContext applicationContext, DeploymentContext moduleContext) throws DeploymentException {
        GerClusteringWadiType clusteringWadiType = this.getWadiClusterConfig(container);
        if (clusteringWadiType != null) {
            GBeanData webModuleData = this.extractWebModule(moduleContext);
            try {
                AbstractName sessionManagerName = this.addSessionManager(clusteringWadiType, webModuleData, moduleContext);
                this.addSessionHandlerFactory(moduleContext, webModuleData, sessionManagerName);
                this.addPreHandlerFactory(moduleContext, webModuleData, sessionManagerName);
            }
            catch (GBeanAlreadyExistsException e) {
                throw new DeploymentException("Duplicate GBean", (Throwable)e);
            }
        }
    }

    protected GBeanData extractWebModule(DeploymentContext moduleContext) throws DeploymentException {
        AbstractNameQuery webModuleQuery = this.createJettyWebAppContextNameQuery(moduleContext);
        Configuration configuration = moduleContext.getConfiguration();
        try {
            return configuration.findGBeanData(webModuleQuery);
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("Could not locate web module gbean in web app configuration", (Throwable)e);
        }
    }

    protected AbstractNameQuery createJettyWebAppContextNameQuery(DeploymentContext moduleContext) {
        String name = moduleContext.getModuleName().getNameProperty("name");
        return new AbstractNameQuery(null, Collections.singletonMap("name", name), Collections.singleton(JettyWebAppContext.class.getName()));
    }

    public QNameSet getSpecQNameSet() {
        return QNameSet.EMPTY;
    }

    public QNameSet getPlanQNameSet() {
        return CLUSTERING_WADI_QNAME_SET;
    }

    public QName getBaseQName() {
        return BASE_CLUSTERING_QNAME;
    }

    protected GerClusteringWadiType getWadiClusterConfig(XmlObject container) throws DeploymentException {
        XmlObject[] items = container.selectChildren(CLUSTERING_WADI_QNAME_SET);
        if (items.length > 1) {
            throw new DeploymentException("Unexpected count of clustering elements in geronimo plan " + items.length + " qnameset: " + CLUSTERING_WADI_QNAME_SET);
        }
        if (items.length == 1) {
            return (GerClusteringWadiType)items[0].copy().changeType(GerClusteringWadiType.type);
        }
        return null;
    }

    protected AbstractName addSessionManager(GerClusteringWadiType clustering, GBeanData webModuleData, DeploymentContext moduleContext) throws GBeanAlreadyExistsException {
        AbstractName name = moduleContext.getNaming().createChildName(moduleContext.getModuleName(), "WADISessionManager", "GBean");
        GBeanData beanData = new GBeanData(name, BasicWADISessionManager.class);
        this.setConfigInfo(clustering, webModuleData, beanData);
        this.setCluster(clustering, beanData);
        this.setBackingStrategyFactory(clustering, beanData);
        moduleContext.addGBean(beanData);
        return name;
    }

    protected void setConfigInfo(GerClusteringWadiType clustering, GBeanData webModuleData, GBeanData beanData) {
        URI serviceSpaceName;
        int sweepInterval = this.getSweepInterval(clustering);
        int numPartitions = this.getNumberOfPartitions(clustering);
        Integer sessionTimeout = this.getSessionTimeout(webModuleData);
        boolean disableReplication = this.isDisableReplication(clustering);
        boolean deltaReplication = this.isDeltaReplication(clustering);
        String contextPath = (String)webModuleData.getAttribute("contextPath");
        try {
            serviceSpaceName = new URI(contextPath);
        }
        catch (URISyntaxException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("contextPath [" + contextPath + "] cannot be parsed as an URI.")))).initCause(e));
        }
        WADISessionManagerConfigInfo configInfo = new WADISessionManagerConfigInfo(serviceSpaceName, sweepInterval, numPartitions, sessionTimeout.intValue(), disableReplication, deltaReplication);
        beanData.setAttribute("wadiConfigInfo", (Object)configInfo);
    }

    protected Integer getSessionTimeout(GBeanData webModuleData) throws AssertionError {
        Integer sessionTimeout = (Integer)webModuleData.getAttribute("sessionTimeoutSeconds");
        if (null == sessionTimeout) {
            throw new AssertionError();
        }
        return sessionTimeout;
    }

    protected boolean isDeltaReplication(GerClusteringWadiType clustering) {
        if (clustering.isSetDeltaReplication()) {
            return clustering.getDeltaReplication();
        }
        return false;
    }

    protected boolean isDisableReplication(GerClusteringWadiType clustering) {
        if (clustering.isSetDisableReplication()) {
            return clustering.getDisableReplication();
        }
        return false;
    }

    protected int getNumberOfPartitions(GerClusteringWadiType clustering) {
        if (clustering.isSetNumPartitions()) {
            return clustering.getNumPartitions().intValue();
        }
        return this.defaultNumPartitions;
    }

    protected int getSweepInterval(GerClusteringWadiType clustering) {
        if (clustering.isSetSweepInterval()) {
            return clustering.getSweepInterval().intValue();
        }
        return this.defaultSweepInterval;
    }

    protected void setCluster(GerClusteringWadiType clustering, GBeanData beanData) {
        HashSet<AbstractNameQuery> patterns = new HashSet<AbstractNameQuery>();
        if (clustering.isSetCluster()) {
            this.addAbstractNameQueries(patterns, clustering.getCluster().getPatternArray());
        } else {
            patterns.add(this.defaultClusterName);
        }
        beanData.setReferencePatterns("Cluster", patterns);
    }

    protected void setBackingStrategyFactory(GerClusteringWadiType clustering, GBeanData beanData) {
        HashSet<AbstractNameQuery> patterns = new HashSet<AbstractNameQuery>();
        if (clustering.isSetBackingStrategyFactory()) {
            this.addAbstractNameQueries(patterns, clustering.getBackingStrategyFactory().getPatternArray());
        } else {
            patterns.add(this.defaultBackingStrategyFactoryName);
        }
        beanData.setReferencePatterns("BackingStrategyFactory", patterns);
    }

    protected AbstractName addPreHandlerFactory(DeploymentContext moduleContext, GBeanData webModuleData, AbstractName sessionManagerName) throws GBeanAlreadyExistsException {
        AbstractName name = moduleContext.getNaming().createChildName(moduleContext.getModuleName(), "WADIClusteredPreHandlerFactory", "GBean");
        GBeanData beanData = new GBeanData(name, WADIClusteredPreHandlerFactory.class);
        beanData.setReferencePattern("WADISessionManager", sessionManagerName);
        webModuleData.setReferencePattern("PreHandlerFactory", name);
        moduleContext.addGBean(beanData);
        return name;
    }

    protected AbstractName addSessionHandlerFactory(DeploymentContext moduleContext, GBeanData webModuleData, AbstractName sessionManagerName) throws GBeanAlreadyExistsException {
        AbstractName name = moduleContext.getNaming().createChildName(moduleContext.getModuleName(), "ClusteredSessionHandlerFactory", "GBean");
        GBeanData beanData = new GBeanData(name, ClusteredSessionHandlerFactory.class);
        beanData.setReferencePattern("SessionManager", sessionManagerName);
        webModuleData.setReferencePattern("SessionHandlerFactory", name);
        moduleContext.addGBean(beanData);
        return name;
    }

    protected void addAbstractNameQueries(Set<AbstractNameQuery> patterns, GerPatternType[] patternTypes) {
        for (GerPatternType patternType : patternTypes) {
            AbstractNameQuery query = ENCConfigBuilder.buildAbstractNameQuery((GerPatternType)patternType, null, null, null);
            patterns.add(query);
        }
    }

    static {
        SchemaConversionUtils.registerNamespaceConversions(Collections.singletonMap(CLUSTERING_WADI_QNAME.getLocalPart(), new NamespaceElementConverter(CLUSTERING_WADI_QNAME.getNamespaceURI())));
    }
}

