/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty.interceptor;

import java.util.Set;
import javax.resource.ResourceException;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.SharedConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.jetty.interceptor.BeforeAfter;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;

public class InstanceContextBeforeAfter
implements BeforeAfter {
    private final BeforeAfter next;
    private final int oldIndex;
    private final int newIndex;
    private final Set unshareableResources;
    private final Set applicationManagedSecurityResources;
    private final TrackedConnectionAssociator trackedConnectionAssociator;

    public InstanceContextBeforeAfter(BeforeAfter next, int oldIndex, int newIndex, Set unshareableResources, Set applicationManagedSecurityResources, TrackedConnectionAssociator trackedConnectionAssociator) {
        this.next = next;
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
        this.unshareableResources = unshareableResources;
        this.applicationManagedSecurityResources = applicationManagedSecurityResources;
        this.trackedConnectionAssociator = trackedConnectionAssociator;
    }

    public void before(Object[] context, HttpRequest httpRequest, HttpResponse httpResponse) {
        try {
            SharedConnectorInstanceContext newConnectorInstanceContext = new SharedConnectorInstanceContext(this.unshareableResources, this.applicationManagedSecurityResources, false);
            SharedConnectorInstanceContext oldContext = (SharedConnectorInstanceContext)this.trackedConnectionAssociator.enter((ConnectorInstanceContext)newConnectorInstanceContext);
            if (oldContext != null) {
                newConnectorInstanceContext.share(oldContext);
            }
            context[this.oldIndex] = oldContext;
            context[this.newIndex] = newConnectorInstanceContext;
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
        if (this.next != null) {
            this.next.before(context, httpRequest, httpResponse);
        }
    }

    public void after(Object[] context, HttpRequest httpRequest, HttpResponse httpResponse) {
        if (this.next != null) {
            this.next.after(context, httpRequest, httpResponse);
        }
        try {
            SharedConnectorInstanceContext oldConnectorInstanceContext = (SharedConnectorInstanceContext)context[this.oldIndex];
            SharedConnectorInstanceContext newConnectorInstanceContext = (SharedConnectorInstanceContext)context[this.newIndex];
            if (oldConnectorInstanceContext != null) {
                newConnectorInstanceContext.hide();
            }
            this.trackedConnectionAssociator.exit((ConnectorInstanceContext)oldConnectorInstanceContext);
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
    }
}

