/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty.connector;

import javax.net.ssl.KeyManagerFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.jetty.JettyContainer;
import org.apache.geronimo.jetty.JettySecureConnector;
import org.apache.geronimo.jetty.connector.GeronimoSSLListener;
import org.apache.geronimo.jetty.connector.JettyConnector;
import org.apache.geronimo.management.geronimo.KeystoreManager;
import org.mortbay.http.HttpListener;

public class HTTPSConnector
extends JettyConnector
implements JettySecureConnector {
    private final GeronimoSSLListener https;
    private String algorithm;
    public static final GBeanInfo GBEAN_INFO;

    public HTTPSConnector(JettyContainer container, KeystoreManager keystoreManager) {
        super(container, (HttpListener)new GeronimoSSLListener(keystoreManager));
        this.https = (GeronimoSSLListener)this.listener;
    }

    public int getDefaultPort() {
        return 443;
    }

    public String getProtocol() {
        return "HTTPS";
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        if ("default".equalsIgnoreCase(algorithm)) {
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        this.https.setAlgorithm(algorithm);
    }

    public String getSecureProtocol() {
        return this.https.getProtocol();
    }

    public void setSecureProtocol(String protocol) {
        this.https.setProtocol(protocol);
    }

    public void setClientAuthRequired(boolean needClientAuth) {
        this.https.setNeedClientAuth(needClientAuth);
    }

    public boolean isClientAuthRequired() {
        return this.https.getNeedClientAuth();
    }

    public void setClientAuthRequested(boolean wantClientAuth) {
        this.https.setWantClientAuth(wantClientAuth);
    }

    public boolean isClientAuthRequested() {
        return this.https.getWantClientAuth();
    }

    public void setKeyStore(String keyStore) {
        this.https.setKeyStore(keyStore);
    }

    public String getKeyStore() {
        return this.https.getKeyStore();
    }

    public void setTrustStore(String trustStore) {
        this.https.setTrustStore(trustStore);
    }

    public String getTrustStore() {
        return this.https.getTrustStore();
    }

    public void setKeyAlias(String keyAlias) {
        this.https.setKeyAlias(keyAlias);
    }

    public String getKeyAlias() {
        return this.https.getKeyAlias();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    public String getKeystoreFileName() {
        return null;
    }

    public void setKeystoreFileName(String name) {
    }

    public void setKeystorePassword(String password) {
    }

    public String getKeystoreType() {
        return null;
    }

    public void setKeystoreType(String type) {
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Jetty Connector HTTPS", (Class)HTTPSConnector.class, (GBeanInfo)JettyConnector.GBEAN_INFO);
        infoFactory.addAttribute("algorithm", String.class, true, true);
        infoFactory.addAttribute("secureProtocol", String.class, true, true);
        infoFactory.addAttribute("keyStore", String.class, true, true);
        infoFactory.addAttribute("keyAlias", String.class, true, true);
        infoFactory.addAttribute("trustStore", String.class, true, true);
        infoFactory.addAttribute("clientAuthRequired", Boolean.TYPE, true, true);
        infoFactory.addAttribute("clientAuthRequested", Boolean.TYPE, true, true);
        infoFactory.addReference("KeystoreManager", KeystoreManager.class, "GBean");
        infoFactory.addInterface(JettySecureConnector.class);
        infoFactory.setConstructor(new String[]{"JettyContainer", "KeystoreManager"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

