/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.jetty.JettyContainer;
import org.apache.geronimo.jetty.JettyWebConnector;
import org.apache.geronimo.jetty.connector.AJP13Connector;
import org.apache.geronimo.jetty.connector.HTTPConnector;
import org.apache.geronimo.jetty.connector.HTTPSConnector;
import org.apache.geronimo.jetty.requestlog.JettyLogManager;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.EditableConfigurationManager;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.proxy.ProxyManager;
import org.apache.geronimo.management.geronimo.KeystoreManager;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.geronimo.management.geronimo.WebAccessLog;
import org.apache.geronimo.management.geronimo.WebConnector;
import org.apache.geronimo.management.geronimo.WebContainer;
import org.apache.geronimo.management.geronimo.WebManager;

public class JettyManagerImpl
implements WebManager {
    private static final Log log = LogFactory.getLog((Class)JettyManagerImpl.class);
    private final Kernel kernel;
    public static final GBeanInfo GBEAN_INFO;

    public JettyManagerImpl(Kernel kernel) {
        this.kernel = kernel;
    }

    public String getProductName() {
        return "Jetty";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebConnector addConnector(WebContainer container, String uniqueName, String protocol, String host, int port) {
        GBeanData connector;
        AbstractName containerName = this.kernel.getAbstractNameFor((Object)container);
        AbstractName name = this.kernel.getNaming().createSiblingName(containerName, uniqueName, "GBean");
        if (protocol.equals("HTTP")) {
            connector = new GBeanData(name, HTTPConnector.GBEAN_INFO);
        } else if (protocol.equals("HTTPS")) {
            connector = new GBeanData(name, HTTPSConnector.GBEAN_INFO);
            AbstractNameQuery query = new AbstractNameQuery(KeystoreManager.class.getName());
            connector.setReferencePattern("KeystoreManager", query);
        } else if (protocol.equals("AJP")) {
            connector = new GBeanData(name, AJP13Connector.GBEAN_INFO);
        } else {
            throw new IllegalArgumentException("Invalid protocol '" + protocol + "'");
        }
        connector.setAttribute("host", (Object)host);
        connector.setAttribute("port", (Object)new Integer(port));
        connector.setAttribute("minThreads", (Object)new Integer(10));
        connector.setAttribute("maxThreads", (Object)new Integer(50));
        connector.setReferencePattern("JettyContainer", containerName);
        EditableConfigurationManager mgr = ConfigurationUtil.getEditableConfigurationManager((Kernel)this.kernel);
        if (mgr != null) {
            try {
                mgr.addGBeanToConfiguration(containerName.getArtifact(), connector, false);
                WebConnector webConnector = (WebConnector)this.kernel.getProxyManager().createProxy(name, JettyWebConnector.class.getClassLoader());
                return webConnector;
            }
            catch (InvalidConfigException e) {
                log.error((Object)"Unable to add GBean", (Throwable)e);
                WebConnector webConnector = null;
                return webConnector;
            }
            finally {
                ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)mgr);
            }
        }
        log.warn((Object)"The ConfigurationManager in the kernel does not allow editing");
        return null;
    }

    public Object[] getContainers() {
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(JettyContainer.class.getName());
        Set names = this.kernel.listGBeans(query);
        Object[] results = new JettyContainer[names.size()];
        int i = 0;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            results[i] = (JettyContainer)proxyManager.createProxy(name, (class$org$apache$geronimo$jetty$JettyContainer == null ? JettyManagerImpl.class$("org.apache.geronimo.jetty.JettyContainer") : class$org$apache$geronimo$jetty$JettyContainer).getClassLoader());
            ++i;
        }
        return results;
    }

    public String[] getSupportedProtocols() {
        return new String[]{"HTTP", "HTTPS", "AJP"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnector(AbstractName connectorName) {
        block11: {
            try {
                GBeanInfo info = this.kernel.getGBeanInfo(connectorName);
                boolean found = false;
                Set intfs = info.getInterfaces();
                Iterator it = intfs.iterator();
                while (it.hasNext()) {
                    String intf = (String)it.next();
                    if (!intf.equals((class$org$apache$geronimo$jetty$JettyWebConnector == null ? JettyManagerImpl.class$("org.apache.geronimo.jetty.JettyWebConnector") : class$org$apache$geronimo$jetty$JettyWebConnector).getName())) continue;
                    found = true;
                }
                if (!found) {
                    throw new GBeanNotFoundException(connectorName);
                }
                EditableConfigurationManager mgr = ConfigurationUtil.getEditableConfigurationManager((Kernel)this.kernel);
                if (mgr != null) {
                    try {
                        mgr.removeGBeanFromConfiguration(connectorName.getArtifact(), connectorName);
                        break block11;
                    }
                    catch (InvalidConfigException e) {
                        log.error((Object)"Unable to add GBean", (Throwable)e);
                        break block11;
                    }
                    finally {
                        ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)mgr);
                    }
                }
                log.warn((Object)"The ConfigurationManager in the kernel does not allow editing");
            }
            catch (GBeanNotFoundException e) {
                log.warn((Object)("No such GBean '" + connectorName + "'"));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public NetworkConnector[] getConnectors(String protocol) {
        if (protocol == null) {
            return this.getConnectors();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(JettyWebConnector.class.getName());
        Set names = this.kernel.listGBeans(query);
        Iterator it = names.iterator();
        while (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            try {
                if (!this.kernel.getAttribute(name, "protocol").equals(protocol)) continue;
                result.add(proxyManager.createProxy(name, (class$org$apache$geronimo$jetty$JettyWebConnector == null ? JettyManagerImpl.class$("org.apache.geronimo.jetty.JettyWebConnector") : class$org$apache$geronimo$jetty$JettyWebConnector).getClassLoader()));
            }
            catch (Exception e) {
                log.error((Object)"Unable to check the protocol for a connector", (Throwable)e);
            }
        }
        return result.toArray(new JettyWebConnector[names.size()]);
    }

    public WebAccessLog getAccessLog(WebContainer container) {
        AbstractNameQuery query = new AbstractNameQuery(JettyLogManager.class.getName());
        Set names = this.kernel.listGBeans(query);
        if (names.size() == 0) {
            return null;
        }
        if (names.size() > 1) {
            throw new IllegalStateException("Should not be more than one Jetty access log manager");
        }
        return (WebAccessLog)this.kernel.getProxyManager().createProxy((AbstractName)names.iterator().next(), JettyLogManager.class.getClassLoader());
    }

    public NetworkConnector[] getConnectors() {
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(JettyWebConnector.class.getName());
        Set names = this.kernel.listGBeans(query);
        JettyWebConnector[] results = new JettyWebConnector[names.size()];
        int i = 0;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            results[i] = (JettyWebConnector)proxyManager.createProxy(name, (class$org$apache$geronimo$jetty$JettyWebConnector == null ? JettyManagerImpl.class$("org.apache.geronimo.jetty.JettyWebConnector") : class$org$apache$geronimo$jetty$JettyWebConnector).getClassLoader());
            ++i;
        }
        return results;
    }

    public NetworkConnector[] getConnectorsForContainer(Object container, String protocol) {
        if (protocol == null) {
            return this.getConnectorsForContainer(container);
        }
        AbstractName containerName = this.kernel.getAbstractNameFor(container);
        ProxyManager mgr = this.kernel.getProxyManager();
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            AbstractNameQuery query = new AbstractNameQuery(JettyWebConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            Iterator it = set.iterator();
            while (it.hasNext()) {
                AbstractName name = (AbstractName)it.next();
                GBeanData data = this.kernel.getGBeanData(name);
                ReferencePatterns refs = data.getReferencePatterns("JettyContainer");
                if (!containerName.equals((Object)refs.getAbstractName())) continue;
                try {
                    String testProtocol = (String)this.kernel.getAttribute(name, "protocol");
                    if (testProtocol == null || !testProtocol.equals(protocol)) break;
                    results.add(mgr.createProxy(name, JettyWebConnector.class.getClassLoader()));
                }
                catch (Exception e) {
                    log.error((Object)("Unable to look up protocol for connector '" + name + "'"), (Throwable)e);
                }
                break;
            }
            return results.toArray(new JettyWebConnector[results.size()]);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unable to look up connectors for Jetty container '" + containerName + "': ").initCause(e);
        }
    }

    public NetworkConnector[] getConnectorsForContainer(Object container) {
        AbstractName containerName = this.kernel.getAbstractNameFor(container);
        ProxyManager mgr = this.kernel.getProxyManager();
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            AbstractNameQuery query = new AbstractNameQuery(JettyWebConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            Iterator it = set.iterator();
            while (it.hasNext()) {
                AbstractName name = (AbstractName)it.next();
                GBeanData data = this.kernel.getGBeanData(name);
                ReferencePatterns refs = data.getReferencePatterns("JettyContainer");
                if (!containerName.equals((Object)refs.getAbstractName())) continue;
                results.add(mgr.createProxy(name, (class$org$apache$geronimo$jetty$JettyWebConnector == null ? JettyManagerImpl.class$("org.apache.geronimo.jetty.JettyWebConnector") : class$org$apache$geronimo$jetty$JettyWebConnector).getClassLoader()));
            }
            return results.toArray(new JettyWebConnector[results.size()]);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unable to look up connectors for Jetty container '" + containerName + "'").initCause(e);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Jetty Web Manager", (Class)JettyManagerImpl.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addInterface(WebManager.class);
        infoFactory.setConstructor(new String[]{"kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

