/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import javax.servlet.http.Cookie;
import org.mortbay.http.HttpRequest;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.jetty.servlet.SessionManager;

public class GeronimoServletHttpRequest
extends ServletHttpRequest {
    private final ServletHandler servletHandler;
    private final HttpRequest request;
    private String requestedSessionId;

    public GeronimoServletHttpRequest(ServletHandler servletHandler, String pathInContext, HttpRequest request) {
        super(servletHandler, pathInContext, request);
        this.servletHandler = servletHandler;
        this.request = request;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public void setRequestedSessionId(String pathParams) {
        Cookie[] cookies;
        this.requestedSessionId = null;
        if (this.servletHandler.isUsingCookies() && (cookies = this.request.getCookies()) != null && cookies.length > 0) {
            for (int i = 0; i < cookies.length; ++i) {
                SessionManager manager;
                if (!SessionManager.__SessionCookie.equalsIgnoreCase(cookies[i].getName())) continue;
                if (null != this.requestedSessionId && (manager = this.servletHandler.getSessionManager()) != null && manager.getHttpSession(this.requestedSessionId) != null) break;
                this.requestedSessionId = cookies[i].getValue();
            }
        }
        if (null != pathParams && pathParams.startsWith(SessionManager.__SessionURL)) {
            String id = pathParams.substring(SessionManager.__SessionURL.length() + 1);
            if (null == this.requestedSessionId) {
                this.requestedSessionId = id;
            }
        }
    }
}

