/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.wsdl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class SimpleURIResolver {
    private URI uri;
    private URL url;
    private InputStream is;

    public SimpleURIResolver() {
    }

    public SimpleURIResolver(String path) throws IOException {
        this("", path);
    }

    public SimpleURIResolver(String baseUriStr, String uriStr) throws IOException {
        if (baseUriStr != null && baseUriStr.startsWith("jar:")) {
            this.tryJar(baseUriStr, uriStr);
        } else if (uriStr.startsWith("jar:")) {
            this.tryJar(uriStr);
        } else {
            this.tryFileSystem(baseUriStr, uriStr);
        }
    }

    public void resolve(String baseUriStr, String uriStr) throws IOException {
        this.uri = null;
        this.url = null;
        this.is = null;
        if (baseUriStr != null && baseUriStr.startsWith("jar:")) {
            this.tryJar(baseUriStr, uriStr);
        } else if (uriStr.startsWith("jar:")) {
            this.tryJar(uriStr);
        } else {
            this.tryFileSystem(baseUriStr, uriStr);
        }
    }

    private void tryFileSystem(String baseUriStr, String uriStr) throws IOException {
        try {
            File uriFile = new File(uriStr);
            uriFile = new File(uriFile.getAbsolutePath());
            URI relative = uriFile.exists() ? uriFile.toURI() : new URI(uriStr.replaceAll(" ", "%20"));
            if (relative.isAbsolute()) {
                this.uri = relative;
                this.url = relative.toURL();
                this.is = this.url.openStream();
            } else if (baseUriStr != null) {
                File baseFile = new File(baseUriStr);
                if (!baseFile.exists() && baseUriStr.startsWith("file:/")) {
                    baseFile = new File(baseUriStr.substring(6));
                }
                URI base = baseFile.exists() ? baseFile.toURI() : new URI(baseUriStr);
                if ((base = base.resolve(relative)).isAbsolute()) {
                    this.uri = base;
                    this.url = base.toURL();
                    this.is = this.url.openStream();
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private void tryJar(String baseStr, String uriStr) throws IOException {
        int i = baseStr.indexOf(33);
        if (i == -1) {
            this.tryFileSystem(baseStr, uriStr);
        }
        String jarBase = baseStr.substring(0, i + 1);
        String jarEntry = baseStr.substring(i + 1);
        try {
            URI u = new URI(jarEntry).resolve(uriStr);
            this.tryJar(jarBase + u.toString());
            if (this.is != null) {
                if (u.isAbsolute()) {
                    this.url = u.toURL();
                }
                return;
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        this.tryFileSystem("", uriStr);
    }

    private void tryJar(String uriStr) throws IOException {
        int i = uriStr.indexOf(33);
        if (i == -1) {
            return;
        }
        this.url = new URL(uriStr);
        try {
            this.is = this.url.openStream();
            try {
                this.uri = this.url.toURI();
            }
            catch (URISyntaxException ex) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public URL getURL() {
        return this.url;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public boolean isResolved() {
        return this.is != null;
    }
}

