/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.handler;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.PortInfo;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.handler.AnnotationHandlerChainBuilder;
import org.apache.geronimo.xbeans.javaee.HandlerChainType;
import org.apache.xmlbeans.XmlCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeronimoHandlerChainBuilder
extends AnnotationHandlerChainBuilder {
    private static final Logger log = LoggerFactory.getLogger(GeronimoHandlerChainBuilder.class);
    private ClassLoader classLoader = null;
    private PortInfo portInfo;

    public GeronimoHandlerChainBuilder(ClassLoader classloader, PortInfo portInfo) {
        this.classLoader = classloader;
        this.portInfo = portInfo;
    }

    public ClassLoader getHandlerClassLoader() {
        return this.classLoader;
    }

    @Override
    protected List<Handler> buildHandlerChain(HandlerChainType hc, ClassLoader classLoader) {
        if (this.matchServiceName(this.portInfo, hc) && this.matchPortName(this.portInfo, hc) && this.matchBinding(this.portInfo, hc)) {
            return super.buildHandlerChain(hc, classLoader);
        }
        return Collections.emptyList();
    }

    private boolean matchServiceName(PortInfo info, HandlerChainType hc) {
        if (hc.isSetServiceNamePattern()) {
            QName serviceName = info == null ? null : info.getServiceName();
            return this.match(hc.xgetServiceNamePattern().newCursor(), serviceName, hc.getServiceNamePattern());
        }
        return true;
    }

    private boolean matchPortName(PortInfo info, HandlerChainType hc) {
        if (hc.isSetPortNamePattern()) {
            QName portName = info == null ? null : info.getPortName();
            return this.match(hc.xgetPortNamePattern().newCursor(), portName, hc.getPortNamePattern());
        }
        return true;
    }

    private boolean matchBinding(PortInfo info, HandlerChainType hc) {
        return this.match(info == null ? null : info.getBindingID(), hc.getProtocolBindings());
    }

    private boolean match(String binding, List bindings) {
        if (binding == null) {
            return bindings == null || bindings.isEmpty();
        }
        if (bindings == null || bindings.isEmpty()) {
            return true;
        }
        String actualBindingURI = JAXWSUtils.getBindingURI(binding);
        for (String bindingToken : bindings) {
            String bindingURI = JAXWSUtils.getBindingURI(bindingToken);
            if (!actualBindingURI.equals(bindingURI)) continue;
            return true;
        }
        return false;
    }

    public List<Handler> buildHandlerChainFromConfiguration(HandlerChainType hc) {
        if (null == hc) {
            return null;
        }
        return this.sortHandlers(this.buildHandlerChain(hc, this.getHandlerClassLoader()));
    }

    private boolean match(XmlCursor node, QName name, String namePattern) {
        String localNamePattern;
        if (name == null) {
            return namePattern == null || namePattern.equals("*");
        }
        if (namePattern == null) {
            return true;
        }
        int pos = namePattern.indexOf(58);
        if (pos == -1) {
            localNamePattern = namePattern;
        } else {
            localNamePattern = namePattern.substring(pos + 1);
            String prefix = namePattern.substring(0, pos);
            String namespace = node.namespaceForPrefix(prefix.trim());
            if (namespace == null) {
                namespace = prefix;
            }
            if (!namespace.equals(name.getNamespaceURI())) {
                return false;
            }
        }
        localNamePattern = localNamePattern.trim();
        if (localNamePattern.contains("*")) {
            Pattern pattern = Pattern.compile(localNamePattern.replace("*", "(\\w|\\.|-|_)*"));
            Matcher matcher = pattern.matcher(name.getLocalPart());
            return matcher.matches();
        }
        return localNamePattern.equals(name.getLocalPart());
    }
}

