/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.geronimo.jaxws.HandlerChainsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortInfo
implements Serializable {
    private String serviceName;
    private String portName;
    private String seiInterfaceName;
    private String wsdlFile;
    private String servletLink;
    private String handlersAsXML;
    private boolean mtomEnabled;
    private String binding;
    private QName wsdlPort;
    private QName wsdlService;
    private String location;

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String pn) {
        this.portName = pn;
    }

    public String getServiceEndpointInterfaceName() {
        return this.seiInterfaceName;
    }

    public void setServiceEndpointInterfaceName(String sei) {
        this.seiInterfaceName = sei;
    }

    public String getServiceLink() {
        return this.servletLink;
    }

    public void setServiceLink(String sl) {
        this.servletLink = sl;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String wf) {
        this.wsdlFile = wf;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String sn) {
        this.serviceName = sn;
    }

    public void setEnableMTOM(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMTOMEnabled() {
        return this.mtomEnabled;
    }

    public void setProtocolBinding(String binding) {
        this.binding = binding;
    }

    public String getProtocolBinding() {
        return this.binding;
    }

    public void setHandlers(Class type, Object handlerChain) throws Exception {
        if (handlerChain == null) {
            return;
        }
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{type});
        Marshaller m = ctx.createMarshaller();
        StringWriter writer = new StringWriter();
        QName rootElement = new QName("", "root");
        JAXBElement element = new JAXBElement(rootElement, type, handlerChain);
        m.marshal((Object)element, (Writer)writer);
        this.handlersAsXML = writer.toString();
    }

    public <T> T getHandlers(Class<T> type) throws Exception {
        return HandlerChainsUtils.toHandlerChains(this.handlersAsXML, type);
    }

    public QName getWsdlPort() {
        return this.wsdlPort;
    }

    public void setWsdlPort(QName wsdlPort) {
        this.wsdlPort = wsdlPort;
    }

    public QName getWsdlService() {
        return this.wsdlService;
    }

    public void setWsdlService(QName wsdlService) {
        this.wsdlService = wsdlService;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String toString() {
        return "[" + this.serviceName + ":" + this.portName + ":" + this.seiInterfaceName + ":" + this.wsdlFile + "]";
    }

    public String getHandlersAsXML() {
        return this.handlersAsXML;
    }

    public void setHandlersAsXML(String handlersAsXML) {
        this.handlersAsXML = handlersAsXML;
    }
}

