/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.builder.WARWebServiceFinder;
import org.apache.geronimo.jaxws.builder.WebServiceFinder;
import org.apache.geronimo.xbeans.javaee6.ServletMappingType;
import org.apache.geronimo.xbeans.javaee6.ServletType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleWARWebServiceFinder
implements WebServiceFinder {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleWARWebServiceFinder.class);

    @Override
    public Map<String, PortInfo> discoverWebServices(Module module, boolean isEJB, Map correctedPortLocations) throws DeploymentException {
        HashMap<String, PortInfo> map = new HashMap<String, PortInfo>();
        this.discoverPOJOWebServices(module, correctedPortLocations, map);
        return map;
    }

    private void discoverPOJOWebServices(Module module, Map correctedPortLocations, Map<String, PortInfo> map) throws DeploymentException {
        Bundle bundle = module.getEarContext().getDeploymentBundle();
        WebAppType webApp = (WebAppType)module.getSpecDD();
        ServletType[] servletTypes = webApp.getServletArray();
        if (webApp.getDomNode().getChildNodes().getLength() == 0) {
            List<Class> services = WARWebServiceFinder.discoverWebServices(module.getModuleFile(), false, this.getClass().getClassLoader());
            String contextRoot = ((WebModule)module).getContextRoot();
            for (Class service : services) {
                if (!JAXWSUtils.isWebService((Class)service)) continue;
                LOG.debug("Discovered POJO Web Service: " + service.getName());
                ServletType servlet = webApp.addNewServlet();
                servlet.addNewServletName().setStringValue(service.getName());
                servlet.addNewServletClass().setStringValue(service.getName());
                String location = "/" + JAXWSUtils.getServiceName((Class)service);
                ServletMappingType servletMapping = webApp.addNewServletMapping();
                servletMapping.addNewServletName().setStringValue(service.getName());
                servletMapping.addNewUrlPattern().setStringValue(location);
                PortInfo portInfo = new PortInfo();
                portInfo.setLocation(contextRoot + location);
                map.put(service.getName(), portInfo);
            }
        } else {
            for (ServletType servletType : servletTypes) {
                String servletName = servletType.getServletName().getStringValue().trim();
                if (!servletType.isSetServletClass()) continue;
                String servletClassName = servletType.getServletClass().getStringValue().trim();
                try {
                    Class servletClass = bundle.loadClass(servletClassName);
                    if (!JAXWSUtils.isWebService((Class)servletClass)) continue;
                    LOG.debug("Found POJO Web Service: " + servletName);
                    PortInfo portInfo = new PortInfo();
                    map.put(servletName, portInfo);
                }
                catch (Exception e) {
                    throw new DeploymentException("Failed to load servlet class " + servletClassName + " from bundle " + bundle, (Throwable)e);
                }
            }
            for (Map.Entry<String, PortInfo> entry : map.entrySet()) {
                String servletName = entry.getKey();
                PortInfo portInfo = entry.getValue();
                String location = (String)correctedPortLocations.get(servletName);
                if (location == null) continue;
                portInfo.setLocation(location);
            }
        }
    }
}

