/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.builder.WebServiceFinder;
import org.apache.geronimo.kernel.classloader.JarFileClassLoader;
import org.apache.geronimo.xbeans.javaee.ServletMappingType;
import org.apache.geronimo.xbeans.javaee.ServletType;
import org.apache.geronimo.xbeans.javaee.WebAppType;
import org.apache.xbean.finder.ClassFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WARWebServiceFinder
implements WebServiceFinder {
    private static final Log LOG = LogFactory.getLog(WARWebServiceFinder.class);

    @Override
    public Map<String, PortInfo> discoverWebServices(Module module, boolean isEJB, Map correctedPortLocations) throws DeploymentException {
        HashMap<String, PortInfo> map = new HashMap<String, PortInfo>();
        this.discoverPOJOWebServices(module, correctedPortLocations, map);
        return map;
    }

    private void discoverPOJOWebServices(Module module, Map correctedPortLocations, Map<String, PortInfo> map) throws DeploymentException {
        ClassLoader classLoader = module.getEarContext().getClassLoader();
        WebAppType webApp = (WebAppType)module.getSpecDD();
        ServletType[] servletTypes = webApp.getServletArray();
        if (webApp.getDomNode().getChildNodes().getLength() == 0) {
            List<Class> services = this.discoverWebServices(module.getModuleFile(), false);
            String contextRoot = ((WebModule)module).getContextRoot();
            for (Class service : services) {
                if (!JAXWSUtils.isWebService((Class)service)) continue;
                LOG.debug((Object)("Discovered POJO Web Service: " + service.getName()));
                ServletType servlet = webApp.addNewServlet();
                servlet.addNewServletName().setStringValue(service.getName());
                servlet.addNewServletClass().setStringValue(service.getName());
                String location = "/" + JAXWSUtils.getServiceName((Class)service);
                ServletMappingType servletMapping = webApp.addNewServletMapping();
                servletMapping.addNewServletName().setStringValue(service.getName());
                servletMapping.addNewUrlPattern().setStringValue(location);
                PortInfo portInfo = new PortInfo();
                portInfo.setLocation(contextRoot + location);
                map.put(service.getName(), portInfo);
            }
        } else {
            for (ServletType servletType : servletTypes) {
                String servletName = servletType.getServletName().getStringValue().trim();
                if (!servletType.isSetServletClass()) continue;
                String servletClassName = servletType.getServletClass().getStringValue().trim();
                try {
                    Class<?> servletClass = classLoader.loadClass(servletClassName);
                    if (!JAXWSUtils.isWebService(servletClass)) continue;
                    LOG.debug((Object)("Found POJO Web Service: " + servletName));
                    PortInfo portInfo = new PortInfo();
                    map.put(servletName, portInfo);
                }
                catch (Exception e) {
                    throw new DeploymentException("Failed to load servlet class " + servletClassName, (Throwable)e);
                }
            }
            for (Map.Entry<String, PortInfo> entry : map.entrySet()) {
                String servletName = entry.getKey();
                PortInfo portInfo = entry.getValue();
                String location = (String)correctedPortLocations.get(servletName);
                if (location == null) continue;
                portInfo.setLocation(location);
            }
        }
    }

    private List<Class> discoverWebServices(JarFile moduleFile, boolean isEJB) throws DeploymentException {
        LOG.debug((Object)"Discovering web service classes");
        File tmpDir = null;
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (isEJB) {
            File jarFile = new File(moduleFile.getName());
            try {
                urlList.add(jarFile.toURL());
            }
            catch (MalformedURLException e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        try {
            tmpDir = DeploymentUtil.createTempDir();
            JarFile module = new JarFile(moduleFile.getName());
            DeploymentUtil.unzipToDirectory((ZipFile)module, (File)tmpDir);
        }
        catch (IOException e) {
            if (tmpDir != null) {
                DeploymentUtil.recursiveDelete((File)tmpDir);
            }
            throw new DeploymentException("Failed to expand the module archive", (Throwable)e);
        }
        Enumeration<JarEntry> jarEnum = moduleFile.entries();
        while (jarEnum.hasMoreElements()) {
            JarEntry entry = jarEnum.nextElement();
            String name = entry.getName();
            if (name.equals("WEB-INF/classes/")) {
                File classesDir = new File(tmpDir, "WEB-INF/classes/");
                try {
                    urlList.add(0, classesDir.toURL());
                }
                catch (MalformedURLException e) {}
                continue;
            }
            if (!name.startsWith("WEB-INF/lib/") || !name.endsWith(".jar")) continue;
            File jarFile = new File(tmpDir, name);
            try {
                urlList.add(jarFile.toURL());
            }
            catch (MalformedURLException e) {}
        }
        URL[] urls = urlList.toArray(new URL[0]);
        JarFileClassLoader tempClassLoader = new JarFileClassLoader(null, urls, this.getClass().getClassLoader());
        ClassFinder classFinder = new ClassFinder((ClassLoader)tempClassLoader, urlList);
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.addAll(classFinder.findAnnotatedClasses(WebService.class));
        classes.addAll(classFinder.findAnnotatedClasses(WebServiceProvider.class));
        tempClassLoader.destroy();
        if (tmpDir != null) {
            DeploymentUtil.recursiveDelete((File)tmpDir);
        }
        return classes;
    }
}

