/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentConfigurationManager;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.kernel.repository.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlGenerator {
    private static final Log LOG = LogFactory.getLog(WsdlGenerator.class);
    private static final Artifact AXIS2_JAXWS_API_ARTIFACT = new Artifact("org.apache.axis2", "axis2-jaxws-api", (Version)null, "jar");
    private static final Artifact AXIS2_SAAJ_API_ARTIFACT = new Artifact("org.apache.axis2", "axis2-saaj-api", (Version)null, "jar");
    private static final Artifact AXIS2_SAAJ_IMPL_ARTIFACT = new Artifact("org.apache.axis2", "axis2-saaj", (Version)null, "jar");
    private static final Artifact JAXB_API_ARTIFACT = new Artifact("javax.xml.bind", "jaxb-api", (Version)null, "jar");
    private static final Artifact JAXB_IMPL_ARTIFACT = new Artifact("com.sun.xml.bind", "jaxb-impl", (Version)null, "jar");
    private static final Artifact JAXB_XJC_ARTIFACT = new Artifact("com.sun.xml.bind", "jaxb-xjc", (Version)null, "jar");
    private static final Artifact JAXWS_TOOLS_ARTIFACT = new Artifact("com.sun.xml.ws", "jaxws-tools", (Version)null, "jar");
    private static final Artifact JAXWS_RT_ARTIFACT = new Artifact("com.sun.xml.ws", "jaxws-rt", (Version)null, "jar");
    private static final Artifact GERONIMO_ACTIVATION_SPEC_ARTIFACT = new Artifact("org.apache.geronimo.specs", "geronimo-activation_1.1_spec", (Version)null, "jar");
    private static final Artifact GERONIMO_ANNOTATION_ARTIFACT = new Artifact("org.apache.geronimo.specs", "geronimo-annotation_1.0_spec", (Version)null, "jar");
    private static final Artifact GERONIMO_WS_METADATA_ARTIFACT = new Artifact("org.apache.geronimo.specs", "geronimo-ws-metadata_2.0_spec", (Version)null, "jar");
    private static final Artifact GERONIMO_EJB_SPEC_ARTIFACT = new Artifact("org.apache.geronimo.specs", "geronimo-ejb_3.0_spec", (Version)null, "jar");
    private static final Artifact SUN_SAAJ_IMPL_ARTIFACT = new Artifact("com.sun.xml.messaging.saaj", "saaj-impl", (Version)null, "jar");
    private static final String TOOLS = "tools.jar";
    private Artifact saajImpl;
    private QName wsdlService;
    private QName wsdlPort;

    public void setSunSAAJ() {
        this.saajImpl = SUN_SAAJ_IMPL_ARTIFACT;
    }

    public void setAxis2SAAJ() {
        this.saajImpl = AXIS2_SAAJ_IMPL_ARTIFACT;
    }

    public void setWsdlService(QName name) {
        this.wsdlService = name;
    }

    public QName getWsdlService() {
        return this.wsdlService;
    }

    public void setWsdlPort(QName port) {
        this.wsdlPort = port;
    }

    public QName getWsdlPort() {
        return this.wsdlPort;
    }

    private URL[] getWsgenClasspath(DeploymentContext context) throws DeploymentException, MalformedURLException {
        ArrayList<URL> jars = new ArrayList<URL>();
        DeploymentConfigurationManager cm = (DeploymentConfigurationManager)context.getConfigurationManager();
        Collection repositories = cm.getRepositories();
        jars.add(WsdlGenerator.getLocation(repositories, JAXB_API_ARTIFACT));
        jars.add(WsdlGenerator.getLocation(repositories, JAXB_IMPL_ARTIFACT));
        jars.add(WsdlGenerator.getLocation(repositories, JAXB_XJC_ARTIFACT));
        jars.add(WsdlGenerator.getLocation(repositories, JAXWS_TOOLS_ARTIFACT));
        jars.add(WsdlGenerator.getLocation(repositories, JAXWS_RT_ARTIFACT));
        jars.add(WsdlGenerator.getLocation(repositories, AXIS2_JAXWS_API_ARTIFACT));
        jars.add(WsdlGenerator.getLocation(repositories, AXIS2_SAAJ_API_ARTIFACT));
        jars.add(WsdlGenerator.getLocation(repositories, GERONIMO_ACTIVATION_SPEC_ARTIFACT));
        jars.add(WsdlGenerator.getLocation(repositories, GERONIMO_ANNOTATION_ARTIFACT));
        jars.add(WsdlGenerator.getLocation(repositories, GERONIMO_WS_METADATA_ARTIFACT));
        jars.add(WsdlGenerator.getLocation(repositories, GERONIMO_EJB_SPEC_ARTIFACT));
        if (this.saajImpl != null) {
            jars.add(WsdlGenerator.getLocation(repositories, this.saajImpl));
        }
        jars.add(new File(WsdlGenerator.getToolsJarLoc()).toURL());
        return jars.toArray(new URL[jars.size()]);
    }

    private static String getModuleClasspath(Module module, DeploymentContext context) throws DeploymentException {
        File moduleBase = module.getEarContext().getBaseDir();
        File moduleBaseDir = moduleBase.isFile() ? moduleBase.getParentFile() : moduleBase;
        String baseDir = moduleBaseDir.getAbsolutePath();
        List moduleClassPath = context.getConfiguration().getClassPath();
        StringBuilder classpath = new StringBuilder();
        for (String s : moduleClassPath) {
            s = s.replace("/", File.separator);
            classpath.append(baseDir);
            classpath.append(File.separator);
            classpath.append(s);
            classpath.append(File.pathSeparator);
        }
        return classpath.toString();
    }

    private static URL getLocation(Collection<ListableRepository> repositories, Artifact artifactQuery) throws DeploymentException, MalformedURLException {
        File file = null;
        for (ListableRepository repository : repositories) {
            SortedSet artifactSet = repository.list(artifactQuery);
            if (artifactSet.size() == 1) {
                file = repository.getLocation((Artifact)artifactSet.first());
                return file.getAbsoluteFile().toURL();
            }
            if (artifactSet.size() <= 1) continue;
            file = repository.getLocation((Artifact)artifactSet.last());
            return file.getAbsoluteFile().toURL();
        }
        if (file == null) {
            throw new DeploymentException("Missing artifact in repositories: " + artifactQuery.toString());
        }
        return null;
    }

    private static String getToolsJarLoc() throws DeploymentException {
        File jdkhomelib;
        String jreHomePath = System.getProperty("java.home");
        String javaHomePath = "";
        int jreHomePathLength = jreHomePath.length();
        if (jreHomePathLength > 0) {
            int i = jreHomePath.substring(0, jreHomePathLength - 1).lastIndexOf(File.separator);
            javaHomePath = jreHomePath.substring(0, i);
        }
        if (!(jdkhomelib = new File(javaHomePath + File.separator + "lib")).exists()) {
            throw new DeploymentException("Missing " + jdkhomelib.getAbsolutePath() + ". This is required for wsgen to run. ");
        }
        File tools = new File(jdkhomelib + File.separator + TOOLS);
        if (!tools.exists()) {
            throw new DeploymentException("Missing tools.jar in" + jdkhomelib.getAbsolutePath() + ". This is required for wsgen to run. ");
        }
        return tools.getAbsolutePath();
    }

    private static File toFile(URL url) {
        if (url == null || !url.getProtocol().equals("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        int pos = 0;
        while ((pos = filename.indexOf(37, pos)) >= 0) {
            if (pos + 2 >= filename.length()) continue;
            String hexStr = filename.substring(pos + 1, pos + 3);
            char ch = (char)Integer.parseInt(hexStr, 16);
            filename = filename.substring(0, pos) + ch + filename.substring(pos + 3);
        }
        return new File(filename);
    }

    private String[] buildArguments(String sei, String classPath, File moduleBaseDir, PortInfo portInfo) {
        QName portName;
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-cp");
        arguments.add(classPath);
        arguments.add("-keep");
        arguments.add("-wsdl");
        arguments.add("-d");
        arguments.add(moduleBaseDir.getAbsolutePath());
        QName serviceName = this.getWsdlService();
        if (serviceName != null) {
            arguments.add("-servicename");
            arguments.add(serviceName.toString());
        }
        if ((portName = this.getWsdlPort()) != null) {
            arguments.add("-portname");
            arguments.add(portName.toString());
        }
        arguments.add(sei);
        return arguments.toArray(new String[0]);
    }

    private File getFirstWsdlFile(File baseDir) throws IOException {
        LOG.debug((Object)("Looking for service wsdl file in " + baseDir.getAbsolutePath()));
        File[] files = baseDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".wsdl");
            }
        });
        if (files.length == 1) {
            return files[0];
        }
        return null;
    }

    private File findWsdlFile(File baseDir, PortInfo portInfo) throws IOException {
        QName serviceName = this.getWsdlService();
        if (serviceName != null) {
            File wsdlFile;
            String wsdlFileName = serviceName.getLocalPart() + ".wsdl";
            if (Character.isLowerCase(wsdlFileName.charAt(0))) {
                wsdlFileName = Character.toUpperCase(wsdlFileName.charAt(0)) + wsdlFileName.substring(1);
            }
            if ((wsdlFile = new File(baseDir, wsdlFileName)).exists()) {
                return wsdlFile;
            }
            return this.getFirstWsdlFile(baseDir);
        }
        return this.getFirstWsdlFile(baseDir);
    }

    private static String getRelativeNameOrURL(File baseDir, File file) {
        String basePath = baseDir.getAbsolutePath();
        String path = file.getAbsolutePath();
        if (path.startsWith(basePath)) {
            if (File.separatorChar == path.charAt(basePath.length())) {
                return path.substring(basePath.length() + 1);
            }
            return path.substring(basePath.length());
        }
        return file.toURI().toString();
    }

    private static File createTempDirectory(File baseDir) throws IOException {
        String dirName;
        File dir;
        Random rand = new Random();
        while ((dir = new File(baseDir, dirName = String.valueOf(Math.abs(rand.nextInt())))).exists()) {
        }
        if (!dir.mkdir()) {
            throw new IOException("Failed to create temporary directory: " + dir);
        }
        return dir;
    }

    public String generateWsdl(Module module, String serviceClass, DeploymentContext context, PortInfo portInfo) throws DeploymentException {
        URL[] urls;
        File baseDir;
        File moduleBase = module.getEarContext().getBaseDir();
        File moduleBaseDir = moduleBase.isFile() ? moduleBase.getParentFile() : moduleBase;
        try {
            baseDir = WsdlGenerator.createTempDirectory(moduleBaseDir);
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
        StringBuilder classPath = new StringBuilder();
        try {
            urls = this.getWsgenClasspath(context);
        }
        catch (MalformedURLException e) {
            throw new DeploymentException("unable to generate the wsdl file using wsgen. - unable to get the location of the required artifact(s).", (Throwable)e);
        }
        if (urls != null && urls.length > 0) {
            for (int i = 0; i < urls.length; ++i) {
                classPath.append(WsdlGenerator.toFile(urls[i]).getAbsolutePath() + File.pathSeparator);
            }
        }
        classPath.append(WsdlGenerator.getModuleClasspath(module, context));
        String[] arguments = this.buildArguments(serviceClass, classPath.toString(), baseDir, portInfo);
        try {
            URLClassLoader loader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
            Class<?> clazz = loader.loadClass("com.sun.tools.ws.spi.WSToolsObjectFactory");
            Method method = clazz.getMethod("newInstance", new Class[0]);
            Object factory = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("wsgen", OutputStream.class, String[].class);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Boolean result = (Boolean)method2.invoke(factory, os, arguments);
            os.close();
            byte[] arr = os.toByteArray();
            String wsgenOutput = new String(arr, 0, arr.length);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("wsgen output: " + wsgenOutput));
            }
            if (result.booleanValue()) {
                File wsdlFile = this.findWsdlFile(baseDir, portInfo);
                if (wsdlFile == null) {
                    throw new DeploymentException("Unable to find the service wsdl file");
                }
                return WsdlGenerator.getRelativeNameOrURL(moduleBase, wsdlFile);
            }
            throw new DeploymentException("wsgen failed: " + wsgenOutput);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to generate the wsdl file using wsgen.", (Throwable)e);
        }
    }
}

