/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.classloader.JarFileClassLoader;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.openejb.deployment.EjbModule;
import org.apache.geronimo.xbeans.javaee.ServletMappingType;
import org.apache.geronimo.xbeans.javaee.ServletType;
import org.apache.geronimo.xbeans.javaee.WebAppType;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.xbean.finder.ClassFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JAXWSServiceBuilder
implements WebServiceBuilder {
    private static final Log LOG = LogFactory.getLog(JAXWSServiceBuilder.class);
    protected final Environment defaultEnvironment;

    public JAXWSServiceBuilder(Environment defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    protected String getKey() {
        return this.getClass().getName();
    }

    public void findWebServices(Module module, boolean isEJB, Map servletLocations, Environment environment, Map sharedContext) throws DeploymentException {
        Map<String, PortInfo> portMap = null;
        String path = isEJB ? "META-INF/webservices.xml" : "WEB-INF/webservices.xml";
        JarFile moduleFile = module.getModuleFile();
        try {
            URL wsDDUrl = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)path);
            InputStream in = wsDDUrl.openStream();
            portMap = this.parseWebServiceDescriptor(in, wsDDUrl, moduleFile, isEJB, servletLocations);
        }
        catch (IOException e) {
            portMap = this.discoverWebServices(module, isEJB, servletLocations);
        }
        if (portMap != null && !portMap.isEmpty()) {
            EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
            sharedContext.put(this.getKey(), portMap);
        }
    }

    private Map<String, PortInfo> discoverWebServices(Module module, boolean isEJB, Map correctedPortLocations) throws DeploymentException {
        HashMap<String, PortInfo> map = new HashMap<String, PortInfo>();
        if (isEJB) {
            this.discoverEJBWebServices(module, correctedPortLocations, map);
        } else {
            this.discoverPOJOWebServices(module, correctedPortLocations, map);
        }
        return map;
    }

    private void discoverPOJOWebServices(Module module, Map correctedPortLocations, Map<String, PortInfo> map) throws DeploymentException {
        ClassLoader classLoader = module.getEarContext().getClassLoader();
        WebAppType webApp = (WebAppType)module.getSpecDD();
        ServletType[] servletTypes = webApp.getServletArray();
        if (webApp.getDomNode().getChildNodes().getLength() == 0) {
            List<Class> services = this.discoverWebServices(module.getModuleFile(), false);
            String contextRoot = ((WebModule)module).getContextRoot();
            for (Class service : services) {
                if (!JAXWSUtils.isWebService((Class)service)) continue;
                LOG.debug((Object)("Discovered POJO Web Service: " + service.getName()));
                ServletType servlet = webApp.addNewServlet();
                servlet.addNewServletName().setStringValue(service.getName());
                servlet.addNewServletClass().setStringValue(service.getName());
                String location = "/" + JAXWSUtils.getServiceName((Class)service);
                ServletMappingType servletMapping = webApp.addNewServletMapping();
                servletMapping.addNewServletName().setStringValue(service.getName());
                servletMapping.addNewUrlPattern().setStringValue(location);
                PortInfo portInfo = new PortInfo();
                portInfo.setLocation(contextRoot + location);
                map.put(service.getName(), portInfo);
            }
        } else {
            for (ServletType servletType : servletTypes) {
                String servletName = servletType.getServletName().getStringValue().trim();
                if (!servletType.isSetServletClass()) continue;
                String servletClassName = servletType.getServletClass().getStringValue().trim();
                try {
                    Class<?> servletClass = classLoader.loadClass(servletClassName);
                    if (!JAXWSUtils.isWebService(servletClass)) continue;
                    LOG.debug((Object)("Found POJO Web Service: " + servletName));
                    PortInfo portInfo = new PortInfo();
                    map.put(servletName, portInfo);
                }
                catch (Exception e) {
                    throw new DeploymentException("Failed to load servlet class " + servletClassName, (Throwable)e);
                }
            }
            for (Map.Entry<String, PortInfo> entry : map.entrySet()) {
                String servletName = entry.getKey();
                PortInfo portInfo = entry.getValue();
                String location = (String)correctedPortLocations.get(servletName);
                if (location == null) continue;
                portInfo.setLocation(location);
            }
        }
    }

    private void discoverEJBWebServices(Module module, Map correctedPortLocations, Map<String, PortInfo> map) throws DeploymentException {
        ClassLoader classLoader = module.getEarContext().getClassLoader();
        EjbModule ejbModule = (EjbModule)module;
        for (EnterpriseBeanInfo bean : ejbModule.getEjbJarInfo().enterpriseBeans) {
            if (bean.type != 2) continue;
            try {
                Class<?> ejbClass = classLoader.loadClass(bean.ejbClass);
                if (!JAXWSUtils.isWebService(ejbClass)) continue;
                LOG.debug((Object)("Found EJB Web Service: " + bean.ejbName));
                PortInfo portInfo = new PortInfo();
                String location = (String)correctedPortLocations.get(bean.ejbName);
                if (location == null) {
                    location = "/" + JAXWSUtils.getServiceName(ejbClass) + "/" + JAXWSUtils.getName(ejbClass);
                }
                portInfo.setLocation(location);
                map.put(bean.ejbName, portInfo);
            }
            catch (Exception e) {
                throw new DeploymentException("Failed to load ejb class " + bean.ejbName, (Throwable)e);
            }
        }
    }

    private List<Class> discoverWebServices(JarFile moduleFile, boolean isEJB) throws DeploymentException {
        LOG.debug((Object)"Discovering web service classes");
        File tmpDir = null;
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (isEJB) {
            File jarFile = new File(moduleFile.getName());
            try {
                urlList.add(jarFile.toURL());
            }
            catch (MalformedURLException e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        try {
            tmpDir = DeploymentUtil.createTempDir();
            JarFile module = new JarFile(moduleFile.getName());
            DeploymentUtil.unzipToDirectory((ZipFile)module, (File)tmpDir);
        }
        catch (IOException e) {
            if (tmpDir != null) {
                DeploymentUtil.recursiveDelete((File)tmpDir);
            }
            throw new DeploymentException("Failed to expand the module archive", (Throwable)e);
        }
        Enumeration<JarEntry> jarEnum = moduleFile.entries();
        while (jarEnum.hasMoreElements()) {
            JarEntry entry = jarEnum.nextElement();
            String name = entry.getName();
            if (name.equals("WEB-INF/classes/")) {
                File classesDir = new File(tmpDir, "WEB-INF/classes/");
                try {
                    urlList.add(0, classesDir.toURL());
                }
                catch (MalformedURLException e) {}
                continue;
            }
            if (!name.startsWith("WEB-INF/lib/") || !name.endsWith(".jar")) continue;
            File jarFile = new File(tmpDir, name);
            try {
                urlList.add(jarFile.toURL());
            }
            catch (MalformedURLException e) {}
        }
        URL[] urls = urlList.toArray(new URL[0]);
        JarFileClassLoader tempClassLoader = new JarFileClassLoader(null, urls, this.getClass().getClassLoader());
        ClassFinder classFinder = new ClassFinder((ClassLoader)tempClassLoader, urlList);
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.addAll(classFinder.findAnnotatedClasses(WebService.class));
        classes.addAll(classFinder.findAnnotatedClasses(WebServiceProvider.class));
        tempClassLoader.destroy();
        if (tmpDir != null) {
            DeploymentUtil.recursiveDelete((File)tmpDir);
        }
        return classes;
    }

    protected abstract Map<String, PortInfo> parseWebServiceDescriptor(InputStream var1, URL var2, JarFile var3, boolean var4, Map var5) throws DeploymentException;

    public boolean configurePOJO(GBeanData targetGBean, String servletName, Module module, String servletClassName, DeploymentContext context) throws DeploymentException {
        Map sharedContext = ((WebModule)module).getSharedContext();
        Map portInfoMap = (Map)sharedContext.get(this.getKey());
        if (portInfoMap == null) {
            return false;
        }
        PortInfo portInfo = (PortInfo)portInfoMap.get(servletName);
        if (portInfo == null) {
            return false;
        }
        ClassLoader classLoader = context.getClassLoader();
        Class<?> servletClass = this.loadClass(servletClassName, classLoader);
        if (!JAXWSUtils.isWebService(servletClass)) {
            return false;
        }
        Map componentContext = null;
        try {
            GBeanData moduleGBean = context.getGBeanInstance(context.getModuleName());
            componentContext = (Map)moduleGBean.getAttribute("componentContext");
        }
        catch (GBeanNotFoundException e) {
            LOG.warn((Object)"ModuleGBean not found. JNDI resource injection will not work.");
        }
        String location = portInfo.getLocation();
        LOG.info((Object)("Configuring JAX-WS Web Service: " + servletName + " at " + location));
        AbstractName containerFactoryName = context.getNaming().createChildName(targetGBean.getAbstractName(), this.getContainerFactoryGBeanInfo().getName(), "GBean");
        GBeanData containerFactoryData = new GBeanData(containerFactoryName, this.getContainerFactoryGBeanInfo());
        containerFactoryData.setAttribute("portInfo", (Object)portInfo);
        containerFactoryData.setAttribute("endpointClassName", (Object)servletClassName);
        containerFactoryData.setAttribute("componentContext", (Object)componentContext);
        try {
            context.addGBean(containerFactoryData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add web service container factory gbean", (Throwable)e);
        }
        targetGBean.setReferencePattern("WebServiceContainerFactory", containerFactoryName);
        targetGBean.setAttribute("pojoClassName", (Object)"java.lang.Object");
        if (context instanceof EARContext) {
            containerFactoryData.setReferencePattern("TransactionManager", ((EARContext)context).getTransactionManagerName());
        }
        this.initialize(containerFactoryData, servletClass, portInfo, module);
        return true;
    }

    protected abstract GBeanInfo getContainerFactoryGBeanInfo();

    public boolean configureEJB(GBeanData targetGBean, String ejbName, Module module, Map sharedContext, ClassLoader classLoader) throws DeploymentException {
        Map portInfoMap = (Map)sharedContext.get(this.getKey());
        if (portInfoMap == null) {
            return false;
        }
        PortInfo portInfo = (PortInfo)portInfoMap.get(ejbName);
        if (portInfo == null) {
            return false;
        }
        String beanClassName = (String)targetGBean.getAttribute("ejbClass");
        Class<?> beanClass = this.loadClass(beanClassName, classLoader);
        if (!JAXWSUtils.isWebService(beanClass)) {
            return false;
        }
        String location = portInfo.getLocation();
        if (location == null) {
            throw new DeploymentException("Endpoint URI for EJB WebService is missing");
        }
        LOG.info((Object)("Configuring EJB JAX-WS Web Service: " + ejbName + " at " + location));
        targetGBean.setAttribute("portInfo", (Object)portInfo);
        this.initialize(targetGBean, beanClass, portInfo, module);
        return true;
    }

    protected void initialize(GBeanData targetGBean, Class wsClass, PortInfo info, Module module) throws DeploymentException {
    }

    Class<?> loadClass(String className, ClassLoader loader) throws DeploymentException {
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new DeploymentException("Unable to load Web Service class: " + className, (Throwable)ex);
        }
    }
}

