/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jasper.deployment;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.Deployable;
import org.apache.geronimo.deployment.DeployableJarFile;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarFileTldScanner {
    private static final Logger log = LoggerFactory.getLogger(JarFileTldScanner.class);

    public List<URL> scanModule(WebModule webModule) throws DeploymentException {
        log.debug("scanModule( " + webModule.getName() + " ): Entry");
        Deployable deployable = webModule.getDeployable();
        if (!(deployable instanceof DeployableJarFile)) {
            throw new IllegalArgumentException("Expected DeployableJarFile");
        }
        JarFile jarFile = ((DeployableJarFile)deployable).getJarFile();
        ArrayList<URL> modURLs = new ArrayList<URL>();
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                File targetFile;
                String jarEntryName = entries.nextElement().getName();
                if (jarEntryName.startsWith("WEB-INF") && jarEntryName.endsWith(".tld")) {
                    if (jarEntryName.startsWith("WEB-INF/classes") || jarEntryName.startsWith("WEB-INF/lib") || jarEntryName.startsWith("WEB-INF/tags") && !jarEntryName.endsWith("implicit.tld") || (targetFile = webModule.getEarContext().getTargetFile(webModule.resolve(JarFileTldScanner.createURI(jarEntryName)))) == null) continue;
                    modURLs.add(targetFile.toURI().toURL());
                    continue;
                }
                if (!jarEntryName.startsWith("WEB-INF/lib/") || !jarEntryName.endsWith(".jar")) continue;
                targetFile = webModule.getEarContext().getTargetFile(webModule.resolve(JarFileTldScanner.createURI(jarEntryName)));
                List<URL> jarUrls = this.scanJAR(new JarFile(targetFile), "META-INF/");
                for (URL jarURL : jarUrls) {
                    modURLs.add(jarURL);
                }
            }
        }
        catch (IOException ioe) {
            throw new DeploymentException("Could not scan module for TLD files: " + webModule.getName() + " " + ioe.getMessage(), (Throwable)ioe);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not scan module for TLD files: " + webModule.getName() + " " + e.getMessage(), (Throwable)e);
        }
        log.debug("scanModule() Exit: URL[" + modURLs.size() + "]: " + ((Object)modURLs).toString());
        return modURLs;
    }

    private List<URL> scanJAR(JarFile jarFile, String prefix) throws DeploymentException {
        log.debug("scanJAR( " + jarFile.getName() + " ): Entry");
        ArrayList<URL> jarURLs = new ArrayList<URL>();
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (prefix != null) {
                    if (!jarEntry.getName().endsWith(".tld") || !jarEntry.getName().startsWith(prefix)) continue;
                    jarURLs.add(new URL("jar:file:" + jarFile.getName() + "!/" + jarEntry.getName()));
                    continue;
                }
                if (!jarEntry.getName().endsWith(".tld")) continue;
                jarURLs.add(new URL("jar:file:" + jarFile.getName() + "!/" + jarEntry.getName()));
            }
        }
        catch (MalformedURLException mfe) {
            throw new DeploymentException("Could not scan JAR file for TLD files: " + jarFile.getName() + " " + mfe.getMessage(), (Throwable)mfe);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not scan JAR file for TLD files: " + jarFile.getName() + " " + e.getMessage(), (Throwable)e);
        }
        log.debug("scanJAR() Exit: URL[" + jarURLs.size() + "]: " + ((Object)jarURLs).toString());
        return jarURLs;
    }

    /*
     * Unable to fully structure code
     */
    private List<URL> scanDirectory(URL url) throws DeploymentException {
        JarFileTldScanner.log.debug("scanDirectory( " + url.toString() + " ): Entry");
        dirURLs = new ArrayList<URL>();
        if (url != null) {
            if (url.toString().startsWith("jar:file:")) {
                try {
                    jarConnection = (JarURLConnection)url.openConnection();
                    urlJC = jarConnection.getJarFileURL();
                    baseURI = JarFileTldScanner.createURI(urlJC.toString());
                    directory = new File(baseURI);
                    if (!directory.isDirectory()) ** GOTO lbl40
                    if (directory.canRead()) {
                        temp = new JarFile(directory);
                        tempURLs = this.scanJAR(temp, "META-INF");
                        for (URL jarURL : tempURLs) {
                            dirURLs.add(jarURL);
                        }
                    }
                    JarFileTldScanner.log.warn("Cannot read JAR file: " + url.toString());
                }
                catch (Exception e) {
                    throw new DeploymentException("Could not scan directory for TLD files: " + url.toString() + " " + e.getMessage(), (Throwable)e);
                }
            } else if (url.toString().startsWith("file:")) {
                try {
                    baseURI = JarFileTldScanner.createURI(url.toString());
                    directory = new File(baseURI);
                    if (directory.isDirectory() && directory.canRead()) {
                        for (File child : children = directory.listFiles()) {
                            if (!child.getName().endsWith(".tld")) continue;
                            dirURLs.add(child.toURI().toURL());
                        }
                    }
                    JarFileTldScanner.log.warn("Cannot read directory: " + url.toString());
                }
                catch (Exception e) {
                    throw new DeploymentException("Could not scan directory for TLD files: " + url.toString() + " " + e.getMessage(), (Throwable)e);
                }
            } else if (url.toString().startsWith("jar:")) {
                JarFileTldScanner.log.warn("URL type not accounted for: " + url.toString());
            }
        }
lbl40:
        // 10 sources

        JarFileTldScanner.log.debug("scanDirectory() Exit: URL[" + dirURLs.size() + "]: " + dirURLs.toString());
        return dirURLs;
    }

    private static URI createURI(String path) throws URISyntaxException {
        path = path.replaceAll(" ", "%20");
        return new URI(path);
    }
}

