/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jasper.deployment;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.jasper.JasperServletContextCustomizer;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.javaee.FullyQualifiedClassType;
import org.apache.geronimo.xbeans.javaee.JspConfigType;
import org.apache.geronimo.xbeans.javaee.ListenerType;
import org.apache.geronimo.xbeans.javaee.TagType;
import org.apache.geronimo.xbeans.javaee.TaglibDocument;
import org.apache.geronimo.xbeans.javaee.TaglibType;
import org.apache.geronimo.xbeans.javaee.TldTaglibType;
import org.apache.geronimo.xbeans.javaee.WebAppType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspModuleBuilderExtension
implements ModuleBuilderExtension {
    private static final Log log = LogFactory.getLog(JspModuleBuilderExtension.class);
    private final Environment defaultEnvironment;
    private final NamingBuilder namingBuilders;
    private static final QName TLIB_VERSION = new QName("http://java.sun.com/xml/ns/javaee", "tlib-version");
    private static final QName SHORT_NAME = new QName("http://java.sun.com/xml/ns/javaee", "short-name");
    private static final QName TAG_CLASS = new QName("http://java.sun.com/xml/ns/javaee", "tag-class");
    private static final QName TEI_CLASS = new QName("http://java.sun.com/xml/ns/javaee", "tei-class");
    private static final QName BODY_CONTENT = new QName("http://java.sun.com/xml/ns/javaee", "body-content");
    private static final String SCHEMA_LOCATION_URL = "http://java.sun.com/xml/ns/javaee/web-jsptaglibrary_2_1.xsd";
    private static final String VERSION = "2.1";
    public static final GBeanInfo GBEAN_INFO;

    public JspModuleBuilderExtension(Environment defaultEnvironment, NamingBuilder namingBuilders) {
        this.defaultEnvironment = defaultEnvironment;
        this.namingBuilders = namingBuilders;
    }

    public void createModule(Module module, Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repository) throws DeploymentException {
    }

    public void initContext(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
    }

    public void addGBeans(EARContext earContext, Module module, ClassLoader cl, Collection repository) throws DeploymentException {
        Object value;
        if (!(module instanceof WebModule)) {
            return;
        }
        EnvironmentBuilder.mergeEnvironments((Environment)module.getEnvironment(), (Environment)this.defaultEnvironment);
        WebModule webModule = (WebModule)module;
        WebAppType webApp = (WebAppType)webModule.getSpecDD();
        EARContext moduleContext = module.getEarContext();
        Map sharedContext = module.getSharedContext();
        GBeanData webAppData = (GBeanData)sharedContext.get("WEB_APP_DATA");
        AbstractName moduleName = moduleContext.getModuleName();
        HashMap<NamingBuilder.Key, Object> buildingContext = new HashMap<NamingBuilder.Key, Object>();
        buildingContext.put(NamingBuilder.GBEAN_NAME_KEY, moduleName);
        Map compContext = (Map)NamingBuilder.JNDI_KEY.get(sharedContext);
        buildingContext.put(NamingBuilder.JNDI_KEY, compContext);
        Holder holder = (Holder)NamingBuilder.INJECTION_KEY.get(sharedContext);
        buildingContext.put(NamingBuilder.INJECTION_KEY, holder);
        XmlObject jettyWebApp = webModule.getVendorDD();
        Configuration earConfiguration = earContext.getConfiguration();
        HashSet<String> listenerNames = new HashSet<String>();
        ClassFinder classFinder = this.createJspClassFinder(webApp, webModule, listenerNames);
        webModule.setClassFinder(classFinder);
        this.namingBuilders.buildNaming((XmlObject)webApp, jettyWebApp, (Module)webModule, buildingContext);
        GBeanInfo webAppGBeanInfo = webAppData.getGBeanInfo();
        if (webAppGBeanInfo.getReference("ContextCustomizer") != null) {
            AbstractName jspLifecycleName = moduleContext.getNaming().createChildName(moduleName, "jspLifecycleProvider", "GBean");
            GBeanData gbeanData = new GBeanData(jspLifecycleName, JasperServletContextCustomizer.GBEAN_INFO);
            gbeanData.setAttribute("holder", (Object)holder);
            try {
                moduleContext.addGBean(gbeanData);
            }
            catch (GBeanAlreadyExistsException e) {
                throw new DeploymentException("Duplicate jspLifecycleProvider", (Throwable)e);
            }
            webAppData.setReferencePattern("ContextCustomizer", jspLifecycleName);
        }
        if ((value = webAppData.getAttribute("listenerClassNames")) instanceof Collection) {
            ((Collection)value).addAll(listenerNames);
        }
    }

    protected ClassFinder createJspClassFinder(WebAppType webApp, WebModule webModule, Set<String> listenerNames) throws DeploymentException {
        List<URL> urls = this.getTldFiles(webApp, webModule);
        List<Class> classes = this.getListenerClasses(webApp, webModule, urls, listenerNames);
        return new ClassFinder(classes);
    }

    private List<URL> getTldFiles(WebAppType webApp, WebModule webModule) throws DeploymentException {
        JspConfigType[] jspConfigs;
        log.debug((Object)("getTldFiles( " + webApp.toString() + "," + webModule.getName() + " ): Entry"));
        ArrayList<URL> tldURLs = new ArrayList<URL>();
        for (JspConfigType jspConfig : jspConfigs = webApp.getJspConfigArray()) {
            TaglibType[] taglibs;
            for (TaglibType taglib : taglibs = jspConfig.getTaglibArray()) {
                String uri = taglib.getTaglibUri().getStringValue().trim();
                String location = taglib.getTaglibLocation().getStringValue().trim();
                if (location.equals("")) continue;
                if (location.startsWith("/")) {
                    location = location.substring(1);
                }
                try {
                    File targetFile = webModule.getEarContext().getTargetFile(this.createURI(location));
                    if (targetFile == null) continue;
                    tldURLs.add(targetFile.toURL());
                }
                catch (MalformedURLException mfe) {
                    throw new DeploymentException("Could not locate TLD file specified in <taglib>: URI: " + uri + " Location: " + location + " " + mfe.getMessage(), (Throwable)mfe);
                }
                catch (URISyntaxException use) {
                    throw new DeploymentException("Could not locate TLD file specified in <taglib>: URI: " + uri + " Location: " + location + " " + use.getMessage(), (Throwable)use);
                }
            }
        }
        List<URL> tempURLs = this.scanModule(webModule);
        for (URL webInfURL : tempURLs) {
            tldURLs.add(webInfURL);
        }
        tempURLs.clear();
        try {
            Enumeration<URL> enumURLs = webModule.getEarContext().getClassLoader().getResources("META-INF");
            while (enumURLs.hasMoreElements()) {
                URL enumURL = enumURLs.nextElement();
                tempURLs = this.scanDirectory(enumURL);
                for (URL metaInfURL : tempURLs) {
                    tldURLs.add(metaInfURL);
                }
                tempURLs.clear();
            }
        }
        catch (IOException ioe) {
            throw new DeploymentException("Could not locate TLD files located in META-INF(s) " + ioe.getMessage(), (Throwable)ioe);
        }
        log.debug((Object)("getTldFiles() Exit: URL[" + tldURLs.size() + "]: " + ((Object)tldURLs).toString()));
        return tldURLs;
    }

    private List<URL> scanModule(WebModule webModule) throws DeploymentException {
        log.debug((Object)("scanModule( " + webModule.getName() + " ): Entry"));
        ArrayList<URL> modURLs = new ArrayList<URL>();
        try {
            Enumeration<JarEntry> entries = webModule.getModuleFile().entries();
            while (entries.hasMoreElements()) {
                File targetFile;
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.getName().startsWith("WEB-INF/") && jarEntry.getName().endsWith(".tld") && (targetFile = webModule.getEarContext().getTargetFile(this.createURI(jarEntry.getName()))) != null) {
                    modURLs.add(targetFile.toURL());
                }
                if (!jarEntry.getName().startsWith("WEB-INF/lib/") || !jarEntry.getName().endsWith(".jar")) continue;
                targetFile = webModule.getEarContext().getTargetFile(this.createURI(jarEntry.getName()));
                List<URL> jarUrls = this.scanJAR(new JarFile(targetFile), null);
                for (URL jarURL : jarUrls) {
                    modURLs.add(jarURL);
                }
            }
        }
        catch (IOException ioe) {
            throw new DeploymentException("Could not scan module for TLD files: " + webModule.getName() + " " + ioe.getMessage(), (Throwable)ioe);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not scan module for TLD files: " + webModule.getName() + " " + e.getMessage(), (Throwable)e);
        }
        log.debug((Object)("scanModule() Exit: URL[" + modURLs.size() + "]: " + ((Object)modURLs).toString()));
        return modURLs;
    }

    private List<URL> scanJAR(JarFile jarFile, String prefix) throws DeploymentException {
        log.debug((Object)("scanJAR( " + jarFile.getName() + " ): Entry"));
        ArrayList<URL> jarURLs = new ArrayList<URL>();
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                URL tempURL = null;
                if (prefix != null) {
                    if (jarEntry.getName().endsWith(".tld") && jarEntry.getName().startsWith(prefix)) {
                        tempURL = new URL("jar:file:" + jarFile.getName() + "!/" + jarEntry.getName());
                    }
                } else if (jarEntry.getName().endsWith(".tld")) {
                    tempURL = new URL("jar:file:" + jarFile.getName() + "!/" + jarEntry.getName());
                }
                if (tempURL == null) continue;
                jarURLs.add(tempURL);
            }
        }
        catch (MalformedURLException mfe) {
            throw new DeploymentException("Could not scan JAR file for TLD files: " + jarFile.getName() + " " + mfe.getMessage(), (Throwable)mfe);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not scan JAR file for TLD files: " + jarFile.getName() + " " + e.getMessage(), (Throwable)e);
        }
        log.debug((Object)("scanJAR() Exit: URL[" + jarURLs.size() + "]: " + ((Object)jarURLs).toString()));
        return jarURLs;
    }

    /*
     * Unable to fully structure code
     */
    private List<URL> scanDirectory(URL url) throws DeploymentException {
        JspModuleBuilderExtension.log.debug((Object)("scanDirectory( " + url.toString() + " ): Entry"));
        dirURLs = new ArrayList<URL>();
        if (url != null) {
            if (url.toString().startsWith("jar:file:")) {
                try {
                    jarConnection = (JarURLConnection)url.openConnection();
                    urlJC = jarConnection.getJarFileURL();
                    baseURI = this.createURI(urlJC.toString());
                    directory = new File(baseURI);
                    if (!directory.isDirectory()) ** GOTO lbl40
                    if (directory.canRead()) {
                        temp = new JarFile(directory);
                        tempURLs = this.scanJAR(temp, "META-INF");
                        for (URL jarURL : tempURLs) {
                            dirURLs.add(jarURL);
                        }
                    }
                    JspModuleBuilderExtension.log.warn((Object)("Cannot read JAR file: " + url.toString()));
                }
                catch (Exception e) {
                    throw new DeploymentException("Could not scan directory for TLD files: " + url.toString() + " " + e.getMessage(), (Throwable)e);
                }
            } else if (url.toString().startsWith("file:")) {
                try {
                    baseURI = this.createURI(url.toString());
                    directory = new File(baseURI);
                    if (directory.isDirectory() && directory.canRead()) {
                        for (File child : children = directory.listFiles()) {
                            if (!child.getName().endsWith(".tld")) continue;
                            dirURLs.add(child.toURL());
                        }
                    }
                    JspModuleBuilderExtension.log.warn((Object)("Cannot read directory: " + url.toString()));
                }
                catch (Exception e) {
                    throw new DeploymentException("Could not scan directory for TLD files: " + url.toString() + " " + e.getMessage(), (Throwable)e);
                }
            } else if (url.toString().startsWith("jar:")) {
                JspModuleBuilderExtension.log.warn((Object)("URL type not accounted for: " + url.toString()));
            }
        }
lbl40:
        // 10 sources

        JspModuleBuilderExtension.log.debug((Object)("scanDirectory() Exit: URL[" + dirURLs.size() + "]: " + dirURLs.toString()));
        return dirURLs;
    }

    private List<Class> getListenerClasses(WebAppType webApp, WebModule webModule, List<URL> urls, Set<String> listenerNames) throws DeploymentException {
        log.debug((Object)("getListenerClasses( " + webApp.toString() + "," + '\n' + webModule.getName() + " ): Entry"));
        ClassLoader classLoader = webModule.getEarContext().getClassLoader();
        ArrayList<Class> classes = new ArrayList<Class>();
        for (URL url : urls) {
            this.parseTldFile(url, classLoader, classes, listenerNames);
        }
        log.debug((Object)("getListenerClasses() Exit: Classes[" + classes.size() + "]: " + ((Object)classes).toString()));
        return classes;
    }

    private void parseTldFile(URL url, ClassLoader classLoader, List<Class> classes, Set<String> listenerNames) throws DeploymentException {
        log.debug((Object)("parseTLDFile( " + url.toString() + " ): Entry"));
        try {
            TagType[] tags;
            ListenerType[] listeners;
            XmlObject xml = XmlBeansUtil.parse((URL)url, null);
            TaglibDocument tld = JspModuleBuilderExtension.convertToTaglibSchema(xml);
            TldTaglibType tl = tld.getTaglib();
            for (ListenerType listener : listeners = tl.getListenerArray()) {
                FullyQualifiedClassType cls = listener.getListenerClass();
                String className = cls.getStringValue().trim();
                listenerNames.add(className);
                try {
                    Class<?> clas = classLoader.loadClass(className);
                    classes.add(clas);
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("JspModuleBuilderExtension: Could not load listener class: " + className + " mentioned in TLD file at " + url.toString()));
                }
            }
            for (TagType tag : tags = tl.getTagArray()) {
                FullyQualifiedClassType cls = tag.getTagClass();
                String className = cls.getStringValue().trim();
                try {
                    Class<?> clas = classLoader.loadClass(className);
                    classes.add(clas);
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("JspModuleBuilderExtension: Could not load tag class: " + className + " mentioned in TLD file at " + url.toString()));
                }
            }
        }
        catch (XmlException xmle) {
            throw new DeploymentException("Could not parse TLD file at " + url.toString(), (Throwable)xmle);
        }
        catch (IOException ioe) {
            throw new DeploymentException("Could not find TLD file at " + url.toString(), (Throwable)ioe);
        }
        log.debug((Object)"parseTLDFile(): Exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static TaglibDocument convertToTaglibSchema(XmlObject xmlObject) throws XmlException {
        log.debug((Object)("convertToTaglibSchema( " + xmlObject.toString() + " ): Entry"));
        XmlCursor cursor = xmlObject.newCursor();
        XmlCursor moveable = xmlObject.newCursor();
        try {
            String name;
            cursor.toStartDoc();
            cursor.toFirstChild();
            if ("http://java.sun.com/xml/ns/javaee".equals(cursor.getName().getNamespaceURI())) {
                log.debug((Object)"Nothing to do");
            } else if ("http://java.sun.com/xml/ns/j2ee".equals(cursor.getName().getNamespaceURI())) {
                log.debug((Object)"Converting XSD 2.0 to 2.1 schema");
                SchemaConversionUtils.convertSchemaVersion((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)SCHEMA_LOCATION_URL, (String)VERSION);
                cursor.toStartDoc();
                cursor.toChild("http://java.sun.com/xml/ns/javaee", "taglib");
                cursor.toFirstChild();
                do {
                    if (!"tag".equals(name = cursor.getName().getLocalPart())) continue;
                    cursor.push();
                    cursor.toFirstChild();
                    SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                    do {
                        name = cursor.getName().getLocalPart();
                        boolean rtexprvalueFound = false;
                        boolean typeFound = false;
                        if (!"attribute".equals(name)) continue;
                        cursor.push();
                        cursor.toFirstChild();
                        do {
                            if ("rtexprvalue".equals(name = cursor.getName().getLocalPart())) {
                                rtexprvalueFound = true;
                            }
                            if (!"type".equals(name)) continue;
                            typeFound = true;
                        } while (cursor.toNextSibling());
                        cursor.pop();
                        if (typeFound && !rtexprvalueFound) {
                            cursor.push();
                            cursor.toFirstChild();
                            cursor.insertElementWithText("rtexprvalue", "http://java.sun.com/xml/ns/javaee", "false");
                            cursor.pop();
                        }
                        cursor.push();
                        cursor.toFirstChild();
                        SchemaConversionUtils.convertToTldAttribute((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                        cursor.pop();
                    } while (cursor.toNextSibling());
                    cursor.pop();
                    SchemaConversionUtils.convertToTldTag((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                } while (cursor.toNextSibling());
            } else {
                log.debug((Object)"Converting DTD to 2.1 schema");
                SchemaConversionUtils.convertToSchema((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)SCHEMA_LOCATION_URL, (String)VERSION);
                cursor.toStartDoc();
                cursor.toChild("http://java.sun.com/xml/ns/javaee", "taglib");
                cursor.toFirstChild();
                SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                do {
                    if ("jsp-version".equals(name = cursor.getName().getLocalPart()) || "jspversion".equals(name) || "info".equals(name)) {
                        cursor.removeXmlContents();
                        cursor.removeXml();
                    }
                    if ("tlibversion".equals(name)) {
                        cursor.setName(TLIB_VERSION);
                    }
                    if ("tlibversion".equals(name)) {
                        cursor.setName(TLIB_VERSION);
                    }
                    if ("shortname".equals(name)) {
                        cursor.setName(SHORT_NAME);
                    }
                    if ("tag".equals(name)) {
                        cursor.push();
                        cursor.toFirstChild();
                        SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                        boolean bodyContentFound = false;
                        do {
                            if ("tagclass".equals(name = cursor.getName().getLocalPart())) {
                                cursor.setName(TAG_CLASS);
                            }
                            if ("teiclass".equals(name)) {
                                cursor.setName(TEI_CLASS);
                            }
                            if ("bodycontent".equals(name)) {
                                cursor.setName(BODY_CONTENT);
                                bodyContentFound = true;
                            }
                            if ("body-content".equals(name)) {
                                bodyContentFound = true;
                            }
                            if ("attribute".equals(name)) {
                                cursor.push();
                                cursor.toFirstChild();
                                SchemaConversionUtils.convertToTldAttribute((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                                cursor.pop();
                            }
                            if ("variable".equals(name)) {
                                cursor.push();
                                cursor.toFirstChild();
                                SchemaConversionUtils.convertToTldVariable((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                                cursor.pop();
                            }
                            if (!"info".equals(name)) continue;
                            cursor.removeXmlContents();
                            cursor.removeXml();
                        } while (cursor.toNextSibling());
                        cursor.pop();
                        if (!bodyContentFound) {
                            cursor.push();
                            cursor.toFirstChild();
                            cursor.insertElementWithText("body-content", "http://java.sun.com/xml/ns/javaee", "scriptless");
                            cursor.pop();
                        }
                        cursor.push();
                        cursor.toFirstChild();
                        SchemaConversionUtils.convertToTldTag((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                        cursor.pop();
                    }
                    if (!"validator".equals(name)) continue;
                    cursor.push();
                    cursor.toFirstChild();
                    SchemaConversionUtils.convertToTldValidator((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                    do {
                        if (!"init-param".equals(name = cursor.getName().getLocalPart())) continue;
                        cursor.push();
                        cursor.toFirstChild();
                        SchemaConversionUtils.convertToTldInitParam((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                        cursor.pop();
                    } while (cursor.toNextSibling());
                    cursor.pop();
                } while (cursor.toNextSibling());
            }
        }
        finally {
            cursor.dispose();
            moveable.dispose();
        }
        XmlObject result = xmlObject.changeType(TaglibDocument.type);
        if (result != null) {
            try {
                XmlBeansUtil.validateDD((XmlObject)result);
            }
            catch (XmlException e) {
                log.warn((Object)"Invalid transformed taglib", (Throwable)e);
            }
            log.debug((Object)("convertToTaglibSchema( " + result.toString() + " ): Exit 1"));
            return (TaglibDocument)result;
        }
        try {
            XmlBeansUtil.validateDD((XmlObject)xmlObject);
        }
        catch (XmlException e) {
            log.warn((Object)"Invalid transformed taglib", (Throwable)e);
        }
        log.debug((Object)("convertToTaglibSchema( " + xmlObject.toString() + " ): Exit 2"));
        return (TaglibDocument)xmlObject;
    }

    private URI createURI(String path) throws URISyntaxException {
        path = path.replaceAll(" ", "%20");
        return new URI(path);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(JspModuleBuilderExtension.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addReference("NamingBuilders", NamingBuilder.class, "ModuleBuilder");
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "NamingBuilders"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

