/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.j2eeobjectnames;

import javax.management.ObjectName;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;

public class J2eeContextImpl
implements J2eeContext {
    private final String domainName;
    private final String serverName;
    private final String applicationName;
    private final String moduleType;
    private final String moduleName;
    private final String j2eeName;
    private final String j2eeType;

    public J2eeContextImpl(String domainName, String serverName, String applicationName, String moduleType, String moduleName, String j2eeName, String j2eeType) {
        this.domainName = domainName;
        this.serverName = serverName;
        this.applicationName = applicationName;
        this.moduleType = moduleType;
        this.moduleName = moduleName;
        this.j2eeName = j2eeName;
        this.j2eeType = j2eeType;
    }

    public static J2eeContextImpl newContext(ObjectName source, String moduleType) {
        return new J2eeContextImpl(source.getDomain(), source.getKeyProperty("J2EEServer"), source.getKeyProperty("J2EEApplication"), moduleType, source.getKeyProperty(moduleType), source.getKeyProperty("name"), source.getKeyProperty("j2eeType"));
    }

    public static J2eeContextImpl newModuleContext(ObjectName source, String moduleType) {
        return new J2eeContextImpl(source.getDomain(), source.getKeyProperty("J2EEServer"), source.getKeyProperty("J2EEApplication"), moduleType, source.getKeyProperty("name"), source.getKeyProperty("name"), source.getKeyProperty("j2eeType"));
    }

    public static J2eeContextImpl newModuleContextFromApplication(ObjectName source, String moduleType, String moduleName) {
        return new J2eeContextImpl(source.getDomain(), source.getKeyProperty("J2EEServer"), source.getKeyProperty("name"), moduleType, moduleName, null, null);
    }

    public static J2eeContextImpl newModuleContextFromApplication(J2eeContext source, String moduleType, String moduleName) {
        return new J2eeContextImpl(source.getJ2eeDomainName(), source.getJ2eeServerName(), source.getJ2eeApplicationName(), moduleType, moduleName, null, null);
    }

    @Override
    public String getJ2eeDomainName() {
        return this.domainName;
    }

    @Override
    public String getJ2eeServerName() {
        return this.serverName;
    }

    @Override
    public String getJ2eeApplicationName() {
        return this.applicationName;
    }

    @Override
    public String getJ2eeModuleType() {
        return this.moduleType;
    }

    @Override
    public String getJ2eeModuleName() {
        return this.moduleName;
    }

    @Override
    public String getJ2eeName() {
        return this.j2eeName;
    }

    @Override
    public String getJ2eeType() {
        return this.j2eeType;
    }

    @Override
    public String getJ2eeDomainName(String override) {
        return override == null ? this.domainName : override;
    }

    @Override
    public String getJ2eeServerName(String override) {
        return override == null ? this.serverName : override;
    }

    @Override
    public String getJ2eeApplicationName(String override) {
        return override == null ? this.applicationName : override;
    }

    @Override
    public String getJ2eeModuleType(String override) {
        return override == null ? this.moduleType : override;
    }

    @Override
    public String getJ2eeModuleName(String override) {
        return override == null ? this.moduleName : override;
    }

    @Override
    public String getJ2eeName(String override) {
        return override == null ? this.j2eeName : override;
    }

    @Override
    public String getJ2eeType(String override) {
        return override == null ? this.j2eeType : override;
    }
}

