/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.schema;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.schema.ElementConverter;
import org.apache.geronimo.schema.GBeanElementConverter;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.schema.PersistenceElementConverter;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class SchemaConversionUtils {
    public static final String J2EE_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    static final String GERONIMO_NAMING_NAMESPACE = "http://geronimo.apache.org/xml/ns/naming-1.2";
    private static final String GERONIMO_SERVICE_NAMESPACE = "http://geronimo.apache.org/xml/ns/deployment-1.2";
    public static final String JPA_PERSISTENCE_NAMESPACE = "http://java.sun.com/xml/ns/persistence";
    private static final Map<String, ElementConverter> GERONIMO_SCHEMA_CONVERSIONS = new HashMap<String, ElementConverter>();

    private SchemaConversionUtils() {
    }

    public static void registerNamespaceConversions(Map<String, ? extends ElementConverter> conversions) {
        GERONIMO_SCHEMA_CONVERSIONS.putAll(conversions);
    }

    public static void unregisterNamespaceConversions(Map<String, ? extends ElementConverter> conversions) {
        GERONIMO_SCHEMA_CONVERSIONS.keySet().removeAll(conversions.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertToGeronimoSubSchemas(XmlCursor cursor) {
        cursor.toStartDoc();
        XmlCursor end = cursor.newCursor();
        try {
            while (cursor.hasNextToken()) {
                SchemaConversionUtils.convertSingleElementToGeronimoSubSchemas(cursor, end);
                cursor.toNextToken();
            }
        }
        finally {
            end.dispose();
        }
    }

    public static boolean convertSingleElementToGeronimoSubSchemas(XmlCursor cursor, XmlCursor end) {
        if (cursor.isStart()) {
            String localName = cursor.getName().getLocalPart();
            ElementConverter converter = GERONIMO_SCHEMA_CONVERSIONS.get(localName);
            if (converter != null) {
                converter.convertElement(cursor, end);
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlObject fixGeronimoSchema(XmlObject rawPlan, QName desiredElement, SchemaType desiredType) throws XmlException {
        XmlCursor cursor = rawPlan.newCursor();
        try {
            if (SchemaConversionUtils.findNestedElement(cursor, desiredElement)) {
                cursor.push();
                SchemaConversionUtils.convertToGeronimoSubSchemas(cursor);
                cursor.pop();
                XmlObject temp = cursor.getObject();
                XmlObject result = temp.changeType(desiredType);
                if (result == null || result.schemaType() != desiredType) {
                    result = temp.copy().changeType(desiredType);
                }
                XmlBeansUtil.validateDD((XmlObject)result);
                XmlObject xmlObject = result;
                return xmlObject;
            }
            XmlObject xmlObject = null;
            return xmlObject;
        }
        finally {
            cursor.dispose();
        }
    }

    public static boolean findNestedElement(XmlCursor cursor, QName desiredElement) {
        while (cursor.hasNextToken()) {
            QName element;
            if (cursor.isStart() && (element = cursor.getName()).equals(desiredElement)) {
                return true;
            }
            cursor.toNextToken();
        }
        return false;
    }

    public static boolean findNestedElement(XmlCursor cursor, String desiredElement) {
        while (cursor.hasNextToken()) {
            String element;
            if (cursor.isStart() && (element = cursor.getName().getLocalPart()).equals(desiredElement)) {
                return true;
            }
            cursor.toNextToken();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlObject getNestedObjectAsType(XmlObject xmlObject, QName desiredElement, SchemaType type) {
        XmlCursor cursor = xmlObject.newCursor();
        try {
            if (SchemaConversionUtils.findNestedElement(cursor, desiredElement)) {
                XmlObject child = cursor.getObject();
                XmlObject result = child.copy().changeType(type);
                assert (result.schemaType() == type);
                XmlObject xmlObject2 = result;
                return xmlObject2;
            }
        }
        finally {
            cursor.dispose();
        }
        throw new IllegalArgumentException("xmlobject did not have desired element: " + desiredElement + "\n" + xmlObject);
    }

    public static boolean convertSchemaVersion(XmlCursor start, XmlCursor end, String namespace, String schemaLocationURL, String version) {
        boolean isFirstStart = true;
        end.toCursor(start);
        end.toEndToken();
        while (start.hasNextToken() && start.isLeftOf(end)) {
            if (start.isStart()) {
                if (isFirstStart) {
                    if (start.getAttributeText(new QName("xmlns")) != null) {
                        start.removeAttribute(new QName("xmlns"));
                    }
                    start.setAttributeText(new QName("version"), version);
                    start.setAttributeText(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "xsi"), namespace + "  " + schemaLocationURL);
                    isFirstStart = false;
                }
                start.setName(new QName(namespace, start.getName().getLocalPart()));
                start.toNextToken();
                continue;
            }
            start.toNextToken();
        }
        return true;
    }

    public static void convertToDescriptionGroup(String namespace, XmlCursor cursor, XmlCursor moveable) {
        moveable.toCursor(cursor);
        SchemaConversionUtils.moveElements("description", namespace, moveable, cursor);
        SchemaConversionUtils.moveElements("display-name", namespace, moveable, cursor);
        SchemaConversionUtils.moveElements("icon", namespace, moveable, cursor);
    }

    public static void convertToJNDIEnvironmentRefsGroup(String namespace, XmlCursor cursor, XmlCursor moveable) {
        SchemaConversionUtils.moveElements("env-entry", namespace, moveable, cursor);
        SchemaConversionUtils.moveElements("ejb-ref", namespace, moveable, cursor);
        SchemaConversionUtils.moveElements("ejb-local-ref", namespace, moveable, cursor);
        SchemaConversionUtils.moveElements("resource-ref", namespace, moveable, cursor);
        SchemaConversionUtils.moveElements("resource-env-ref", namespace, moveable, cursor);
        SchemaConversionUtils.moveElements("message-destination-ref", namespace, moveable, cursor);
        do {
            String name;
            if (!"env-entry".equals(name = cursor.getName().getLocalPart())) continue;
            cursor.push();
            cursor.toFirstChild();
            SchemaConversionUtils.convertToDescriptionGroup(namespace, cursor, moveable);
            SchemaConversionUtils.convertToEnvEntryGroup(namespace, cursor, moveable);
            cursor.pop();
        } while (cursor.toPrevSibling());
    }

    public static void convertToEnvEntryGroup(String namespace, XmlCursor cursor, XmlCursor moveable) {
        SchemaConversionUtils.moveElements("env-entry-name", namespace, moveable, cursor);
        SchemaConversionUtils.moveElements("env-entry-type", namespace, moveable, cursor);
        SchemaConversionUtils.moveElements("env-entry-value", namespace, moveable, cursor);
    }

    private static void moveElements(String localName, String namespace, XmlCursor moveable, XmlCursor toHere) {
        QName name = new QName(namespace, localName);
        while (name.equals(toHere.getName()) && toHere.toNextSibling()) {
        }
        moveable.toCursor(toHere);
        while (moveable.toNextSibling(name)) {
            moveable.moveXml(toHere);
        }
    }

    static {
        GERONIMO_SCHEMA_CONVERSIONS.put("gbean-ref", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("ejb-ref", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("ejb-local-ref", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("service-ref", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("resource-ref", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("resource-env-ref", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("message-destination", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("cmp-connection-factory", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("workmanager", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("resource-adapter", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("web-container", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("env-entry", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("gbean", new GBeanElementConverter());
        GERONIMO_SCHEMA_CONVERSIONS.put("environment", new NamespaceElementConverter(GERONIMO_SERVICE_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("client-environment", new NamespaceElementConverter(GERONIMO_SERVICE_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("server-environment", new NamespaceElementConverter(GERONIMO_SERVICE_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("persistence", new PersistenceElementConverter("2.0"));
    }
}

