/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.net.URI;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.Deployable;
import org.apache.geronimo.deployment.DeployableJarFile;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.j2ee.deployment.AppClientModule;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.FragmentContext;
import org.apache.geronimo.j2ee.jndi.JndiKey;
import org.apache.geronimo.j2ee.jndi.JndiScope;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.xbean.finder.AbstractFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Module<T, U> {
    private static final Logger log = LoggerFactory.getLogger(Module.class);
    private final boolean standAlone;
    private final AbstractName moduleName;
    private final String name;
    private final Environment environment;
    private final URI moduleURI;
    private final Deployable deployable;
    private final String targetPath;
    private final URI targetPathURI;
    private final U vendorDD;
    private final String namespace;
    private EARContext earContext;
    private EARContext rootEarContext;
    private T specDD;
    private String originalSpecDD;
    private AbstractFinder classFinder;
    private final Map<AbstractName, GBeanData> gbeans = new LinkedHashMap<AbstractName, GBeanData>();
    protected final Map sharedContext = new HashMap();
    protected final LinkedHashSet<Module<?, ?>> modules;
    protected final LinkedHashSet<String> moduleLocations;
    protected final LinkedHashSet<String> classpath;
    private final Map<JndiKey, Map<String, Object>> jndiContext;
    private final Module<?, ?> parentModule;
    protected int priority = 5;
    public static final EnumSet<JndiScope> APP = EnumSet.of(JndiScope.global, JndiScope.app);
    public static final EnumSet<JndiScope> MODULE = EnumSet.of(JndiScope.global, JndiScope.app, JndiScope.module);

    protected Module(boolean standAlone, AbstractName moduleName, String name, Environment environment, JarFile moduleFile, String targetPath, T specDD, U vendorDD, String originalSpecDD, String namespace, Map<JndiKey, Map<String, Object>> jndiContext, Module<?, ?> parentModule) {
        this(standAlone, moduleName, name, environment, (Deployable)new DeployableJarFile(moduleFile), targetPath, specDD, vendorDD, originalSpecDD, namespace, jndiContext, parentModule);
    }

    protected Module(boolean standAlone, AbstractName moduleName, String name, Environment environment, Deployable deployable, String targetPath, T specDD, U vendorDD, String originalSpecDD, String namespace, Map<JndiKey, Map<String, Object>> jndiContext, Module<?, ?> parentModule) {
        assert (targetPath != null) : "targetPath is null";
        assert (moduleName != null) : "moduleName is null";
        this.standAlone = standAlone;
        this.moduleName = moduleName;
        this.environment = environment;
        this.deployable = deployable;
        this.targetPath = targetPath;
        this.specDD = specDD;
        this.vendorDD = vendorDD;
        this.originalSpecDD = originalSpecDD;
        this.namespace = namespace;
        if (standAlone) {
            this.name = name == null ? environment.getConfigId().toString() : name;
            this.moduleURI = URI.create("");
        } else {
            this.name = name == null ? targetPath : name;
            this.moduleURI = URI.create(targetPath);
        }
        this.targetPathURI = URI.create(targetPath + "/");
        this.moduleLocations = new LinkedHashSet();
        this.modules = new LinkedHashSet();
        this.classpath = new LinkedHashSet();
        this.jndiContext = jndiContext != null ? jndiContext : Module.assure(new HashMap<JndiKey, Map<String, Object>>());
        this.parentModule = parentModule;
    }

    public abstract ConfigurationModuleType getType();

    public String getName() {
        return this.name;
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public AbstractName getModuleName() {
        return this.moduleName;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public URI getModuleURI() {
        return this.moduleURI;
    }

    public JarFile getModuleFile() {
        if (this.deployable instanceof DeployableJarFile) {
            return ((DeployableJarFile)this.deployable).getJarFile();
        }
        throw new RuntimeException("getModuleFile() is not supported on Bundle-based deployment");
    }

    public Deployable getDeployable() {
        return this.deployable;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public URI getTargetPathURI() {
        return this.targetPathURI;
    }

    public URI resolve(String path) {
        URI resultURI;
        block4: {
            resultURI = null;
            try {
                resultURI = this.targetPathURI.resolve(path);
            }
            catch (Exception e) {
                log.warn("Exception=" + e + "; Cause=" + e.getCause());
                if (!(e instanceof IllegalArgumentException)) break block4;
                try {
                    URI substr = new URI(null, path, null);
                    resultURI = this.targetPathURI.resolve(substr);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Exception=" + ex + "; Cause=" + ex.getCause());
                }
            }
        }
        return resultURI;
    }

    public URI resolve(URI path) {
        return this.targetPathURI.resolve(path);
    }

    public T getSpecDD() {
        return this.specDD;
    }

    public U getVendorDD() {
        return this.vendorDD;
    }

    public String getOriginalSpecDD() {
        return this.originalSpecDD;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void addGBean(GBeanData gbean) throws GBeanAlreadyExistsException {
        if (this.gbeans.containsKey(gbean.getAbstractName())) {
            throw new GBeanAlreadyExistsException(gbean.getAbstractName().toString());
        }
        this.gbeans.put(gbean.getAbstractName(), gbean);
    }

    public void flushGBeansToContext() throws GBeanAlreadyExistsException {
        for (GBeanData data : this.gbeans.values()) {
            this.earContext.addGBean(data);
        }
        this.gbeans.clear();
    }

    public int hashCode() {
        return this.moduleURI.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Module) {
            Module module = (Module)obj;
            return this.name.equals(module.name);
        }
        return false;
    }

    public void close() {
        this.deployable.close();
    }

    public EARContext getEarContext() {
        return this.earContext;
    }

    public void setEarContext(EARContext earContext) {
        this.earContext = earContext;
    }

    public EARContext getRootEarContext() {
        return this.rootEarContext;
    }

    public void setRootEarContext(EARContext rootEarContext) {
        this.rootEarContext = rootEarContext;
    }

    public Map getSharedContext() {
        return this.sharedContext;
    }

    public void setSpecDD(T specDD) {
        this.specDD = specDD;
    }

    public void setOriginalSpecDD(String originalSpecDD) {
        this.originalSpecDD = originalSpecDD;
    }

    public AbstractFinder getClassFinder() {
        return this.classFinder;
    }

    public void setClassFinder(AbstractFinder classFinder) {
        this.classFinder = classFinder;
    }

    public Artifact[] getConfigId() {
        if (this.earContext == null) {
            throw new NullPointerException("No ear context set");
        }
        if (this.rootEarContext == null || this.rootEarContext == this.earContext || this.rootEarContext.getConfigID().equals((Object)this.earContext.getConfigID())) {
            return new Artifact[]{this.earContext.getConfigID()};
        }
        return new Artifact[]{this.rootEarContext.getConfigID(), this.earContext.getConfigID()};
    }

    public String getRelativePath(String path) {
        return path;
    }

    public void addAsChildConfiguration() throws DeploymentException {
        if (this.rootEarContext != null && this.rootEarContext != this.earContext && !(this.earContext instanceof FragmentContext)) {
            ConfigurationData moduleConfigurationData = this.earContext.getConfigurationData();
            this.rootEarContext.addChildConfiguration(this.getTargetPath(), moduleConfigurationData);
        }
    }

    public LinkedHashSet<Module<?, ?>> getModules() {
        return this.modules;
    }

    public LinkedHashSet<String> getModuleLocations() {
        return this.moduleLocations;
    }

    public LinkedHashSet<String> getClassPath() {
        return this.classpath;
    }

    public void accumulateClassPath() {
        this.earContext.getBundleClassPath().addAll(this.classpath);
        for (Module module : this.modules) {
            module.accumulateClassPath();
        }
    }

    public Map<JndiKey, Map<String, Object>> getJndiContext() {
        return this.jndiContext;
    }

    public Map<String, Object> getJndiScope(JndiKey scope) {
        return this.jndiContext.get(scope);
    }

    public Module<?, ?> getParentModule() {
        return this.parentModule;
    }

    public static Map<JndiKey, Map<String, Object>> share(EnumSet<JndiScope> scopes, Map<JndiKey, Map<String, Object>> jndiContext) {
        HashMap<JndiKey, Map<String, Object>> newContext = new HashMap<JndiKey, Map<String, Object>>();
        if (jndiContext != null) {
            for (JndiScope scope : scopes) {
                Map<String, Object> scopedContext = jndiContext.get(scope);
                if (scopedContext == null) continue;
                newContext.put((JndiKey)scope, scopedContext);
            }
        }
        return Module.assure(newContext);
    }

    public static Map<JndiKey, Map<String, Object>> assure(Map<JndiKey, Map<String, Object>> jndiContext) {
        for (JndiScope scope : JndiScope.values()) {
            if (jndiContext.get(scope) != null) continue;
            jndiContext.put((JndiKey)scope, new HashMap());
        }
        return jndiContext;
    }

    public static class AppClientModuleLastComparator
    implements Comparator<Module<?, ?>> {
        @Override
        public int compare(Module<?, ?> m1, Module<?, ?> m2) {
            boolean m1AppClientModule = m1 instanceof AppClientModule;
            boolean m2AppClientModule = m2 instanceof AppClientModule;
            if (m1AppClientModule && m2AppClientModule) {
                return 0;
            }
            if (m1AppClientModule) {
                return 1;
            }
            if (m2AppClientModule) {
                return -1;
            }
            return 0;
        }
    }

    public static class ModulePriorityComparator
    implements Comparator<Module<?, ?>> {
        @Override
        public int compare(Module<?, ?> m1, Module<?, ?> m2) {
            return m1.priority - m2.priority;
        }
    }
}

