/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceContexts;
import javax.persistence.PersistenceProperty;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotationHelper;
import org.apache.geronimo.xbeans.javaee.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee.JndiNameType;
import org.apache.geronimo.xbeans.javaee.PersistenceContextRefType;
import org.apache.geronimo.xbeans.javaee.PersistenceContextTypeType;
import org.apache.geronimo.xbeans.javaee.PropertyType;
import org.apache.geronimo.xbeans.javaee.String;
import org.apache.geronimo.xbeans.javaee.XsdStringType;
import org.apache.xbean.finder.ClassFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistenceContextAnnotationHelper
extends AnnotationHelper {
    private static final Logger log = LoggerFactory.getLogger(PersistenceContextAnnotationHelper.class);

    private PersistenceContextAnnotationHelper() {
    }

    public static void processAnnotations(AnnotatedApp annotatedApp, ClassFinder classFinder) throws DeploymentException {
        if (annotatedApp != null) {
            if (classFinder.isAnnotationPresent(PersistenceContexts.class)) {
                PersistenceContextAnnotationHelper.processPersistenceContexts(annotatedApp, classFinder);
            }
            if (classFinder.isAnnotationPresent(PersistenceContext.class)) {
                PersistenceContextAnnotationHelper.processPersistenceContext(annotatedApp, classFinder);
            }
        }
    }

    private static void processPersistenceContext(AnnotatedApp annotatedApp, ClassFinder classFinder) throws DeploymentException {
        PersistenceContext persistenceContext;
        log.debug("processPersistenceContext(): Entry: AnnotatedApp: " + ((Object)annotatedApp).toString());
        List classeswithPersistenceContext = classFinder.findAnnotatedClasses(PersistenceContext.class);
        List methodswithPersistenceContext = classFinder.findAnnotatedMethods(PersistenceContext.class);
        List fieldswithPersistenceContext = classFinder.findAnnotatedFields(PersistenceContext.class);
        for (Class cls : classeswithPersistenceContext) {
            persistenceContext = cls.getAnnotation(PersistenceContext.class);
            if (persistenceContext == null) continue;
            PersistenceContextAnnotationHelper.addPersistenceContext(annotatedApp, persistenceContext, cls, null, null);
        }
        for (Method method : methodswithPersistenceContext) {
            persistenceContext = method.getAnnotation(PersistenceContext.class);
            if (persistenceContext == null) continue;
            PersistenceContextAnnotationHelper.addPersistenceContext(annotatedApp, persistenceContext, null, method, null);
        }
        for (Field field : fieldswithPersistenceContext) {
            persistenceContext = field.getAnnotation(PersistenceContext.class);
            if (persistenceContext == null) continue;
            PersistenceContextAnnotationHelper.addPersistenceContext(annotatedApp, persistenceContext, null, null, field);
        }
        PersistenceContextAnnotationHelper.validateDD(annotatedApp);
        log.debug("processPersistenceContext(): Exit: AnnotatedApp: " + ((Object)annotatedApp).toString());
    }

    private static void processPersistenceContexts(AnnotatedApp annotatedApp, ClassFinder classFinder) throws DeploymentException {
        log.debug("processPersistenceContexts(): Entry");
        List classeswithPersistenceContexts = classFinder.findAnnotatedClasses(PersistenceContexts.class);
        ArrayList<PersistenceContext> persistenceContextList = new ArrayList<PersistenceContext>();
        for (Class cls : classeswithPersistenceContexts) {
            PersistenceContexts persistenceContexts = cls.getAnnotation(PersistenceContexts.class);
            if (persistenceContexts != null) {
                persistenceContextList.addAll(Arrays.asList(persistenceContexts.value()));
            }
            for (PersistenceContext persistenceContext : persistenceContextList) {
                PersistenceContextAnnotationHelper.addPersistenceContext(annotatedApp, persistenceContext, cls, null, null);
            }
            persistenceContextList.clear();
        }
        log.debug("processPersistenceContexts(): Exit");
    }

    private static void addPersistenceContext(AnnotatedApp annotatedApp, PersistenceContext annotation, Class cls, Method method, Field field) {
        PersistenceProperty[] properties;
        PersistenceContextTypeType persistenceContextType;
        PersistenceContextRefType[] persistenceContextRefs;
        log.debug("addPersistenceContext( [annotatedApp] " + ((Object)annotatedApp).toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "," + '\n' + "[method] " + (method != null ? method.getName() : null) + "," + '\n' + "[field] " + (field != null ? field.getName() : null) + " ): Entry");
        java.lang.String persistenceContextRefName = PersistenceContextAnnotationHelper.getName(annotation.name(), method, field);
        log.debug("addPersistenceContext(): PersistenceContextRefName: " + persistenceContextRefName);
        for (PersistenceContextRefType persistenceContextRef : persistenceContextRefs = annotatedApp.getPersistenceContextRefArray()) {
            InjectionTargetType[] targets;
            if (!persistenceContextRef.getPersistenceContextRefName().getStringValue().trim().equals(persistenceContextRefName)) continue;
            if (!(method == null && field == null || PersistenceContextAnnotationHelper.hasTarget(method, field, targets = persistenceContextRef.getInjectionTargetArray()))) {
                PersistenceContextAnnotationHelper.configureInjectionTarget(persistenceContextRef.addNewInjectionTarget(), method, field);
            }
            return;
        }
        PersistenceContextRefType persistenceContextRef = annotatedApp.addNewPersistenceContextRef();
        JndiNameType unitRefName = persistenceContextRef.addNewPersistenceContextRefName();
        unitRefName.setStringValue(persistenceContextRefName);
        java.lang.String unitNameAnnotation = annotation.unitName();
        if (!unitNameAnnotation.equals("")) {
            String persistenceUnitName = persistenceContextRef.addNewPersistenceUnitName();
            persistenceUnitName.setStringValue(unitNameAnnotation);
        }
        if (annotation.type() == PersistenceContextType.TRANSACTION) {
            persistenceContextType = persistenceContextRef.addNewPersistenceContextType();
            persistenceContextType.setStringValue("Transaction");
            persistenceContextRef.setPersistenceContextType(persistenceContextType);
        } else if (annotation.type() == PersistenceContextType.EXTENDED) {
            persistenceContextType = persistenceContextRef.addNewPersistenceContextType();
            persistenceContextType.setStringValue("Extended");
            persistenceContextRef.setPersistenceContextType(persistenceContextType);
        }
        for (PersistenceProperty property : properties = annotation.properties()) {
            PropertyType propertyType = persistenceContextRef.addNewPersistenceProperty();
            XsdStringType propertyName = propertyType.addNewName();
            propertyName.setStringValue(property.name());
            XsdStringType propertyValue = propertyType.addNewValue();
            propertyValue.setStringValue(property.value());
        }
        if (method != null || field != null) {
            PersistenceContextAnnotationHelper.configureInjectionTarget(persistenceContextRef.addNewInjectionTarget(), method, field);
        }
    }
}

