/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBs;
import javax.ejb.Local;
import javax.ejb.Remote;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.xbeans.javaee.DescriptionType;
import org.apache.geronimo.xbeans.javaee.EjbLinkType;
import org.apache.geronimo.xbeans.javaee.EjbLocalRefType;
import org.apache.geronimo.xbeans.javaee.EjbRefNameType;
import org.apache.geronimo.xbeans.javaee.EjbRefType;
import org.apache.geronimo.xbeans.javaee.FullyQualifiedClassType;
import org.apache.geronimo.xbeans.javaee.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee.JavaIdentifierType;
import org.apache.geronimo.xbeans.javaee.LocalType;
import org.apache.geronimo.xbeans.javaee.RemoteType;
import org.apache.geronimo.xbeans.javaee.XsdStringType;
import org.apache.xbean.finder.ClassFinder;

public final class EJBAnnotationHelper {
    private static final Log log = LogFactory.getLog(EJBAnnotationHelper.class);

    private EJBAnnotationHelper() {
    }

    public static boolean annotationsPresent(ClassFinder classFinder) {
        if (classFinder.isAnnotationPresent(EJB.class)) {
            return true;
        }
        return classFinder.isAnnotationPresent(EJBs.class);
    }

    public static void processAnnotations(AnnotatedApp annotatedApp, ClassFinder classFinder) throws Exception {
        if (annotatedApp != null) {
            EJBAnnotationHelper.processEJBs(annotatedApp, classFinder);
            EJBAnnotationHelper.processEJB(annotatedApp, classFinder);
        }
    }

    private static void processEJB(AnnotatedApp annotatedApp, ClassFinder classFinder) throws Exception {
        EJB ejb;
        log.debug((Object)("processEJB(): Entry: AnnotatedApp: " + ((Object)annotatedApp).toString()));
        List classesWithEJB = classFinder.findAnnotatedClasses(EJB.class);
        List methodsWithEJB = classFinder.findAnnotatedMethods(EJB.class);
        List fieldsWithEJB = classFinder.findAnnotatedFields(EJB.class);
        for (Class cls : classesWithEJB) {
            ejb = cls.getAnnotation(EJB.class);
            if (ejb == null) continue;
            EJBAnnotationHelper.addEJB(annotatedApp, ejb, cls, null, null);
        }
        for (Method method : methodsWithEJB) {
            ejb = method.getAnnotation(EJB.class);
            if (ejb == null) continue;
            EJBAnnotationHelper.addEJB(annotatedApp, ejb, null, method, null);
        }
        for (Field field : fieldsWithEJB) {
            ejb = field.getAnnotation(EJB.class);
            if (ejb == null) continue;
            EJBAnnotationHelper.addEJB(annotatedApp, ejb, null, null, field);
        }
        EJBAnnotationHelper.validateDD(annotatedApp);
        log.debug((Object)("processEJB(): Exit: AnnotatedApp: " + ((Object)annotatedApp).toString()));
    }

    private static void processEJBs(AnnotatedApp annotatedApp, ClassFinder classFinder) throws Exception {
        log.debug((Object)"processEJBs(): Entry");
        List classesWithEJBs = classFinder.findAnnotatedClasses(EJBs.class);
        ArrayList<EJB> ejbList = new ArrayList<EJB>();
        for (Class cls : classesWithEJBs) {
            EJBs ejbs = cls.getAnnotation(EJBs.class);
            if (ejbs != null) {
                ejbList.addAll(Arrays.asList(ejbs.value()));
            }
            for (EJB ejb : ejbList) {
                EJBAnnotationHelper.addEJB(annotatedApp, ejb, cls, null, null);
            }
            ejbList.clear();
        }
        log.debug((Object)"processEJBs(): Exit");
    }

    private static void addEJB(AnnotatedApp annotatedApp, EJB annotation, Class cls, Method method, Field field) {
        EjbRefType ejbRef;
        String remoteRefName;
        boolean exists;
        log.debug((Object)("addEJB( [annotatedApp] " + ((Object)annotatedApp).toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "," + '\n' + "[method] " + (method != null ? method.getName() : null) + "," + '\n' + "[field] " + (field != null ? field.getName() : null) + " ): Entry"));
        boolean localFlag = false;
        boolean remoteFlag = false;
        Class<Object> interfce = annotation.beanInterface();
        if (interfce.equals(Object.class)) {
            interfce = method != null ? method.getParameterTypes()[0] : (field != null ? field.getType() : null);
        }
        log.debug((Object)("addEJB(): interfce: " + interfce));
        if (interfce != null && !interfce.equals(Object.class)) {
            if (EJBHome.class.isAssignableFrom(interfce)) {
                for (Method m : interfce.getMethods()) {
                    if (!m.getName().startsWith("create")) continue;
                    interfce = m.getReturnType();
                    break;
                }
                remoteFlag = true;
            } else if (EJBLocalHome.class.isAssignableFrom(interfce)) {
                for (Method m : interfce.getMethods()) {
                    if (!m.getName().startsWith("create")) continue;
                    interfce = m.getReturnType();
                    break;
                }
                localFlag = true;
            } else if (interfce.getAnnotation(Local.class) != null) {
                localFlag = true;
            } else if (interfce.getAnnotation(Remote.class) != null) {
                remoteFlag = true;
            }
        }
        log.debug((Object)("addEJB(): localFlag: " + localFlag));
        log.debug((Object)("addEJB(): remoteFlag: " + remoteFlag));
        if (localFlag) {
            EjbLocalRefType[] ejbLocalRefEntries;
            log.debug((Object)"addEJB(): <ejb-local-ref> found");
            String localRefName = annotation.name();
            if (localRefName.equals("")) {
                if (method != null) {
                    localRefName = method.getDeclaringClass().getName() + "/" + method.getName().substring(3);
                } else if (field != null) {
                    localRefName = field.getDeclaringClass().getName() + "/" + field.getName();
                }
            }
            exists = false;
            for (EjbLocalRefType ejbLocalRefType : ejbLocalRefEntries = annotatedApp.getEjbLocalRefArray()) {
                if (!ejbLocalRefType.getEjbRefName().getStringValue().trim().equals(localRefName)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                try {
                    String descriptionAnnotation;
                    String string;
                    String beanName;
                    String localAnnotation;
                    log.debug((Object)("addEJB(): Does not exist in DD: " + localRefName));
                    EjbLocalRefType ejbLocalRef = annotatedApp.addNewEjbLocalRef();
                    EjbRefNameType ejbRefName = ejbLocalRef.addNewEjbRefName();
                    ejbRefName.setStringValue(localRefName);
                    ejbLocalRef.setEjbRefName(ejbRefName);
                    if (interfce != null && !(localAnnotation = interfce.getName()).equals("")) {
                        LocalType localType = ejbLocalRef.addNewLocal();
                        localType.setStringValue(localAnnotation);
                        ejbLocalRef.setLocal(localType);
                    }
                    if (!(beanName = annotation.beanName()).equals("")) {
                        EjbLinkType ejbLinkType = ejbLocalRef.addNewEjbLink();
                        ejbLinkType.setStringValue(beanName);
                        ejbLocalRef.setEjbLink(ejbLinkType);
                    }
                    if (!(string = annotation.mappedName()).equals("")) {
                        XsdStringType mappedName = ejbLocalRef.addNewMappedName();
                        mappedName.setStringValue(string);
                        ejbLocalRef.setMappedName(mappedName);
                    }
                    if (!(descriptionAnnotation = annotation.description()).equals("")) {
                        DescriptionType description = ejbLocalRef.addNewDescription();
                        description.setStringValue(descriptionAnnotation);
                    }
                    if (method != null || field != null) {
                        InjectionTargetType injectionTarget = ejbLocalRef.addNewInjectionTarget();
                        FullyQualifiedClassType qualifiedClass = injectionTarget.addNewInjectionTargetClass();
                        JavaIdentifierType javaType = injectionTarget.addNewInjectionTargetName();
                        if (method != null) {
                            qualifiedClass.setStringValue(method.getDeclaringClass().getName());
                            javaType.setStringValue(method.getName().substring(3));
                            injectionTarget.setInjectionTargetClass(qualifiedClass);
                            injectionTarget.setInjectionTargetName(javaType);
                        } else if (field != null) {
                            qualifiedClass.setStringValue(field.getDeclaringClass().getName());
                            javaType.setStringValue(field.getName());
                            injectionTarget.setInjectionTargetClass(qualifiedClass);
                            injectionTarget.setInjectionTargetName(javaType);
                        }
                    }
                }
                catch (Exception anyException) {
                    log.debug((Object)"EJBAnnotationHelper: Exception caught while processing <ejb-local-ref>");
                    anyException.printStackTrace();
                }
            }
        } else if (remoteFlag) {
            log.debug((Object)"addEJB(): <ejb-ref> found");
            remoteRefName = annotation.name();
            if (remoteRefName.equals("")) {
                if (method != null) {
                    remoteRefName = method.getDeclaringClass().getName() + "/" + method.getName().substring(3);
                } else if (field != null) {
                    remoteRefName = field.getDeclaringClass().getName() + "/" + field.getName();
                }
            }
            exists = false;
            EjbRefType[] ejbRefEntries = annotatedApp.getEjbRefArray();
            for (EjbLocalRefType ejbLocalRefType : ejbRefEntries) {
                if (!ejbLocalRefType.getEjbRefName().getStringValue().trim().equals(remoteRefName)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                try {
                    String descriptionAnnotation;
                    String string;
                    String beanName;
                    String remoteAnnotation;
                    log.debug((Object)("addEJB(): Does not exist in DD: " + remoteRefName));
                    ejbRef = annotatedApp.addNewEjbRef();
                    EjbRefNameType ejbRefName = ejbRef.addNewEjbRefName();
                    ejbRefName.setStringValue(remoteRefName);
                    ejbRef.setEjbRefName(ejbRefName);
                    if (interfce != null && !(remoteAnnotation = interfce.getName()).equals("")) {
                        RemoteType remoteType = ejbRef.addNewRemote();
                        remoteType.setStringValue(remoteAnnotation);
                        ejbRef.setRemote(remoteType);
                    }
                    if (!(beanName = annotation.beanName()).equals("")) {
                        EjbLinkType ejbLinkType = ejbRef.addNewEjbLink();
                        ejbLinkType.setStringValue(beanName);
                        ejbRef.setEjbLink(ejbLinkType);
                    }
                    if (!(string = annotation.mappedName()).equals("")) {
                        XsdStringType mappedName = ejbRef.addNewMappedName();
                        mappedName.setStringValue(string);
                        ejbRef.setMappedName(mappedName);
                    }
                    if (!(descriptionAnnotation = annotation.description()).equals("")) {
                        DescriptionType description = ejbRef.addNewDescription();
                        description.setStringValue(descriptionAnnotation);
                    }
                    if (method != null || field != null) {
                        InjectionTargetType injectionTarget = ejbRef.addNewInjectionTarget();
                        FullyQualifiedClassType qualifiedClass = injectionTarget.addNewInjectionTargetClass();
                        JavaIdentifierType javaType = injectionTarget.addNewInjectionTargetName();
                        if (method != null) {
                            qualifiedClass.setStringValue(method.getDeclaringClass().getName());
                            javaType.setStringValue(method.getName().substring(3));
                            injectionTarget.setInjectionTargetClass(qualifiedClass);
                            injectionTarget.setInjectionTargetName(javaType);
                        } else if (field != null) {
                            qualifiedClass.setStringValue(field.getDeclaringClass().getName());
                            javaType.setStringValue(field.getName());
                            injectionTarget.setInjectionTargetClass(qualifiedClass);
                            injectionTarget.setInjectionTargetName(javaType);
                        }
                    }
                }
                catch (Exception anyException) {
                    log.debug((Object)"EJBAnnotationHelper: Exception caught while processing <ejb-ref>");
                    anyException.printStackTrace();
                }
            }
        } else {
            log.debug((Object)"addEJB(): <UNKNOWN> found");
            remoteRefName = annotation.name();
            if (remoteRefName.equals("")) {
                if (method != null) {
                    remoteRefName = method.getDeclaringClass().getName() + "/" + method.getName().substring(3);
                } else if (field != null) {
                    remoteRefName = field.getDeclaringClass().getName() + "/" + field.getName();
                }
            }
            exists = false;
            EjbRefType[] ejbRefEntries = annotatedApp.getEjbRefArray();
            for (EjbLocalRefType ejbLocalRefType : ejbRefEntries) {
                if (!ejbLocalRefType.getEjbRefName().getStringValue().trim().equals(remoteRefName)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                try {
                    String descriptionAnnotation;
                    String string;
                    String beanName;
                    String remoteAnnotation;
                    log.debug((Object)("addEJB(): Does not exist in DD: " + remoteRefName));
                    ejbRef = EjbRefType.Factory.newInstance();
                    annotatedApp.getAmbiguousEjbRefs().add(ejbRef);
                    EjbRefNameType ejbRefName = ejbRef.addNewEjbRefName();
                    ejbRefName.setStringValue(remoteRefName);
                    ejbRef.setEjbRefName(ejbRefName);
                    if (interfce != null && !(remoteAnnotation = interfce.getName()).equals("")) {
                        RemoteType remoteType = ejbRef.addNewRemote();
                        remoteType.setStringValue(remoteAnnotation);
                        ejbRef.setRemote(remoteType);
                    }
                    if (!(beanName = annotation.beanName()).equals("")) {
                        EjbLinkType ejbLinkType = ejbRef.addNewEjbLink();
                        ejbLinkType.setStringValue(beanName);
                        ejbRef.setEjbLink(ejbLinkType);
                    }
                    if (!(string = annotation.mappedName()).equals("")) {
                        XsdStringType mappedName = ejbRef.addNewMappedName();
                        mappedName.setStringValue(string);
                        ejbRef.setMappedName(mappedName);
                    }
                    if (!(descriptionAnnotation = annotation.description()).equals("")) {
                        DescriptionType description = ejbRef.addNewDescription();
                        description.setStringValue(descriptionAnnotation);
                    }
                    if (method != null || field != null) {
                        InjectionTargetType injectionTarget = ejbRef.addNewInjectionTarget();
                        FullyQualifiedClassType qualifiedClass = injectionTarget.addNewInjectionTargetClass();
                        JavaIdentifierType javaType = injectionTarget.addNewInjectionTargetName();
                        if (method != null) {
                            qualifiedClass.setStringValue(method.getDeclaringClass().getName());
                            javaType.setStringValue(method.getName().substring(3));
                            injectionTarget.setInjectionTargetClass(qualifiedClass);
                            injectionTarget.setInjectionTargetName(javaType);
                        } else if (field != null) {
                            qualifiedClass.setStringValue(field.getDeclaringClass().getName());
                            javaType.setStringValue(field.getName());
                            injectionTarget.setInjectionTargetClass(qualifiedClass);
                            injectionTarget.setInjectionTargetName(javaType);
                        }
                    }
                }
                catch (Exception anyException) {
                    log.debug((Object)"EJBAnnotationHelper: Exception caught while processing <UNKNOWN>");
                    anyException.printStackTrace();
                }
            }
        }
        log.debug((Object)"addEJB(): Exit");
    }

    private static void validateDD(AnnotatedApp annotatedApp) throws Exception {
        log.debug((Object)("validateDD( " + ((Object)annotatedApp).toString() + " ): Entry"));
        XmlBeansUtil.parse((String)((Object)annotatedApp).toString());
        log.debug((Object)"validateDD(): Exit");
    }
}

