/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.xbeans.javaee.FullyQualifiedClassType;
import org.apache.geronimo.xbeans.javaee.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee.JavaIdentifierType;
import org.apache.xmlbeans.XmlException;

public class AnnotationHelper {
    protected static String getName(String name, Method method, Field field) {
        String resourceName = name;
        if (resourceName.equals("")) {
            if (method != null) {
                StringBuilder stringBuilder = new StringBuilder(method.getName().substring(3));
                stringBuilder.setCharAt(0, Character.toLowerCase(stringBuilder.charAt(0)));
                resourceName = method.getDeclaringClass().getName() + "/" + stringBuilder.toString();
            } else if (field != null) {
                resourceName = field.getDeclaringClass().getName() + "/" + field.getName();
            }
        }
        return resourceName;
    }

    protected static String getInjectionJavaType(Method method, Field field) {
        if (method != null) {
            String injectionJavaType = method.getName().substring(3);
            StringBuilder stringBuilder = new StringBuilder(injectionJavaType);
            stringBuilder.setCharAt(0, Character.toLowerCase(stringBuilder.charAt(0)));
            return stringBuilder.toString();
        }
        if (field != null) {
            return field.getName();
        }
        throw new IllegalArgumentException("You must supply exactly one of Method, Field");
    }

    protected static String getInjectionClass(Method method, Field field) {
        if (method != null) {
            return method.getDeclaringClass().getName();
        }
        if (field != null) {
            return field.getDeclaringClass().getName();
        }
        throw new IllegalArgumentException("You must supply exactly one of Method, Field");
    }

    protected static boolean hasTarget(Method method, Field field, InjectionTargetType[] targets) {
        String injectionJavaType = AnnotationHelper.getInjectionJavaType(method, field);
        String injectionClass = AnnotationHelper.getInjectionClass(method, field);
        for (InjectionTargetType target : targets) {
            if (!injectionClass.equals(target.getInjectionTargetClass().getStringValue().trim()) || !injectionJavaType.equals(target.getInjectionTargetName().getStringValue().trim())) continue;
            return true;
        }
        return false;
    }

    protected static void configureInjectionTarget(InjectionTargetType injectionTarget, Method method, Field field) {
        String injectionJavaType = AnnotationHelper.getInjectionJavaType(method, field);
        String injectionClass = AnnotationHelper.getInjectionClass(method, field);
        FullyQualifiedClassType qualifiedClass = injectionTarget.addNewInjectionTargetClass();
        JavaIdentifierType javaType = injectionTarget.addNewInjectionTargetName();
        qualifiedClass.setStringValue(injectionClass);
        javaType.setStringValue(injectionJavaType);
    }

    protected static void validateDD(AnnotatedApp annotatedApp) throws DeploymentException {
        try {
            XmlBeansUtil.parse((String)((Object)annotatedApp).toString());
        }
        catch (XmlException e) {
            throw new DeploymentException("Result of processing web service refs invalid.", (Throwable)e);
        }
    }
}

