/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.jws.HandlerChain;
import javax.xml.ws.WebServiceRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotationHelper;
import org.apache.geronimo.xbeans.javaee.HandlerChainType;
import org.apache.geronimo.xbeans.javaee.HandlerChainsDocument;
import org.apache.geronimo.xbeans.javaee.HandlerChainsType;
import org.apache.geronimo.xbeans.javaee.PortComponentHandlerType;
import org.apache.geronimo.xbeans.javaee.ServiceRefHandlerChainType;
import org.apache.geronimo.xbeans.javaee.ServiceRefHandlerChainsType;
import org.apache.geronimo.xbeans.javaee.ServiceRefHandlerType;
import org.apache.geronimo.xbeans.javaee.ServiceRefType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;

public final class HandlerChainAnnotationHelper
extends AnnotationHelper {
    private static final Log log = LogFactory.getLog(HandlerChainAnnotationHelper.class);

    private HandlerChainAnnotationHelper() {
    }

    public static void processAnnotations(AnnotatedApp annotatedApp, ClassFinder classFinder) throws DeploymentException {
        if (annotatedApp != null && classFinder.isAnnotationPresent(HandlerChain.class)) {
            HandlerChainAnnotationHelper.processHandlerChain(annotatedApp, classFinder);
        }
    }

    private static void processHandlerChain(AnnotatedApp annotatedApp, ClassFinder classFinder) throws DeploymentException {
        HandlerChain handlerChain;
        log.debug((Object)("processHandlerChain(): Entry: AnnotatedApp: " + ((Object)annotatedApp).toString()));
        List methodswithHandlerChain = classFinder.findAnnotatedMethods(HandlerChain.class);
        List fieldswithHandlerChain = classFinder.findAnnotatedFields(HandlerChain.class);
        for (Method method : methodswithHandlerChain) {
            handlerChain = method.getAnnotation(HandlerChain.class);
            if (handlerChain == null) continue;
            HandlerChainAnnotationHelper.addHandlerChain(annotatedApp, handlerChain, null, method, null);
        }
        for (Field field : fieldswithHandlerChain) {
            handlerChain = field.getAnnotation(HandlerChain.class);
            if (handlerChain == null) continue;
            HandlerChainAnnotationHelper.addHandlerChain(annotatedApp, handlerChain, null, null, field);
        }
        HandlerChainAnnotationHelper.validateDD(annotatedApp);
        log.debug((Object)("processHandlerChain(): Exit: AnnotatedApp: " + ((Object)annotatedApp).toString()));
    }

    private static void addHandlerChain(AnnotatedApp annotatedApp, HandlerChain annotation, Class cls, Method method, Field field) {
        log.debug((Object)("addHandlerChain( [annotatedApp] " + ((Object)annotatedApp).toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "," + '\n' + "[method] " + (method != null ? method.getName() : null) + "," + '\n' + "[field] " + (field != null ? field.getName() : null) + " ): Entry"));
        String handlerChainFile = annotation.file();
        log.debug((Object)("addHandlerChain(): handlerChainFile: " + handlerChainFile));
        WebServiceRef webServiceRef = null;
        if (method != null) {
            webServiceRef = method.getAnnotation(WebServiceRef.class);
        } else if (field != null) {
            webServiceRef = field.getAnnotation(WebServiceRef.class);
        }
        String serviceRefName = webServiceRef != null ? webServiceRef.name() : annotation.name();
        if (serviceRefName.equals("")) {
            serviceRefName = HandlerChainAnnotationHelper.getInjectionJavaType(method, field);
        }
        log.debug((Object)("addHandlerChain().serviceRefName : " + serviceRefName));
        if (!serviceRefName.equals("") && !handlerChainFile.equals("")) {
            try {
                URL url;
                block16: {
                    url = null;
                    try {
                        url = new URL(handlerChainFile);
                    }
                    catch (MalformedURLException mfe) {
                        log.debug((Object)"addHandlerChain().MalformedURLException");
                        if (cls != null) {
                            url = HandlerChainAnnotationHelper.getURL(cls.getClass(), handlerChainFile);
                        }
                        if (method != null) {
                            url = HandlerChainAnnotationHelper.getURL(method.getDeclaringClass(), handlerChainFile);
                        }
                        if (field == null) break block16;
                        url = HandlerChainAnnotationHelper.getURL(field.getDeclaringClass(), handlerChainFile);
                    }
                }
                if (url != null) {
                    ServiceRefType[] serviceRefs = annotatedApp.getServiceRefArray();
                    boolean exists = false;
                    for (ServiceRefType serviceRef : serviceRefs) {
                        if (!serviceRef.getServiceRefName().getStringValue().trim().equals(serviceRefName) || serviceRef.isSetHandlerChains()) continue;
                        HandlerChainAnnotationHelper.insertHandlers(serviceRef, url);
                        exists = true;
                        break;
                    }
                    if (exists) {
                        log.debug((Object)("HandlerChainAnnotationHelper: <service-ref> entry found: " + serviceRefName));
                    } else {
                        log.debug((Object)("HandlerChainAnnotationHelper: <service-ref> entry NOT found: " + serviceRefName));
                    }
                } else {
                    log.debug((Object)("HandlerChainAnnotationHelper: Handler chain file NOT found: " + handlerChainFile));
                }
            }
            catch (Exception anyException) {
                log.debug((Object)"HandlerChainAnnotationHelper: Exception caught while processing <handler-chain>");
            }
        }
        log.debug((Object)"addHandlerChain(): Exit");
    }

    private static URL getURL(Class clazz, String file) {
        log.debug((Object)("getURL( " + clazz.getName() + ", " + file + " ): Entry"));
        URL url = clazz.getResource(file);
        if (url == null) {
            url = Thread.currentThread().getContextClassLoader().getResource(file);
        }
        if (url == null) {
            String loc = clazz.getPackage().getName().replace('.', '/') + "/" + file;
            url = Thread.currentThread().getContextClassLoader().getResource(loc);
        }
        log.debug((Object)("getURL(): Exit: url: " + (url != null ? url.toString() : null)));
        return url;
    }

    public static void insertHandlers(ServiceRefType serviceRef, HandlerChain annotation, Class clazz) {
        String handlerChainFile = annotation.file();
        log.debug((Object)("handlerChainFile: " + handlerChainFile));
        if (handlerChainFile == null || handlerChainFile.trim().length() == 0) {
            return;
        }
        URL url = null;
        try {
            url = new URL(handlerChainFile);
        }
        catch (MalformedURLException mfe) {
            url = HandlerChainAnnotationHelper.getURL(clazz, handlerChainFile);
        }
        if (url != null) {
            try {
                HandlerChainAnnotationHelper.insertHandlers(serviceRef, url);
            }
            catch (Exception e) {
                log.debug((Object)"Error while processing <handler-chain>", (Throwable)e);
            }
        }
    }

    public static void insertHandlers(ServiceRefType serviceRef, URL url) throws Exception {
        XmlObject xml = XmlBeansUtil.parse((URL)url, null);
        HandlerChainsDocument hcd = (HandlerChainsDocument)XmlBeansUtil.typedCopy((XmlObject)xml, (SchemaType)HandlerChainsDocument.type);
        HandlerChainsType handlerChains = hcd.getHandlerChains();
        ServiceRefHandlerChainsType serviceRefHandlerChains = serviceRef.addNewHandlerChains();
        for (HandlerChainType handlerChain : handlerChains.getHandlerChainArray()) {
            ServiceRefHandlerChainType serviceRefHandlerChain = serviceRefHandlerChains.addNewHandlerChain();
            if (handlerChain.getPortNamePattern() != null) {
                serviceRefHandlerChain.setPortNamePattern(handlerChain.getPortNamePattern());
            }
            if (handlerChain.getServiceNamePattern() != null) {
                serviceRefHandlerChain.setServiceNamePattern(handlerChain.getServiceNamePattern());
            }
            if (handlerChain.getProtocolBindings() != null) {
                serviceRefHandlerChain.setProtocolBindings(handlerChain.getProtocolBindings());
            }
            for (PortComponentHandlerType handler : handlerChain.getHandlerArray()) {
                ServiceRefHandlerType serviceRefHandler = serviceRefHandlerChain.addNewHandler();
                serviceRefHandler.setHandlerName(handler.getHandlerName());
                serviceRefHandler.setHandlerClass(handler.getHandlerClass());
                if (handler.getDescriptionArray().length > 0) {
                    serviceRefHandler.setDescriptionArray(handler.getDescriptionArray());
                }
                if (handler.getInitParamArray().length > 0) {
                    serviceRefHandler.setInitParamArray(handler.getInitParamArray());
                }
                if (handler.getSoapHeaderArray().length > 0) {
                    serviceRefHandler.setSoapHeaderArray(handler.getSoapHeaderArray());
                }
                if (handler.getSoapRoleArray().length <= 0) continue;
                serviceRefHandler.setSoapRoleArray(handler.getSoapRoleArray());
            }
        }
    }
}

