/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.hot;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.hot.DirectoryMonitor;
import org.apache.geronimo.deployment.plugin.factories.DeploymentFactoryWithKernel;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.util.JarUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleHandler
implements DirectoryMonitor.MonitorListener {
    private static final Logger log = LoggerFactory.getLogger(ModuleHandler.class);
    private static final String BAD_LAYOUT_MESSAGE = "CANNOT DEPLOY: It looks like you unpacked an application or module directly into the hot deployment directory.  THIS DOES NOT WORK.  You need to unpack into a subdirectory directly under the hot deploy directory.  For example, if the hot deploy directory is 'deploy/' and your file is 'webapp.war' then you could unpack it into a directory 'deploy/webapp.war/'";
    private final DeploymentFactory factory;
    private final ConfigurationManager configManager;
    private String deploymentURI = "deployer:geronimo:inVM";
    private String deploymentUser;
    private String deploymentPassword;
    private volatile String workingOnConfigId;

    public ModuleHandler(Kernel kernel, ConfigurationManager configManager) {
        this.factory = new DeploymentFactoryWithKernel(kernel);
        this.configManager = configManager;
    }

    public String getDeploymentUser() {
        return this.deploymentUser;
    }

    public void setDeploymentUser(String deploymentUser) {
        this.deploymentUser = deploymentUser;
    }

    public String getDeploymentPassword() {
        return this.deploymentPassword;
    }

    public void setDeploymentPassword(String deploymentPassword) {
        this.deploymentPassword = deploymentPassword;
    }

    public String getDeploymentURI() {
        return this.deploymentURI;
    }

    public void setDeploymentURI(String deploymentURI) {
        if (deploymentURI != null && !deploymentURI.trim().equals("")) {
            this.deploymentURI = deploymentURI.trim();
        }
    }

    public String getWorkingOnConfigId() {
        return this.workingOnConfigId;
    }

    private DeploymentManager getDeploymentManager() throws DeploymentManagerCreationException {
        DeploymentManager manager = this.factory.getDeploymentManager(this.deploymentURI, this.deploymentUser, this.deploymentPassword);
        if (manager instanceof JMXDeploymentManager) {
            ((JMXDeploymentManager)manager).setLogConfiguration(false, true);
        }
        return manager;
    }

    @Override
    public void scanComplete(Collection<DirectoryMonitor.FileInfo> addedFiles, Collection<DirectoryMonitor.FileInfo> modifiedFiles, Collection<DirectoryMonitor.FileInfo> deletedFiles) {
        String newModuleId;
        String moduleId;
        File file;
        for (DirectoryMonitor.FileInfo deletedFile : deletedFiles) {
            file = new File(deletedFile.getPath());
            moduleId = deletedFile.getConfigId();
            if (moduleId == null) {
                log.info("File: {} was removed", (Object)deletedFile.getPath());
                continue;
            }
            if (this.isModuleDeployed(moduleId)) {
                if (deletedFile.getModified() < this.getModuleLastModified(moduleId)) {
                    if (this.fileRemoved(file, moduleId)) {
                        log.info("File: {} was removed, and module: {} was succussfully undeployed.", (Object)deletedFile.getPath(), (Object)moduleId);
                        continue;
                    }
                    log.warn("File: {} was removed, but module: {} can not be undeployed.", (Object)deletedFile.getPath(), (Object)moduleId);
                    continue;
                }
                log.warn("File: {} was removed, but module: {} was not undeployed, since the deployed one is older, i.e the module was not deployed by the file you just deleted.", (Object)deletedFile.getPath(), (Object)moduleId);
                continue;
            }
            log.warn("Module: {} has been already undeployed in other ways", (Object)moduleId);
        }
        for (DirectoryMonitor.FileInfo addedFile : addedFiles) {
            file = new File(addedFile.getPath());
            moduleId = addedFile.getConfigId();
            if (moduleId == null) {
                moduleId = this.calculateModuleId(file);
                if (this.isModuleDeployed(moduleId)) {
                    log.warn("File: {} was added, but Module: {} has been deployed before. Please undeploy the old one first, and then re-add this file.", (Object)addedFile.getPath(), (Object)moduleId);
                    continue;
                }
                newModuleId = this.fileAdded(file);
                if (newModuleId != null) {
                    moduleId = newModuleId.length() == 0 ? moduleId : newModuleId;
                    addedFile.setConfigId(moduleId);
                    log.info("File: {} was added, and Module: {} was succussfully deployed.", (Object)addedFile.getPath(), (Object)moduleId);
                    continue;
                }
                log.warn("File: {} was added, but can not be deployed.", (Object)addedFile.getPath());
                continue;
            }
            log.error("File: {} is not a new added file!", (Object)addedFile.getPath());
        }
        for (DirectoryMonitor.FileInfo modifiedFile : modifiedFiles) {
            file = new File(modifiedFile.getPath());
            moduleId = modifiedFile.getConfigId();
            if (moduleId == null) {
                moduleId = this.calculateModuleId(file);
                if (this.isModuleDeployed(moduleId)) {
                    log.warn("File: {} was modified, but Module: {} has been deployed before by other means. Please undeploy the old one first, and then re-add this file.", (Object)modifiedFile.getPath(), (Object)moduleId);
                    continue;
                }
                newModuleId = this.fileAdded(file);
                if (newModuleId != null) {
                    moduleId = newModuleId.length() == 0 ? moduleId : newModuleId;
                    modifiedFile.setConfigId(moduleId);
                    log.info("File: {} was modified, and Module: {} was succussfully deployed.", (Object)modifiedFile.getPath(), (Object)moduleId);
                    continue;
                }
                log.warn("File: {} was modified, but can not be deployed.", (Object)modifiedFile.getPath());
                continue;
            }
            if (this.isModuleDeployed(moduleId)) {
                newModuleId = this.fileUpdated(file, moduleId);
                if (newModuleId != null) {
                    moduleId = newModuleId.length() == 0 ? moduleId : newModuleId;
                    modifiedFile.setConfigId(moduleId);
                    log.info("File: {} was modified, and Module: {} was succussfully re-deployed.", (Object)modifiedFile.getPath(), (Object)moduleId);
                    continue;
                }
                log.warn("File: {} was modified, but Module: {} can not be re-deployed.", (Object)modifiedFile.getPath(), (Object)moduleId);
                continue;
            }
            newModuleId = this.fileAdded(file);
            if (newModuleId != null) {
                moduleId = newModuleId.length() == 0 ? moduleId : newModuleId;
                modifiedFile.setConfigId(moduleId);
                log.info("File: {} was modified, and Module: {} was succussfully deployed.", (Object)modifiedFile.getPath(), (Object)moduleId);
                continue;
            }
            log.warn("File: {} was modified, but can not be deployed.", (Object)modifiedFile.getPath());
        }
    }

    private String calculateModuleId(File moduleFile) {
        String moduleId = null;
        try {
            moduleId = DeployUtils.extractModuleIdFromArchive((File)moduleFile);
        }
        catch (Exception e) {
            try {
                moduleId = DeployUtils.extractModuleIdFromPlan((File)moduleFile);
            }
            catch (Exception e2) {
                log.debug("Unable to calculate module ID for file " + moduleFile.getAbsolutePath() + " [" + e2.getMessage() + "]");
            }
        }
        if (moduleId == null) {
            int pos = moduleFile.getName().lastIndexOf(46);
            moduleId = pos > -1 ? moduleFile.getName().substring(0, pos) : moduleFile.getName();
            moduleId = this.guessModuleId(moduleId);
        }
        return moduleId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String guessModuleId(String moduleId) {
        DeploymentManager mgr = null;
        try {
            mgr = this.getDeploymentManager();
            Target[] targets = mgr.getTargets();
            TargetModuleID[] ids = mgr.getAvailableModules(null, targets);
            for (int j = 0; j < ids.length; ++j) {
                String[] parts = ids[j].getModuleID().split("/", -1);
                if (parts.length != 4 || parts[1] == null || !parts[1].equals(moduleId)) continue;
                String string = ids[j].getModuleID();
                return string;
            }
        }
        catch (Exception ex) {
            log.debug("Unable to guessModuleId", (Throwable)ex);
        }
        finally {
            if (mgr != null) {
                mgr.release();
            }
        }
        return moduleId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModuleDeployed(String configId) {
        DeploymentManager mgr = null;
        try {
            mgr = this.getDeploymentManager();
            Target[] targets = mgr.getTargets();
            TargetModuleID[] ids = mgr.getAvailableModules(null, targets);
            DeployUtils.identifyTargetModuleIDs((TargetModuleID[])ids, (String)configId, (boolean)true).toArray(new TargetModuleID[0]);
            boolean bl = true;
            return bl;
        }
        catch (DeploymentException e) {
            log.debug("Found new file in deploy directory on startup with ID " + configId);
        }
        catch (Exception e) {
            log.error("Unable to check status", (Throwable)e);
        }
        finally {
            if (mgr != null) {
                mgr.release();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fileAdded(File file) {
        boolean completed;
        TargetModuleID[] modules;
        block17: {
            log.info("Deploying " + file.getName());
            DeploymentManager mgr = null;
            modules = null;
            completed = false;
            try {
                mgr = this.getDeploymentManager();
                Target[] targets = mgr.getTargets();
                if (null == targets) {
                    throw new IllegalStateException("No target to distribute to");
                }
                targets = new Target[]{targets[0]};
                ProgressObject po = JarUtils.isJarFile((File)file) || file.isDirectory() ? mgr.distribute(targets, file, null) : mgr.distribute(targets, null, file);
                this.waitForProgress(po);
                if (po.getDeploymentStatus().isCompleted()) {
                    modules = po.getResultTargetModuleIDs();
                    po = mgr.start(modules);
                    this.waitForProgress(po);
                    if (po.getDeploymentStatus().isCompleted()) {
                        completed = true;
                    } else {
                        log.warn("Unable to start some modules for " + file.getAbsolutePath());
                    }
                    modules = po.getResultTargetModuleIDs();
                    for (int i = 0; i < modules.length; ++i) {
                        TargetModuleID result = modules[i];
                        log.info(DeployUtils.reformat((String)("Deployed " + result.getModuleID() + (targets.length > 1 ? " to " + result.getTarget().getName() : "") + (result.getWebURL() == null ? "" : " @ " + result.getWebURL())), (int)4, (int)72));
                        if (result.getChildTargetModuleID() == null) continue;
                        for (int j = 0; j < result.getChildTargetModuleID().length; ++j) {
                            TargetModuleID child = result.getChildTargetModuleID()[j];
                            log.info(DeployUtils.reformat((String)("  `-> " + child.getModuleID() + (child.getWebURL() == null ? "" : " @ " + child.getWebURL())), (int)4, (int)72));
                        }
                    }
                    break block17;
                }
                log.error("Unable to deploy: " + po.getDeploymentStatus().getMessage());
                String string = null;
                return string;
            }
            catch (DeploymentManagerCreationException e) {
                log.error("Unable to open deployer", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Unable to determine if file is a jar", (Throwable)e);
            }
            finally {
                if (mgr != null) {
                    mgr.release();
                }
            }
        }
        if (completed && modules != null) {
            if (modules.length == 1) {
                return modules[0].getModuleID();
            }
            return "";
        }
        if (modules != null) {
            return "";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fileUpdated(File file, String configId) {
        this.workingOnConfigId = configId;
        log.info("Redeploying " + file.getName());
        DeploymentManager mgr = null;
        TargetModuleID[] modules = null;
        try {
            mgr = this.getDeploymentManager();
            Target[] targets = mgr.getTargets();
            TargetModuleID[] ids = mgr.getAvailableModules(null, targets);
            ids = DeployUtils.identifyTargetModuleIDs((TargetModuleID[])ids, (String)configId, (boolean)true).toArray(new TargetModuleID[0]);
            ProgressObject po = JarUtils.isJarFile((File)file) || file.isDirectory() ? mgr.redeploy(ids, file, null) : mgr.redeploy(ids, null, file);
            this.waitForProgress(po);
            if (po.getDeploymentStatus().isCompleted()) {
                modules = po.getResultTargetModuleIDs();
                for (int i = 0; i < modules.length; ++i) {
                    TargetModuleID result = modules[i];
                    log.info(DeployUtils.reformat((String)("Redeployed " + result.getModuleID() + (targets.length > 1 ? " to " + result.getTarget().getName() : "") + (result.getWebURL() == null ? "" : " @ " + result.getWebURL())), (int)4, (int)72));
                    if (result.getChildTargetModuleID() == null) continue;
                    for (int j = 0; j < result.getChildTargetModuleID().length; ++j) {
                        TargetModuleID child = result.getChildTargetModuleID()[j];
                        log.info(DeployUtils.reformat((String)("  `-> " + child.getModuleID() + (child.getWebURL() == null ? "" : " @ " + child.getWebURL())), (int)4, (int)72));
                    }
                }
            } else {
                log.error("Unable to redeploy " + file.getAbsolutePath() + "(" + configId + ")" + po.getDeploymentStatus().getMessage());
            }
        }
        catch (DeploymentManagerCreationException e) {
            log.error("Unable to open deployer", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Unable to undeploy", (Throwable)e);
        }
        finally {
            if (mgr != null) {
                mgr.release();
            }
            this.workingOnConfigId = null;
        }
        if (modules != null) {
            if (modules.length == 1) {
                return modules[0].getModuleID();
            }
            return "";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fileRemoved(File file, String configId) {
        block10: {
            this.workingOnConfigId = configId;
            log.info("Undeploying " + file.getName());
            DeploymentManager mgr = null;
            try {
                mgr = this.getDeploymentManager();
                Target[] targets = mgr.getTargets();
                TargetModuleID[] ids = mgr.getAvailableModules(null, targets);
                ids = DeployUtils.identifyTargetModuleIDs((TargetModuleID[])ids, (String)configId, (boolean)true).toArray(new TargetModuleID[0]);
                ProgressObject po = mgr.undeploy(ids);
                this.waitForProgress(po);
                if (po.getDeploymentStatus().isCompleted()) {
                    TargetModuleID[] modules = po.getResultTargetModuleIDs();
                    for (int i = 0; i < modules.length; ++i) {
                        TargetModuleID result = modules[i];
                        log.info(DeployUtils.reformat((String)("Undeployed " + result.getModuleID() + (targets.length > 1 ? " to " + result.getTarget().getName() : "")), (int)4, (int)72));
                    }
                    break block10;
                }
                log.error("Unable to undeploy " + file.getAbsolutePath() + "(" + configId + ")" + po.getDeploymentStatus().getMessage());
                boolean bl = false;
                return bl;
            }
            catch (DeploymentManagerCreationException e) {
                log.error("Unable to open deployer", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                log.error("Unable to undeploy", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (mgr != null) {
                    mgr.release();
                }
                this.workingOnConfigId = null;
            }
        }
        return true;
    }

    private void waitForProgress(ProgressObject po) {
        while (po.getDeploymentStatus().isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public long getModuleLastModified(String configId) {
        try {
            Artifact art = this.configManager.getArtifactResolver().resolveInClassLoader(Artifact.create((String)configId));
            Configuration config = this.configManager.getConfiguration(art);
            File file = config.getConfigurationResolver().resolve(art);
            long lastModified = DirectoryMonitor.getLastModified(file);
            return lastModified;
        }
        catch (MissingDependencyException e) {
            log.error("Unknown configuration " + configId);
            return -1L;
        }
    }

    @Override
    public boolean validateFile(File file, String configId) {
        if (file.isDirectory() && (file.getName().equals("WEB-INF") || file.getName().equals("META-INF"))) {
            log.error("(" + file.getName() + ") " + BAD_LAYOUT_MESSAGE);
            return false;
        }
        return true;
    }
}

