/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.config;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.geronimo.farm.config.ExtendedJMXConnectorInfo;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.system.jmx.KernelDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicExtendedJMXConnectorInfo
implements ExtendedJMXConnectorInfo,
Serializable {
    private static Logger log = LoggerFactory.getLogger(BasicExtendedJMXConnectorInfo.class);
    private String username;
    private String password;
    private String protocol;
    private String host;
    private int port = -1;
    private String urlPath;
    private boolean local;

    public BasicExtendedJMXConnectorInfo() {
    }

    public BasicExtendedJMXConnectorInfo(String username, String password, String protocol, String host, int port, String urlPath, boolean local) {
        this.username = username;
        this.password = password;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.urlPath = urlPath;
        this.local = local;
    }

    public String getHost() {
        return this.host;
    }

    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public void setLocal(boolean local) {
        this.local = local;
    }

    @Override
    public JMXConnector connect() throws IOException {
        String url = this.getJmxURI();
        log.info("Attempting to connect to " + url + " with username " + this.getUsername() + " and password " + this.getPassword());
        Map<String, String[]> environment = Collections.singletonMap("jmx.remote.credentials", new String[]{this.getUsername(), this.getPassword()});
        return JMXConnectorFactory.connect(new JMXServiceURL(url), environment);
    }

    @Override
    public Kernel newKernel(JMXConnector jmxConnector) throws IOException {
        MBeanServerConnection mbServerConnection = jmxConnector.getMBeanServerConnection();
        return new KernelDelegate(mbServerConnection);
    }

    protected String getJmxURI() {
        return "service:jmx:rmi://" + this.getHost() + "/jndi/" + this.getProtocol() + "://" + this.getHost() + ":" + this.getPort() + "/" + this.getUrlPath();
    }
}

