/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.service;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geronimo.farm.service.NodeService;
import org.apache.geronimo.farm.service.NodeServiceTracker;
import org.apache.geronimo.farm.service.NodeServiceTrackerListener;
import org.apache.geronimo.farm.service.NodeServiceVitals;
import org.apache.geronimo.farm.service.NodeServiceVitalsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicNodeSerivceTracker
implements NodeServiceTracker {
    private static final Logger log = LoggerFactory.getLogger(BasicNodeSerivceTracker.class);
    private final Map<String, Map<String, NodeServiceVitals>> remoteNodeServices;
    private final Map<String, NodeServiceVitals> localServices;
    private final Set<NodeServiceTrackerListener> nodeServiceLisenters;
    private NodeServiceVitalsFactory serviceVitalsFactory;
    private final Executor executor = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        public Thread newThread(Runnable runable) {
            Thread t = new Thread(runable, "Multicast Discovery Agent Notifier");
            t.setDaemon(true);
            return t;
        }
    });

    public BasicNodeSerivceTracker() {
        this.remoteNodeServices = new HashMap<String, Map<String, NodeServiceVitals>>();
        this.nodeServiceLisenters = new HashSet<NodeServiceTrackerListener>();
        this.localServices = new HashMap<String, NodeServiceVitals>();
    }

    @Override
    public void registerLocalNodeService(URI localServiceURI) {
        this.localServices.put(localServiceURI.toString(), this.serviceVitalsFactory.createSerivceVitals(new NodeService(localServiceURI)));
    }

    @Override
    public void registerNodeService(String nodeName, URI serviceURI) {
        log.debug("registerNodeService:" + serviceURI + " to node:" + nodeName);
        Map<String, NodeServiceVitals> services = this.getNodeServicesInRemoteNode(nodeName);
        if (services.containsKey(serviceURI)) {
            log.debug("service heartbeat from service" + serviceURI + " of node:" + nodeName);
            services.get(serviceURI).heartbeat();
        } else {
            log.debug("fire service add event for service:" + serviceURI + " of node:" + nodeName);
            services.put(serviceURI.toString(), this.serviceVitalsFactory.createSerivceVitals(new NodeService(serviceURI)));
            this.fireServiceAddEvent(serviceURI);
        }
    }

    @Override
    public void registerNodeServices(String nodeName, Map<String, NodeServiceVitals> newNodeServices) {
        log.debug("registerNodeServices:" + newNodeServices + " to node:" + nodeName);
        Map<String, NodeServiceVitals> services = this.getNodeServicesInRemoteNode(nodeName);
        for (String newServiceURI : newNodeServices.keySet()) {
            if (services.containsKey(newServiceURI)) {
                log.debug("service heartbeat from service" + newServiceURI + " of node:" + nodeName);
                services.get(newServiceURI).heartbeat();
                continue;
            }
            log.debug("fire service add event for service:" + newServiceURI + " of node:" + nodeName);
            services.put(newServiceURI, newNodeServices.get(newServiceURI));
            this.fireServiceAddEvent(newNodeServices.get(newServiceURI).getService().getUri());
        }
    }

    @Override
    public void unregisterNodeService(String nodeName, URI serviceURI) {
        log.info("unregisterNodeServices:" + serviceURI + " to node:" + nodeName);
        Map<String, NodeServiceVitals> services = this.getNodeServicesInRemoteNode(nodeName);
        if (services.containsKey(serviceURI.toString())) {
            services.remove(serviceURI.toString());
            this.fireServiceRemovedEvent(serviceURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterNodeServices(String nodeName) {
        log.info("unregister all NodeServices for node:" + nodeName);
        Map<String, Map<String, NodeServiceVitals>> map = this.remoteNodeServices;
        synchronized (map) {
            Map<String, NodeServiceVitals> services = this.remoteNodeServices.remove(nodeName);
            for (NodeServiceVitals vitals : services.values()) {
                this.fireServiceRemovedEvent(vitals.getService().getUri());
            }
        }
    }

    @Override
    public Map<String, NodeServiceVitals> getNodeServicesInRemoteNode(String nodeName) {
        if (this.remoteNodeServices.get(nodeName) == null) {
            this.remoteNodeServices.put(nodeName, new HashMap());
        }
        return this.remoteNodeServices.get(nodeName);
    }

    @Override
    public Map<String, NodeServiceVitals> getLocalNodeServices() {
        return this.localServices;
    }

    @Override
    public Map<String, Map<String, NodeServiceVitals>> getAllRemoteNodeServices() {
        return this.remoteNodeServices;
    }

    @Override
    public void addNodeServiceTrackerListener(NodeServiceTrackerListener nodeServiceListener) {
        log.info("setNodeServiceListener " + nodeServiceListener);
        this.nodeServiceLisenters.add(nodeServiceListener);
    }

    void setServiceVitalsFactory(NodeServiceVitalsFactory _serviceVitalsFactory) {
        this.serviceVitalsFactory = _serviceVitalsFactory;
    }

    private void fireServiceRemovedEvent(final URI uri) {
        if (this.nodeServiceLisenters == null || this.nodeServiceLisenters.size() == 0) {
            return;
        }
        for (final NodeServiceTrackerListener listener : this.nodeServiceLisenters) {
            this.executor.execute(new Runnable(){

                public void run() {
                    if (listener != null) {
                        listener.serviceRemoved(uri);
                    }
                }
            });
        }
    }

    private void fireServiceAddEvent(final URI uri) {
        if (this.nodeServiceLisenters == null || this.nodeServiceLisenters.size() == 0) {
            log.info("nodeServiceLisenters is null or nodeServiceLisenters.size =0");
            return;
        }
        for (final NodeServiceTrackerListener listener : this.nodeServiceLisenters) {
            this.executor.execute(new Runnable(){

                public void run() {
                    if (listener != null) {
                        log.info("listener.serviceAdded(uri):" + uri);
                        listener.serviceAdded(uri);
                    }
                }
            });
        }
    }
}

